/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.internal.StatisticDescriptorImpl;
import com.gemstone.gemfire.internal.admin.Stat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RemoteStat
implements Stat,
DataSerializable {
    private static final long serialVersionUID = 8263951659282343027L;
    private String name;
    private byte typeCode;
    private int id;
    private String units;
    private String desc;
    private Number value;
    private boolean isCounter;

    public RemoteStat(Statistics rsrc, StatisticDescriptor stat) {
        this.id = stat.getId();
        this.name = stat.getName();
        this.units = stat.getUnit();
        this.isCounter = stat.isCounter();
        this.desc = stat.getDescription();
        this.typeCode = ((StatisticDescriptorImpl)stat).getTypeCode();
        this.value = rsrc.get(stat);
    }

    public RemoteStat() {
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    @Override
    public String getUnits() {
        return this.units;
    }

    @Override
    public boolean isCounter() {
        return this.isCounter;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return StatisticDescriptorImpl.getTypeCodeName(this.typeCode);
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public String toString() {
        return "<STAT name=" + this.getName() + " type=" + this.getType() + " units=" + this.getUnits() + " isCounter=" + this.isCounter() + " value=" + this.getValue() + " desc=\"" + this.getDescription() + "\">";
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.name, out);
        out.writeByte(this.typeCode);
        out.writeInt(this.id);
        DataSerializer.writeString(this.units, out);
        DataSerializer.writeString(this.desc, out);
        DataSerializer.writeObject(this.value, out);
        out.writeBoolean(this.isCounter);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.name = DataSerializer.readString(in);
        this.typeCode = in.readByte();
        this.id = in.readInt();
        this.units = DataSerializer.readString(in);
        this.desc = DataSerializer.readString(in);
        this.value = (Number)DataSerializer.readObject(in);
        this.isCounter = in.readBoolean();
    }
}

