/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.cache.CacheStatistics;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RemoteCacheStatistics
implements CacheStatistics,
DataSerializable {
    private static final long serialVersionUID = 53585856563375154L;
    private long lastModified;
    private long lastAccessed;
    private long hitCount;
    private long missCount;
    private float hitRatio;

    public RemoteCacheStatistics(CacheStatistics stats) {
        this.lastModified = stats.getLastModifiedTime();
        this.lastAccessed = stats.getLastAccessedTime();
        this.hitCount = stats.getHitCount();
        this.missCount = stats.getMissCount();
        this.hitRatio = stats.getHitRatio();
    }

    public RemoteCacheStatistics() {
    }

    @Override
    public long getLastModifiedTime() {
        return this.lastModified;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessed;
    }

    @Override
    public long getHitCount() {
        return this.hitCount;
    }

    @Override
    public long getMissCount() {
        return this.missCount;
    }

    @Override
    public float getHitRatio() {
        return this.hitRatio;
    }

    @Override
    public void resetCounts() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeLong(this.lastModified);
        out.writeLong(this.lastAccessed);
        out.writeLong(this.hitCount);
        out.writeLong(this.missCount);
        out.writeFloat(this.hitRatio);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.lastModified = in.readLong();
        this.lastAccessed = in.readLong();
        this.hitCount = in.readLong();
        this.missCount = in.readLong();
        this.hitRatio = in.readFloat();
    }
}

