/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.ClientSession;
import com.gemstone.gemfire.cache.InterestRegistrationListener;
import com.gemstone.gemfire.cache.server.ClientSubscriptionConfig;
import com.gemstone.gemfire.cache.server.ServerLoad;
import com.gemstone.gemfire.cache.server.ServerLoadProbe;
import com.gemstone.gemfire.cache.server.ServerLoadProbeAdapter;
import com.gemstone.gemfire.cache.server.ServerMetrics;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.admin.AdminBridgeServer;
import com.gemstone.gemfire.internal.cache.AbstractCacheServer;
import com.gemstone.gemfire.internal.cache.CacheServerImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;

public class RemoteBridgeServer
extends AbstractCacheServer
implements AdminBridgeServer,
DataSerializable {
    private static final long serialVersionUID = 8417391824652384959L;
    private boolean isRunning;
    private int id;

    RemoteBridgeServer(CacheServerImpl impl) {
        super(null);
        this.port = impl.getPort();
        this.bindAddress = impl.getBindAddress();
        this.hostnameForClients = impl.getHostnameForClients();
        if (CacheServerImpl.ENABLE_NOTIFY_BY_SUBSCRIPTION_FALSE) {
            this.notifyBySubscription = impl.getNotifyBySubscription();
        }
        this.socketBufferSize = impl.getSocketBufferSize();
        this.maximumTimeBetweenPings = impl.getMaximumTimeBetweenPings();
        this.isRunning = impl.isRunning();
        this.maxConnections = impl.getMaxConnections();
        this.maxThreads = impl.getMaxThreads();
        this.id = System.identityHashCode(impl);
        this.maximumMessageCount = impl.getMaximumMessageCount();
        this.messageTimeToLive = impl.getMessageTimeToLive();
        this.groups = impl.getGroups();
        this.loadProbe = this.getProbe(impl.getLoadProbe());
        this.loadPollInterval = impl.getLoadPollInterval();
        this.tcpNoDelay = impl.getTcpNoDelay();
        ClientSubscriptionConfig cscimpl = impl.getClientSubscriptionConfig();
        this.clientSubscriptionConfig.setEvictionPolicy(cscimpl.getEvictionPolicy());
        this.clientSubscriptionConfig.setCapacity(cscimpl.getCapacity());
        String diskStoreName = cscimpl.getDiskStoreName();
        if (diskStoreName != null) {
            this.clientSubscriptionConfig.setDiskStoreName(diskStoreName);
        } else {
            this.clientSubscriptionConfig.setOverflowDirectory(cscimpl.getOverflowDirectory());
        }
    }

    private ServerLoadProbe getProbe(ServerLoadProbe probe) {
        if (probe == null) {
            return new RemoteLoadProbe("");
        }
        if (probe instanceof Serializable) {
            return probe;
        }
        return new RemoteLoadProbe(probe.toString());
    }

    public RemoteBridgeServer() {
        super(null);
    }

    @Override
    public void start() throws IOException {
        throw new UnsupportedOperationException(LocalizedStrings.RemoteBridgeServer_A_REMOTE_BRIDGESERVER_CANNOT_BE_STARTED.toLocalizedString());
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException(LocalizedStrings.RemoteBridgeServer_A_REMOTE_BRIDGESERVER_CANNOT_BE_STOPPED.toLocalizedString());
    }

    @Override
    public Cache getCache() {
        throw new UnsupportedOperationException(LocalizedStrings.RemoteBridgeServer_CANNOT_GET_THE_CACHE_OF_A_REMOTE_BRIDGESERVER.toLocalizedString());
    }

    @Override
    public ClientSession getClientSession(String durableClientId) {
        String s = LocalizedStrings.RemoteBridgeServer_CANNOT_GET_CLIENT_SESSION.toLocalizedString();
        throw new UnsupportedOperationException(s);
    }

    @Override
    public ClientSession getClientSession(DistributedMember member) {
        String s = LocalizedStrings.RemoteBridgeServer_CANNOT_GET_CLIENT_SESSION.toLocalizedString();
        throw new UnsupportedOperationException(s);
    }

    public Set getAllClientSessions() {
        String s = LocalizedStrings.RemoteBridgeServer_CANNOT_GET_ALL_CLIENT_SESSIONS.toLocalizedString();
        throw new UnsupportedOperationException(s);
    }

    @Override
    public ClientSubscriptionConfig getClientSubscriptionConfig() {
        return this.clientSubscriptionConfig;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.port);
        out.writeBoolean(this.notifyBySubscription);
        out.writeBoolean(this.isRunning);
        out.writeInt(this.maxConnections);
        out.writeInt(this.id);
        out.writeInt(this.maximumTimeBetweenPings);
        out.writeInt(this.maximumMessageCount);
        out.writeInt(this.messageTimeToLive);
        out.writeInt(this.maxThreads);
        DataSerializer.writeString(this.bindAddress, out);
        DataSerializer.writeStringArray(this.groups, out);
        DataSerializer.writeString(this.hostnameForClients, out);
        DataSerializer.writeObject(this.loadProbe, out);
        DataSerializer.writePrimitiveLong(this.loadPollInterval, out);
        out.writeInt(this.socketBufferSize);
        out.writeBoolean(this.tcpNoDelay);
        out.writeInt(this.getClientSubscriptionConfig().getCapacity());
        DataSerializer.writeString(this.getClientSubscriptionConfig().getEvictionPolicy(), out);
        DataSerializer.writeString(this.getClientSubscriptionConfig().getDiskStoreName(), out);
        if (this.getClientSubscriptionConfig().getDiskStoreName() == null) {
            DataSerializer.writeString(this.getClientSubscriptionConfig().getOverflowDirectory(), out);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.port = in.readInt();
        this.notifyBySubscription = in.readBoolean();
        this.isRunning = in.readBoolean();
        this.maxConnections = in.readInt();
        this.id = in.readInt();
        this.maximumTimeBetweenPings = in.readInt();
        this.maximumMessageCount = in.readInt();
        this.messageTimeToLive = in.readInt();
        this.maxThreads = in.readInt();
        this.setBindAddress(DataSerializer.readString(in));
        this.setGroups(DataSerializer.readStringArray(in));
        this.setHostnameForClients(DataSerializer.readString(in));
        this.setLoadProbe((ServerLoadProbe)DataSerializer.readObject(in));
        this.setLoadPollInterval(DataSerializer.readPrimitiveLong(in));
        this.socketBufferSize = in.readInt();
        this.tcpNoDelay = in.readBoolean();
        this.getClientSubscriptionConfig().setCapacity(in.readInt());
        this.getClientSubscriptionConfig().setEvictionPolicy(DataSerializer.readString(in));
        String diskStoreName = DataSerializer.readString(in);
        if (diskStoreName != null) {
            this.getClientSubscriptionConfig().setDiskStoreName(diskStoreName);
        } else {
            this.getClientSubscriptionConfig().setOverflowDirectory(DataSerializer.readString(in));
        }
    }

    @Override
    public void registerInterestRegistrationListener(InterestRegistrationListener listener) {
        String s = LocalizedStrings.RemoteBridgeServer_INTERESTREGISTRATIONLISTENERS_CANNOT_BE_REGISTERED_ON_A_REMOTE_BRIDGESERVER.toLocalizedString();
        throw new UnsupportedOperationException(s);
    }

    @Override
    public void unregisterInterestRegistrationListener(InterestRegistrationListener listener) {
        String s = LocalizedStrings.RemoteBridgeServer_INTERESTREGISTRATIONLISTENERS_CANNOT_BE_UNREGISTERED_FROM_A_REMOTE_BRIDGESERVER.toLocalizedString();
        throw new UnsupportedOperationException(s);
    }

    public Set getInterestRegistrationListeners() {
        String s = LocalizedStrings.RemoteBridgeServer_INTERESTREGISTRATIONLISTENERS_CANNOT_BE_RETRIEVED_FROM_A_REMOTE_BRIDGESERVER.toLocalizedString();
        throw new UnsupportedOperationException(s);
    }

    private static class RemoteLoadProbe
    extends ServerLoadProbeAdapter {
        private final String desc;

        public RemoteLoadProbe(String desc) {
            this.desc = desc;
        }

        @Override
        public ServerLoad getLoad(ServerMetrics metrics) {
            return null;
        }

        public String toString() {
            return this.desc;
        }
    }
}

