/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.RegionSubRegionSnapshot;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.Cancellable;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class RegionSubRegionsSizeResponse
extends AdminResponse
implements Cancellable {
    private static final Logger logger = LogService.getLogger();
    private RegionSubRegionSnapshot snapshot;
    private boolean cancelled;

    public RegionSubRegionSnapshot getSnapshot() {
        return this.snapshot;
    }

    public static RegionSubRegionsSizeResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        RegionSubRegionsSizeResponse m = new RegionSubRegionsSizeResponse();
        m.setRecipient(recipient);
        m.snapshot = null;
        m.cancelled = false;
        return m;
    }

    public void populateSnapshot(DistributionManager dm) {
        if (this.cancelled) {
            return;
        }
        InternalDistributedSystem sys = dm.getSystem();
        GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getInstance(sys);
        if (this.cancelled) {
            return;
        }
        RegionSubRegionSnapshot root = new RegionSubRegionSnapshot();
        root.setName("Root");
        root.setParent(null);
        root.setEntryCount(0);
        Set rootRegions = cache.rootRegions();
        this.snapshot = root;
        this.populateRegionSubRegions(root, rootRegions, cache);
    }

    void populateRegionSubRegions(RegionSubRegionSnapshot parentSnapShot, Set regions, GemFireCacheImpl cache) {
        if (this.cancelled) {
            return;
        }
        Region subRegion2 = null;
        RegionSubRegionSnapshot subRegionSnapShot = null;
        for (Region subRegion2 : regions) {
            try {
                subRegionSnapShot = new RegionSubRegionSnapshot(subRegion2);
                parentSnapShot.addSubRegion(subRegionSnapShot);
                Set<Region<?, ?>> subRegions = subRegion2.subregions(false);
                this.populateRegionSubRegions(subRegionSnapShot, subRegions, cache);
            }
            catch (Exception e) {
                logger.debug("Failed to create snapshot for region: {}. Continuing with next region.", new Object[]{subRegion2.getFullPath(), e});
            }
        }
    }

    @Override
    public synchronized void cancel() {
        this.cancelled = true;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeBoolean(this.cancelled);
        DataSerializer.writeObject(this.snapshot, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.cancelled = in.readBoolean();
        this.snapshot = (RegionSubRegionSnapshot)DataSerializer.readObject(in);
    }

    @Override
    public int getDSFID() {
        return 1070;
    }

    @Override
    public String toString() {
        return "RegionSubRegionsSizeResponse [from=" + this.getRecipient() + " " + (this.snapshot == null ? "null" : this.snapshot.toString());
    }
}

