/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.Cancellable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;

public final class RegionSizeResponse
extends AdminResponse
implements Cancellable {
    private int entryCount;
    private int subregionCount;
    private transient boolean cancelled;

    public static RegionSizeResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        RegionSizeResponse m = new RegionSizeResponse();
        m.setRecipient(recipient);
        return m;
    }

    public void calcSize(Region r) {
        if (this.cancelled) {
            return;
        }
        Set nameSet = r.keys();
        if (this.cancelled) {
            return;
        }
        this.entryCount = nameSet.size();
        Set<Region<?, ?>> subRegions = r.subregions(false);
        if (this.cancelled) {
            return;
        }
        this.subregionCount = subRegions.size();
    }

    @Override
    public synchronized void cancel() {
        this.cancelled = true;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public int getSubregionCount() {
        return this.subregionCount;
    }

    @Override
    public int getDSFID() {
        return 1046;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.entryCount);
        out.writeInt(this.subregionCount);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.entryCount = in.readInt();
        this.subregionCount = in.readInt();
    }

    @Override
    public String toString() {
        return "RegionSizeResponse from " + this.getRecipient();
    }
}

