/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.Cancellable;
import com.gemstone.gemfire.internal.admin.remote.CancellationRegistry;
import com.gemstone.gemfire.internal.admin.remote.RegionAdminRequest;
import com.gemstone.gemfire.internal.admin.remote.RegionSizeResponse;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class RegionSizeRequest
extends RegionAdminRequest
implements Cancellable {
    private transient boolean cancelled;
    private transient RegionSizeResponse resp;

    public static RegionSizeRequest create() {
        RegionSizeRequest m = new RegionSizeRequest();
        return m;
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        Assert.assertTrue(this.getSender() != null);
        CancellationRegistry.getInstance().registerMessage(this);
        this.resp = RegionSizeResponse.create(dm, this.getSender());
        if (this.cancelled) {
            return null;
        }
        this.resp.calcSize(this.getRegion(dm.getSystem()));
        if (this.cancelled) {
            return null;
        }
        CancellationRegistry.getInstance().deregisterMessage(this);
        return this.resp;
    }

    public RegionSizeRequest() {
        this.friendlyName = LocalizedStrings.RegionSizeRequest_FETCH_REGION_SIZE.toLocalizedString();
    }

    @Override
    public synchronized void cancel() {
        this.cancelled = true;
        if (this.resp != null) {
            this.resp.cancel();
        }
    }

    @Override
    public int getDSFID() {
        return 1045;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
    }

    @Override
    public String toString() {
        return "RegionSizeRequest from " + this.getRecipient() + " region=" + this.getRegionName();
    }
}

