/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminRegion;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.CacheDisplay;
import com.gemstone.gemfire.internal.admin.remote.RegionRequest;
import com.gemstone.gemfire.internal.admin.remote.RemoteGemFireVM;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class RegionResponse
extends AdminResponse {
    private String name;
    private String userAttribute;
    private Exception exception;

    public static RegionResponse create(DistributionManager dm, InternalDistributedMember recipient, RegionRequest request) {
        RegionResponse m = new RegionResponse();
        try {
            Cache cache = CacheFactory.getInstance(dm.getSystem());
            int cacheId = request.cacheId;
            if (System.identityHashCode(cache) == cacheId) {
                Region<Object, Object> r;
                int action = request.action;
                switch (action) {
                    case 10: {
                        r = cache.getRegion(request.path);
                        break;
                    }
                    case 11: {
                        r = cache.createRegion(request.newRegionName, request.newRegionAttributes);
                        break;
                    }
                    case 12: {
                        Region parent = cache.getRegion(request.path);
                        r = parent.createSubregion(request.newRegionName, request.newRegionAttributes);
                        break;
                    }
                    default: {
                        throw new InternalGemFireException(LocalizedStrings.RegionResponse_UNKNOWN_REGIONREQUEST_OPERATION_0.toLocalizedString(action));
                    }
                }
                if (r != null) {
                    m.name = r.getFullPath();
                    m.userAttribute = (String)CacheDisplay.getCachedObjectDisplay(r.getUserAttribute(), 100);
                } else {
                    m.name = null;
                }
            }
        }
        catch (CancelException cache) {
        }
        catch (Exception ex) {
            m.exception = ex;
        }
        m.setRecipient(recipient);
        return m;
    }

    public Region getRegion(RemoteGemFireVM vm) {
        if (this.name == null) {
            return null;
        }
        return new AdminRegion(this.name, vm, this.userAttribute);
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public int getDSFID() {
        return 1044;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.name, out);
        DataSerializer.writeString(this.userAttribute, out);
        DataSerializer.writeObject(this.exception, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.name = DataSerializer.readString(in);
        this.userAttribute = DataSerializer.readString(in);
        this.exception = (Exception)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "RegionResponse from " + this.getRecipient();
    }
}

