/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.Cancellable;
import com.gemstone.gemfire.internal.admin.remote.RemoteObjectName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class ObjectNamesResponse
extends AdminResponse
implements Cancellable {
    private HashSet objectNames;
    private transient boolean cancelled;

    public static ObjectNamesResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        ObjectNamesResponse m = new ObjectNamesResponse();
        m.setRecipient(recipient);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildNames(Region r) {
        if (this.cancelled) {
            return;
        }
        Set nameSet = r.keys();
        Iterator it = nameSet.iterator();
        this.objectNames = new HashSet();
        Region region = r;
        synchronized (region) {
            while (it.hasNext() && !this.cancelled) {
                Object name = it.next();
                if (name instanceof String || name instanceof Number) {
                    this.objectNames.add(name);
                    continue;
                }
                this.objectNames.add(new RemoteObjectName(name));
            }
        }
    }

    @Override
    public synchronized void cancel() {
        this.cancelled = true;
    }

    public Set getNameSet() {
        return new HashSet(this.objectNames);
    }

    @Override
    public int getDSFID() {
        return 1040;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.objectNames, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.objectNames = (HashSet)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "ObjectNamesResponse from " + this.getRecipient();
    }
}

