/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.persistence.PersistentID;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.internal.admin.remote.AdminMultipleReplyProcessor;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.CliLegacyMessage;
import com.gemstone.gemfire.internal.admin.remote.MissingPersistentIDsResponse;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberManager;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberPattern;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MissingPersistentIDsRequest
extends CliLegacyMessage {
    public static Set<PersistentID> send(DM dm) {
        Set recipients = dm.getOtherDistributionManagerIds();
        MissingPersistentIDsRequest request = new MissingPersistentIDsRequest();
        request.setRecipients(recipients);
        MissingPersistentIDProcessor replyProcessor = new MissingPersistentIDProcessor(dm, recipients);
        request.msgId = replyProcessor.getProcessorId();
        dm.putOutgoing(request);
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (!(e.getCause() instanceof CancelException)) {
                throw e;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Set<PersistentID> results = replyProcessor.missing;
        Set<PersistentID> existing = replyProcessor.existing;
        MissingPersistentIDsResponse localResponse = (MissingPersistentIDsResponse)request.createResponse((DistributionManager)dm);
        results.addAll(localResponse.getMissingIds());
        existing.addAll(localResponse.getLocalIds());
        results.removeAll(existing);
        return results;
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        HashSet<PersistentID> missingIds = new HashSet<PersistentID>();
        HashSet<PersistentID> localPatterns = new HashSet<PersistentID>();
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && !cache.isClosed()) {
            PersistentMemberManager mm = cache.getPersistentMemberManager();
            Map<String, Set<PersistentMemberID>> waitingRegions = mm.getWaitingRegions();
            for (Map.Entry<String, Set<PersistentMemberID>> entry : waitingRegions.entrySet()) {
                for (PersistentMemberID id : entry.getValue()) {
                    missingIds.add(new PersistentMemberPattern(id));
                }
            }
            Set<PersistentMemberID> localIds = mm.getPersistentIDs();
            for (PersistentMemberID id : localIds) {
                localPatterns.add(new PersistentMemberPattern(id));
            }
        }
        return new MissingPersistentIDsResponse(missingIds, localPatterns, this.getSender());
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int getDSFID() {
        return 2105;
    }

    private static class MissingPersistentIDProcessor
    extends AdminMultipleReplyProcessor {
        Set<PersistentID> missing = Collections.synchronizedSet(new TreeSet());
        Set<PersistentID> existing = Collections.synchronizedSet(new TreeSet());

        public MissingPersistentIDProcessor(DM dm, Set recipients) {
            super(dm, (Collection)recipients);
        }

        @Override
        protected void process(DistributionMessage msg, boolean warn) {
            if (msg instanceof MissingPersistentIDsResponse) {
                this.missing.addAll(((MissingPersistentIDsResponse)msg).getMissingIds());
                this.existing.addAll(((MissingPersistentIDsResponse)msg).getLocalIds());
            }
            super.process(msg, warn);
        }
    }
}

