/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HealthMonitor;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class FetchHealthDiagnosisResponse
extends AdminResponse {
    String[] diagnosis;

    public static FetchHealthDiagnosisResponse create(DistributionManager dm, InternalDistributedMember recipient, int id, GemFireHealth.Health healthCode) {
        FetchHealthDiagnosisResponse m = new FetchHealthDiagnosisResponse();
        m.setRecipient(recipient);
        HealthMonitor hm = dm.getHealthMonitor(recipient);
        if (hm.getId() == id) {
            m.diagnosis = hm.getDiagnosis(healthCode);
        }
        return m;
    }

    public String[] getDiagnosis() {
        return this.diagnosis;
    }

    @Override
    public int getDSFID() {
        return 1024;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeStringArray(this.diagnosis, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.diagnosis = DataSerializer.readStringArray(in);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FetchHealthDiagnosisResponse from ");
        sb.append(this.getRecipient());
        sb.append(" diagnosis=\"");
        for (int i = 0; i < this.diagnosis.length; ++i) {
            sb.append(this.diagnosis[i]);
            if (i >= this.diagnosis.length - 1) continue;
            sb.append(" ");
        }
        sb.append("\"");
        return sb.toString();
    }
}

