/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.internal.admin.EntryValueNode;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EntryValueNodeImpl
implements EntryValueNode,
Externalizable {
    private Object primitiveVal;
    private String type;
    private String name;
    private boolean primitive;
    private EntryValueNodeImpl[] fields;
    private static ThreadLocal recursionSet = new ThreadLocal();

    public static EntryValueNodeImpl createFromValueRoot(Object value, boolean logicalInspection) {
        recursionSet.set(new IdentityHashMap());
        EntryValueNodeImpl retVal = null;
        if (value != null) {
            retVal = EntryValueNodeImpl.createFromObject(EntryValueNodeImpl.constructKeyDisplay(value), value, logicalInspection);
        }
        Map map = (Map)recursionSet.get();
        map.clear();
        recursionSet.set(null);
        return retVal;
    }

    private static EntryValueNodeImpl createFromPrimitive(String fieldName, String type, Object primitiveWrapper) {
        EntryValueNodeImpl node = new EntryValueNodeImpl();
        node.name = fieldName;
        node.type = type;
        node.primitiveVal = primitiveWrapper;
        node.primitive = true;
        return node;
    }

    private static EntryValueNodeImpl createFromNullField(String fieldName, Class fieldType) {
        EntryValueNodeImpl node = new EntryValueNodeImpl();
        node.name = fieldName;
        node.type = fieldType.isArray() ? "array of" + fieldType.getComponentType().getName() : fieldType.getName();
        node.primitiveVal = "null";
        node.primitive = true;
        return node;
    }

    private static EntryValueNodeImpl createFromArray(String fieldName, Object arrayObj, Class arrayClass) {
        EntryValueNodeImpl node = new EntryValueNodeImpl();
        Map map = (Map)recursionSet.get();
        map.put(arrayObj, node);
        node.name = fieldName;
        Class<?> compType = arrayClass.getComponentType();
        String elType = compType.getName();
        node.type = "array of " + elType;
        node.primitiveVal = arrayObj.toString();
        node.primitive = false;
        if (arrayObj instanceof Object[]) {
            Object[] array = (Object[])arrayObj;
            EntryValueNodeImpl[] children = new EntryValueNodeImpl[array.length];
            for (int i = 0; i < array.length; ++i) {
                children[i] = array[i] != null ? EntryValueNodeImpl.createFromObject("[" + i + "]", array[i], false) : EntryValueNodeImpl.createFromNullField("[" + i + "]", compType);
            }
            node.fields = children;
        } else if (arrayObj instanceof int[]) {
            int[] array = (int[])arrayObj;
            EntryValueNodeImpl[] children = new EntryValueNodeImpl[array.length];
            for (int i = 0; i < array.length; ++i) {
                children[i] = EntryValueNodeImpl.createFromPrimitive("[" + i + "]", elType, array[i]);
            }
            node.fields = children;
        } else if (arrayObj instanceof boolean[]) {
            boolean[] array = (boolean[])arrayObj;
            EntryValueNodeImpl[] children = new EntryValueNodeImpl[array.length];
            for (int i = 0; i < array.length; ++i) {
                children[i] = EntryValueNodeImpl.createFromPrimitive("[" + i + "]", elType, array[i]);
            }
            node.fields = children;
        } else if (arrayObj instanceof char[]) {
            char[] array = (char[])arrayObj;
            EntryValueNodeImpl[] children = new EntryValueNodeImpl[array.length];
            for (int i = 0; i < array.length; ++i) {
                children[i] = EntryValueNodeImpl.createFromPrimitive("[" + i + "]", elType, new Character(array[i]));
            }
            node.fields = children;
        } else if (arrayObj instanceof double[]) {
            double[] array = (double[])arrayObj;
            EntryValueNodeImpl[] children = new EntryValueNodeImpl[array.length];
            for (int i = 0; i < array.length; ++i) {
                children[i] = EntryValueNodeImpl.createFromPrimitive("[" + i + "]", elType, array[i]);
            }
            node.fields = children;
        } else if (arrayObj instanceof long[]) {
            long[] array = (long[])arrayObj;
            EntryValueNodeImpl[] children = new EntryValueNodeImpl[array.length];
            for (int i = 0; i < array.length; ++i) {
                children[i] = EntryValueNodeImpl.createFromPrimitive("[" + i + "]", elType, array[i]);
            }
            node.fields = children;
        } else if (arrayObj instanceof float[]) {
            float[] array = (float[])arrayObj;
            EntryValueNodeImpl[] children = new EntryValueNodeImpl[array.length];
            for (int i = 0; i < array.length; ++i) {
                children[i] = EntryValueNodeImpl.createFromPrimitive("[" + i + "]", elType, new Float(array[i]));
            }
            node.fields = children;
        } else if (arrayObj instanceof byte[]) {
            byte[] array = (byte[])arrayObj;
            EntryValueNodeImpl[] children = new EntryValueNodeImpl[array.length];
            for (int i = 0; i < array.length; ++i) {
                children[i] = EntryValueNodeImpl.createFromPrimitive("[" + i + "]", elType, new Byte(array[i]));
            }
            node.fields = children;
        } else if (arrayObj instanceof short[]) {
            short[] array = (short[])arrayObj;
            EntryValueNodeImpl[] children = new EntryValueNodeImpl[array.length];
            for (int i = 0; i < array.length; ++i) {
                children[i] = EntryValueNodeImpl.createFromPrimitive("[" + i + "]", elType, new Short(array[i]));
            }
            node.fields = children;
        }
        return node;
    }

    private static EntryValueNodeImpl createFromObject(String fieldName, Object obj, boolean logicalInspection) {
        Map map = (Map)recursionSet.get();
        EntryValueNodeImpl stored = (EntryValueNodeImpl)map.get(obj);
        if (stored != null) {
            return stored;
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isArray()) {
            return EntryValueNodeImpl.createFromArray(fieldName, obj, clazz);
        }
        EntryValueNodeImpl node = new EntryValueNodeImpl();
        map.put(obj, node);
        node.name = fieldName;
        node.type = clazz.getName();
        if (EntryValueNodeImpl.isWrapperOrString(obj)) {
            node.primitiveVal = obj;
            node.primitive = true;
            return node;
        }
        node.primitiveVal = obj.toString();
        node.primitive = false;
        if (logicalInspection && EntryValueNodeImpl.hasLogicalView(obj)) {
            boolean retry;
            int retryCount = 0;
            ArrayList<EntryValueNodeImpl> elements = new ArrayList<EntryValueNodeImpl>();
            do {
                retry = false;
                try {
                    if (obj instanceof Map) {
                        Map theMap = (Map)obj;
                        Set entries = theMap.entrySet();
                        if (entries == null) continue;
                        for (Map.Entry entry : entries) {
                            Object key = entry.getKey();
                            Object value = entry.getValue();
                            if (key != null) {
                                elements.add(EntryValueNodeImpl.createFromObject("key->" + EntryValueNodeImpl.constructKeyDisplay(key), key, logicalInspection));
                            } else {
                                elements.add(EntryValueNodeImpl.createFromNullField("key->" + EntryValueNodeImpl.constructKeyDisplay(key), Object.class));
                            }
                            if (value != null) {
                                elements.add(EntryValueNodeImpl.createFromObject("value->" + EntryValueNodeImpl.constructKeyDisplay(value), value, logicalInspection));
                                continue;
                            }
                            elements.add(EntryValueNodeImpl.createFromNullField("value->" + EntryValueNodeImpl.constructKeyDisplay(value), Object.class));
                        }
                    } else if (obj instanceof List) {
                        List list = (List)obj;
                        Iterator it = list.listIterator();
                        while (it.hasNext()) {
                            Object element = it.next();
                            elements.add(EntryValueNodeImpl.createFromObject(EntryValueNodeImpl.constructKeyDisplay(element), element, logicalInspection));
                        }
                    } else {
                        if (!(obj instanceof Collection)) continue;
                        Collection coll = (Collection)obj;
                        for (Object element : coll) {
                            elements.add(EntryValueNodeImpl.createFromObject(EntryValueNodeImpl.constructKeyDisplay(element), element, logicalInspection));
                        }
                    }
                }
                catch (ConcurrentModificationException ex) {
                    elements = new ArrayList();
                    if (++retryCount > 5) continue;
                    retry = true;
                }
            } while (retry);
            node.fields = elements.toArray(new EntryValueNodeImpl[0]);
        } else {
            AccessibleObject[] fields = clazz.getDeclaredFields();
            try {
                AccessibleObject.setAccessible(fields, true);
            }
            catch (SecurityException se) {
                throw new InternalGemFireException(LocalizedStrings.EntryValueNodeImpl_UNABLE_TO_SET_ACCESSIBILITY_OF_FIELD_OBJECTS_DURING_CACHE_VALUE_DISPLAY_CONSTRUCTION.toLocalizedString(), se);
            }
            ArrayList<EntryValueNodeImpl> fieldList = new ArrayList<EntryValueNodeImpl>();
            for (int i = 0; i < fields.length; ++i) {
                int mods = ((Field)fields[i]).getModifiers();
                if ((mods & 8) != 0) continue;
                Object fieldVal = null;
                try {
                    fieldVal = ((Field)fields[i]).get(obj);
                }
                catch (Exception e) {
                    throw new InternalGemFireException(LocalizedStrings.EntryValueNodeImpl_UNABLE_TO_BUILD_CACHE_VALUE_DISPLAY.toLocalizedString(), e);
                }
                String name = ((Field)fields[i]).getName();
                if (fieldVal == null) {
                    fieldList.add(EntryValueNodeImpl.createFromNullField(name, ((Field)fields[i]).getType()));
                    continue;
                }
                if (EntryValueNodeImpl.isWrapperOrString(fieldVal)) {
                    fieldList.add(EntryValueNodeImpl.createFromPrimitive(name, ((Field)fields[i]).getType().getName(), fieldVal));
                    continue;
                }
                fieldList.add(EntryValueNodeImpl.createFromObject(name, fieldVal, logicalInspection));
            }
            node.fields = fieldList.toArray(new EntryValueNodeImpl[0]);
        }
        return node;
    }

    private static boolean isWrapperOrString(Object test) {
        return test instanceof Number || test instanceof String || test instanceof Boolean || test instanceof Character;
    }

    private static boolean hasLogicalView(Object obj) {
        return obj instanceof Map || obj instanceof List || obj instanceof Collection;
    }

    @Override
    public boolean isPrimitiveOrString() {
        return this.primitive;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public EntryValueNode[] getChildren() {
        if (this.fields != null) {
            return this.fields;
        }
        return new EntryValueNodeImpl[0];
    }

    @Override
    public Object getPrimitiveValue() {
        return this.primitiveVal;
    }

    public static String constructKeyDisplay(Object toDisplay) {
        if (toDisplay == null) {
            return "null";
        }
        if (toDisplay instanceof String) {
            return (String)toDisplay;
        }
        if (toDisplay instanceof Number) {
            return toDisplay.toString();
        }
        if (toDisplay instanceof Character) {
            return toDisplay.toString();
        }
        if (toDisplay instanceof Boolean) {
            return toDisplay.toString();
        }
        String className = toDisplay.getClass().getName();
        className = className.substring(className.lastIndexOf(".") + 1);
        char c = className.charAt(0);
        if ((c = Character.toLowerCase(c)) == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u') {
            return "an " + className;
        }
        return "a " + className;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.primitiveVal);
        out.writeObject(this.type);
        out.writeObject(this.name);
        out.writeObject(this.fields);
        out.writeBoolean(this.primitive);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.primitiveVal = in.readObject();
        this.type = (String)in.readObject();
        this.name = (String)in.readObject();
        this.fields = (EntryValueNodeImpl[])in.readObject();
        this.primitive = in.readBoolean();
    }
}

