/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.admin.remote.AdminRequest;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.DurableClientInfoResponse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DurableClientInfoRequest
extends AdminRequest {
    static final int HAS_DURABLE_CLIENT_REQUEST = 10;
    static final int IS_PRIMARY_FOR_DURABLE_CLIENT_REQUEST = 11;
    String durableId;
    int action = 0;

    public static DurableClientInfoRequest create(String id, int operation) {
        DurableClientInfoRequest m = new DurableClientInfoRequest();
        m.durableId = id;
        m.action = operation;
        DurableClientInfoRequest.setFriendlyName(m);
        return m;
    }

    public DurableClientInfoRequest() {
        DurableClientInfoRequest.setFriendlyName(this);
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        return DurableClientInfoResponse.create(dm, this.getSender(), this);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.durableId, out);
        out.writeInt(this.action);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.durableId = DataSerializer.readString(in);
        this.action = in.readInt();
        DurableClientInfoRequest.setFriendlyName(this);
    }

    @Override
    public String toString() {
        return "DurableClientInfoRequest from " + this.getSender();
    }

    @Override
    public int getDSFID() {
        return -22;
    }

    private static void setFriendlyName(DurableClientInfoRequest o) {
        switch (o.action) {
            case 10: {
                o.friendlyName = "Find whether the server has durable-queue for this client";
                break;
            }
            case 11: {
                o.friendlyName = "Find whether the server is primary for this durable-client";
                break;
            }
            default: {
                o.friendlyName = "Unknown operation " + o.action;
            }
        }
    }
}

