/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.admin.remote.RegionAdminMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public final class DestroyEntryMessage
extends RegionAdminMessage {
    private static final Logger logger = LogService.getLogger();
    private Object key;
    private ExpirationAction action;

    public static DestroyEntryMessage create(Object key, ExpirationAction action) {
        DestroyEntryMessage m = new DestroyEntryMessage();
        m.action = action;
        m.key = key;
        return m;
    }

    @Override
    public void process(DistributionManager dm) {
        Region r = this.getRegion(dm.getSystem());
        if (r != null) {
            try {
                if (this.action == ExpirationAction.LOCAL_DESTROY) {
                    r.localDestroy(this.key);
                } else if (this.action == ExpirationAction.DESTROY) {
                    r.destroy(this.key);
                } else if (this.action == ExpirationAction.INVALIDATE) {
                    r.invalidate(this.key);
                } else if (this.action == ExpirationAction.LOCAL_INVALIDATE) {
                    r.localInvalidate(this.key);
                }
            }
            catch (Exception e) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DestroEntryMessage_FAILED_ATTEMPT_TO_DESTROY_OR_INVALIDATE_ENTRY_0_1_FROM_CONSOLE_AT_2, new Object[]{r.getFullPath(), this.key, this.getSender()}));
            }
        }
    }

    @Override
    public int getDSFID() {
        return 1019;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.action, out);
        DataSerializer.writeObject(this.key, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.action = (ExpirationAction)DataSerializer.readObject(in);
        this.key = DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return LocalizedStrings.DestroyEntryMessage_DESTROYENTRYMESSAGE_FROM_0.toLocalizedString(this.getSender());
    }
}

