/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminRequest;
import com.gemstone.gemfire.internal.admin.remote.Cancellable;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.HashMap;
import java.util.Map;

public class CancellationRegistry {
    private static CancellationRegistry internalRef;
    private Map map = new HashMap();

    private CancellationRegistry() {
    }

    public static synchronized CancellationRegistry getInstance() {
        if (internalRef == null) {
            internalRef = new CancellationRegistry();
        }
        return internalRef;
    }

    public synchronized void cancelMessage(InternalDistributedMember console, int msgId) {
        Key key = new Key(console, msgId);
        AdminRequest msg = (AdminRequest)this.map.get(key);
        if (msg instanceof Cancellable) {
            ((Cancellable)((Object)msg)).cancel();
        }
    }

    public synchronized void registerMessage(AdminRequest msg) {
        Key key = new Key(msg.getSender(), msg.getMsgId());
        this.map.put(key, msg);
    }

    public synchronized void deregisterMessage(AdminRequest msg) {
        Key key = new Key(msg.getSender(), msg.getMsgId());
        this.map.remove(key);
    }

    private static class Key {
        private final InternalDistributedMember console;
        private final int msgId;

        public Key(InternalDistributedMember console, int msgId) {
            if (console == null) {
                throw new NullPointerException(LocalizedStrings.CancellationRegistry_NULL_CONSOLE.toLocalizedString());
            }
            this.console = console;
            this.msgId = msgId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Key) {
                Key toTest = (Key)other;
                return toTest.console.equals(this.console) && toTest.msgId == this.msgId;
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.msgId;
            result = 37 * result + this.console.hashCode();
            return result;
        }
    }
}

