/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.CancellationRegistry;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class CancellationMessage
extends PooledDistributionMessage {
    private int msgToCancel;

    public static CancellationMessage create(InternalDistributedMember recipient, int msgToCancel) {
        CancellationMessage m = new CancellationMessage();
        m.msgToCancel = msgToCancel;
        m.setRecipient(recipient);
        return m;
    }

    @Override
    public void process(DistributionManager dm) {
        CancellationRegistry.getInstance().cancelMessage(this.getSender(), this.msgToCancel);
    }

    @Override
    public int getDSFID() {
        return 1016;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.msgToCancel);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.msgToCancel = in.readInt();
    }

    @Override
    public String toString() {
        return LocalizedStrings.CancellationMessage_CANCELLATIONMESSAGE_FROM_0_FOR_MESSAGE_ID_1.toLocalizedString(this.getSender(), this.msgToCancel);
    }
}

