/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.admin.CacheInfo;
import com.gemstone.gemfire.internal.admin.remote.AdminRequest;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.CacheConfigResponse;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class CacheConfigRequest
extends AdminRequest {
    private byte attributeCode;
    private int newValue;
    private int cacheId;

    public static CacheConfigRequest create(CacheInfo c, int attCode, int v) {
        CacheConfigRequest m = new CacheConfigRequest();
        m.attributeCode = (byte)attCode;
        m.newValue = v;
        m.cacheId = c.getId();
        return m;
    }

    public CacheConfigRequest() {
        this.friendlyName = LocalizedStrings.CacheConfigRequest_SET_A_SINGLE_CACHE_CONFIGURATION_ATTRIBUTE.toLocalizedString();
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        return CacheConfigResponse.create(dm, this.getSender(), this.cacheId, this.attributeCode, this.newValue);
    }

    @Override
    public int getDSFID() {
        return 1012;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeByte(this.attributeCode);
        out.writeInt(this.newValue);
        out.writeInt(this.cacheId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.attributeCode = in.readByte();
        this.newValue = in.readInt();
        this.cacheId = in.readInt();
    }

    @Override
    public String toString() {
        return "CacheConfigRequest from " + this.getSender();
    }
}

