/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.GemFireCacheException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.admin.remote.RegionAdminMessage;
import com.gemstone.gemfire.internal.admin.remote.SnapshotResultMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class AppCacheSnapshotMessage
extends RegionAdminMessage {
    private int snapshotId;

    public static AppCacheSnapshotMessage create(String regionName, int snapshotId) {
        AppCacheSnapshotMessage m = new AppCacheSnapshotMessage();
        m.setRegionName(regionName);
        m.snapshotId = snapshotId;
        return m;
    }

    @Override
    protected void process(DistributionManager dm) {
        Region r = this.getRegion(dm.getSystem());
        if (r != null) {
            try {
                SnapshotResultMessage m = SnapshotResultMessage.create(r, this.snapshotId);
                m.setRecipient(this.getSender());
                dm.putOutgoing(m);
            }
            catch (CacheException ex) {
                throw new GemFireCacheException(ex);
            }
        }
    }

    @Override
    public int getDSFID() {
        return 1009;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.snapshotId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.snapshotId = in.readInt();
    }

    @Override
    public String toString() {
        return "AppCacheSnapshotMessage from " + this.getSender();
    }
}

