/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.admin.jmx.internal.StatAlertsAggregator;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.internal.admin.StatAlert;
import com.gemstone.gemfire.internal.admin.remote.RemoteGemFireVM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AlertsNotificationMessage
extends PooledDistributionMessage {
    private StatAlert[] _alerts;

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObjectArray(this._alerts, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this._alerts = (StatAlert[])DataSerializer.readObjectArray(in);
    }

    @Override
    public int getDSFID() {
        return 1072;
    }

    @Override
    protected void process(DistributionManager dm) {
        AdminDistributedSystemImpl ds = AdminDistributedSystemImpl.getConnectedInstance();
        if (ds instanceof StatAlertsAggregator) {
            StatAlertsAggregator aggregator = (StatAlertsAggregator)((Object)ds);
            RemoteGemFireVM remoteVM = dm.getAgent().getMemberById(this.getSender());
            aggregator.processNotifications(this._alerts, remoteVM);
        }
    }

    public StatAlert[] getAlerts() {
        return this._alerts;
    }

    public void setAlerts(StatAlert[] alerts) {
        this._alerts = alerts;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AlertsNotification[");
        sb.append("count = " + this._alerts.length);
        sb.append(" (");
        for (int i = 0; i < this._alerts.length; ++i) {
            sb.append(this._alerts[i].toString());
            if (i == this._alerts.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")]");
        return sb.toString();
    }
}

