/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.AlertLevel;
import com.gemstone.gemfire.distributed.internal.AdminMessageType;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.distributed.internal.ResourceEvent;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.RemoteAlert;
import com.gemstone.gemfire.internal.admin.remote.RemoteGemFireVM;
import com.gemstone.gemfire.internal.admin.remote.RemoteGfManagerAgent;
import com.gemstone.gemfire.management.internal.AlertDetails;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;

public final class AlertListenerMessage
extends PooledDistributionMessage
implements AdminMessageType {
    private int msgLevel;
    private Date msgDate;
    private String connectionName;
    private String threadName;
    private long tid;
    private String msg;
    private String exceptionText;

    public static AlertListenerMessage create(Object recipient, int msgLevel, Date msgDate, String connectionName, String threadName, long tid, String msg, String exceptionText) {
        AlertListenerMessage m = new AlertListenerMessage();
        m.setRecipient((InternalDistributedMember)recipient);
        m.msgLevel = msgLevel;
        m.msgDate = msgDate;
        m.connectionName = connectionName;
        if (m.connectionName == null) {
            m.connectionName = "";
        }
        m.threadName = threadName;
        if (m.threadName == null) {
            m.threadName = "";
        }
        m.tid = tid;
        m.msg = msg;
        if (m.msg == null) {
            m.msg = "";
        }
        m.exceptionText = exceptionText;
        if (m.exceptionText == null) {
            m.exceptionText = "";
        }
        return m;
    }

    @Override
    public void process(DistributionManager dm) {
        RemoteGfManagerAgent agent = dm.getAgent();
        if (agent != null) {
            RemoteGemFireVM mgr = agent.getMemberById(this.getSender());
            if (mgr == null) {
                return;
            }
            RemoteAlert alert = new RemoteAlert(mgr, this.msgLevel, this.msgDate, this.connectionName, this.threadName, this.tid, this.msg, this.exceptionText, this.getSender());
            agent.callAlertListener(alert);
        } else {
            AlertDetails alertDetail = new AlertDetails(this.msgLevel, this.msgDate, this.connectionName, this.threadName, this.tid, this.msg, this.exceptionText, this.getSender());
            dm.getSystem().handleResourceEvent(ResourceEvent.SYSTEM_ALERT, alertDetail);
        }
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    @Override
    public int getDSFID() {
        return 1008;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.msgLevel);
        DataSerializer.writeObject(this.msgDate, out);
        DataSerializer.writeString(this.connectionName, out);
        DataSerializer.writeString(this.threadName, out);
        out.writeLong(this.tid);
        DataSerializer.writeString(this.msg, out);
        DataSerializer.writeString(this.exceptionText, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.msgLevel = in.readInt();
        this.msgDate = (Date)DataSerializer.readObject(in);
        this.connectionName = DataSerializer.readString(in);
        this.threadName = DataSerializer.readString(in);
        this.tid = in.readLong();
        this.msg = DataSerializer.readString(in);
        this.exceptionText = DataSerializer.readString(in);
    }

    @Override
    public String toString() {
        return "Alert \"" + this.msg + "\" level " + AlertLevel.forSeverity(this.msgLevel);
    }
}

