/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.internal.logging.log4j.AlertAppender;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class AdminConsoleMessage
extends PooledDistributionMessage {
    int level;

    public static AdminConsoleMessage create(int level) {
        AdminConsoleMessage m = new AdminConsoleMessage();
        m.setLevel(level);
        return m;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void process(DistributionManager dm) {
        if (this.level != Integer.MAX_VALUE) {
            AlertAppender.getInstance().addAlertListener(this.getSender(), this.level);
        }
        dm.addAdminConsole(this.getSender());
    }

    @Override
    public int getDSFID() {
        return 1005;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.level);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.level = in.readInt();
    }

    @Override
    public String toString() {
        return "AdminConsoleMessage from " + this.getSender() + " level=" + this.level;
    }
}

