/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.admin.GemFireHealthConfig;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class AddHealthListenerResponse
extends AdminResponse {
    int listenerId;

    public static AddHealthListenerResponse create(DistributionManager dm, InternalDistributedMember recipient, GemFireHealthConfig cfg) {
        AddHealthListenerResponse m = new AddHealthListenerResponse();
        m.setRecipient(recipient);
        dm.createHealthMonitor(recipient, cfg);
        m.listenerId = dm.getHealthMonitor(recipient).getId();
        return m;
    }

    public int getHealthListenerId() {
        return this.listenerId;
    }

    @Override
    public int getDSFID() {
        return 1001;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.listenerId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.listenerId = in.readInt();
    }

    @Override
    public String toString() {
        return "AddHealthListenerResponse from " + this.getRecipient() + " listenerId=" + this.listenerId;
    }
}

