/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;

public class ClientHealthMonitoringRegion {
    public static final String ADMIN_REGION_NAME = "__ADMIN_CLIENT_HEALTH_MONITORING__";
    public static final int ADMIN_REGION_EXPIRY_INTERVAL = 20;
    static Region currentInstance;

    public static synchronized Region getInstance(GemFireCacheImpl c) {
        if (currentInstance != null && currentInstance.getCache() == c && !c.isClosed()) {
            return currentInstance;
        }
        if (c == null || c.isClosed()) {
            return null;
        }
        ClientHealthMonitoringRegion.initialize(c);
        return currentInstance;
    }

    private static void initialize(GemFireCacheImpl cache) {
        try {
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.LOCAL);
            factory.setEntryTimeToLive(new ExpirationAttributes(20, ExpirationAction.DESTROY));
            cache.getLogger().fine("ClientHealthMonitoringRegion, setting TTL for entry....");
            factory.addCacheListener(ClientHealthMonitoringRegion.prepareCacheListener());
            factory.setStatisticsEnabled(true);
            RegionAttributes regionAttrs = factory.create();
            InternalRegionArguments internalArgs = new InternalRegionArguments();
            internalArgs.setIsUsedForMetaRegion(true);
            internalArgs.setIsUsedForPartitionedRegionAdmin(false);
            currentInstance = cache.createVMRegion(ADMIN_REGION_NAME, regionAttrs, internalArgs);
        }
        catch (Exception ex) {
            cache.getLoggerI18n().error(LocalizedStrings.ClientHealthMonitoringRegion_ERROR_WHILE_CREATING_AN_ADMIN_REGION, ex);
        }
    }

    private static CacheListener prepareCacheListener() {
        return new CacheListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                Class<ClientHealthMonitoringRegion> clazz = ClientHealthMonitoringRegion.class;
                synchronized (ClientHealthMonitoringRegion.class) {
                    currentInstance = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
    }
}

