/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.HostStatHelper;
import com.gemstone.gemfire.internal.LocalStatisticsImpl;
import com.gemstone.gemfire.internal.ProcessStats;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;

public class SolarisProcessStats {
    private static final int allOtherSleepTimeINT = 0;
    private static final int characterIoINT = 1;
    private static final int dataFaultSleepTimeINT = 2;
    private static final int heapSizeINT = 3;
    private static final int imageSizeINT = 4;
    private static final int involContextSwitchesINT = 5;
    private static final int kernelFaultSleepTimeINT = 6;
    private static final int lockWaitSleepTimeINT = 7;
    private static final int lwpCurCountINT = 8;
    private static final int lwpTotalCountINT = 9;
    private static final int majorFaultsINT = 10;
    private static final int messagesRecvINT = 11;
    private static final int messagesSentINT = 12;
    private static final int minorFaultsINT = 13;
    private static final int rssSizeINT = 14;
    private static final int signalsReceivedINT = 15;
    private static final int systemCallsINT = 16;
    private static final int stackSizeINT = 17;
    private static final int stoppedTimeINT = 18;
    private static final int systemTimeINT = 19;
    private static final int textFaultSleepTimeINT = 20;
    private static final int trapTimeINT = 21;
    private static final int userTimeINT = 22;
    private static final int volContextSwitchesINT = 23;
    private static final int waitCpuTimeINT = 24;
    private static final int activeTimeLONG = 0;
    private static final int cpuUsedDOUBLE = 0;
    private static final int memoryUsedDOUBLE = 1;
    private static final StatisticsType myType;

    private static void checkOffset(String name, int offset) {
        int id = myType.nameToId(name);
        Assert.assertTrue(offset == id, "Expected the offset for " + name + " to be " + offset + " but it was " + id);
    }

    private SolarisProcessStats() {
    }

    public static StatisticsType getType() {
        return myType;
    }

    static ProcessStats createProcessStats(final Statistics stats) {
        if (stats instanceof LocalStatisticsImpl) {
            HostStatHelper.refresh((LocalStatisticsImpl)stats);
        }
        return new ProcessStats(stats){

            @Override
            public long getProcessSize() {
                return stats.getInt(14);
            }
        };
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        myType = f.createType("SolarisProcessStats", "Statistics on a Solaris process.", new StatisticDescriptor[]{f.createIntCounter("allOtherSleepTime", "The number of milliseconds the process has been sleeping for some reason not tracked by any other stat. Note that all lwp's contribute to this stat's value so check lwpCurCount to understand large values.", "milliseconds", false), f.createIntCounter("characterIo", "The number of characters read and written.", "bytes"), f.createIntCounter("dataFaultSleepTime", "The number of milliseconds the process has been faulting in data pages.", "milliseconds", false), f.createIntGauge("heapSize", "The size of the process's heap in megabytes.", "megabytes"), f.createIntGauge("imageSize", "The size of the process's image in megabytes.", "megabytes"), f.createIntCounter("involContextSwitches", "The number of times the process was forced to do a context switch.", "operations", false), f.createIntCounter("kernelFaultSleepTime", "The number of milliseconds the process has been faulting in kernel pages.", "milliseconds", false), f.createIntCounter("lockWaitSleepTime", "The number of milliseconds the process has been waiting for a user lock. Note that all lwp's contribute to this stat's value so check lwpCurCount to understand large values.", "milliseconds", false), f.createIntGauge("lwpCurCount", "The current number of light weight processes that exist in the process.", "threads"), f.createIntCounter("lwpTotalCount", "The total number of light weight processes that have ever contributed to the process's statistics.", "threads", false), f.createIntCounter("majorFaults", "The number of times the process has had a page fault that needed disk access.", "operations", false), f.createIntCounter("messagesRecv", "The number of messages received by the process.", "messages"), f.createIntCounter("messagesSent", "The number of messages sent by the process.", "messages"), f.createIntCounter("minorFaults", "The number of times the process has had a page fault that did not need disk access.", "operations", false), f.createIntGauge("rssSize", "The size of the process's resident set size in megabytes.", "megabytes"), f.createIntCounter("signalsReceived", "The total number of operating system signals this process has received.", "signals", false), f.createIntCounter("systemCalls", "The total number system calls done by this process.", "operations"), f.createIntGauge("stackSize", "The size of the process's stack in megabytes.", "megabytes"), f.createIntCounter("stoppedTime", "The number of milliseconds the process has been stopped.", "milliseconds", false), f.createIntCounter("systemTime", "The number of milliseconds the process has been using the CPU to execute system calls.", "milliseconds", false), f.createIntCounter("textFaultSleepTime", "The number of milliseconds the process has been faulting in text pages.", "milliseconds", false), f.createIntCounter("trapTime", "The number of milliseconds the process has been in system traps.", "milliseconds", false), f.createIntCounter("userTime", "The number of milliseconds the process has been using the CPU to execute user code.", "milliseconds", false), f.createIntCounter("volContextSwitches", "The number of voluntary context switches done by the process.", "operations", false), f.createIntCounter("waitCpuTime", "The number of milliseconds the process has been waiting for a CPU due to latency.", "milliseconds", false), f.createLongCounter("activeTime", "The number of milliseconds the process has been using the CPU to execute user or system code.", "milliseconds", false), f.createDoubleGauge("cpuUsed", "The percentage of recent cpu time used by the process.", "%"), f.createDoubleGauge("memoryUsed", "The percentage of real memory used by the process.", "%")});
        SolarisProcessStats.checkOffset("allOtherSleepTime", 0);
        SolarisProcessStats.checkOffset("characterIo", 1);
        SolarisProcessStats.checkOffset("dataFaultSleepTime", 2);
        SolarisProcessStats.checkOffset("heapSize", 3);
        SolarisProcessStats.checkOffset("imageSize", 4);
        SolarisProcessStats.checkOffset("involContextSwitches", 5);
        SolarisProcessStats.checkOffset("kernelFaultSleepTime", 6);
        SolarisProcessStats.checkOffset("lockWaitSleepTime", 7);
        SolarisProcessStats.checkOffset("lwpCurCount", 8);
        SolarisProcessStats.checkOffset("lwpTotalCount", 9);
        SolarisProcessStats.checkOffset("majorFaults", 10);
        SolarisProcessStats.checkOffset("messagesRecv", 11);
        SolarisProcessStats.checkOffset("messagesSent", 12);
        SolarisProcessStats.checkOffset("minorFaults", 13);
        SolarisProcessStats.checkOffset("rssSize", 14);
        SolarisProcessStats.checkOffset("signalsReceived", 15);
        SolarisProcessStats.checkOffset("systemCalls", 16);
        SolarisProcessStats.checkOffset("stackSize", 17);
        SolarisProcessStats.checkOffset("stoppedTime", 18);
        SolarisProcessStats.checkOffset("systemTime", 19);
        SolarisProcessStats.checkOffset("textFaultSleepTime", 20);
        SolarisProcessStats.checkOffset("trapTime", 21);
        SolarisProcessStats.checkOffset("userTime", 22);
        SolarisProcessStats.checkOffset("volContextSwitches", 23);
        SolarisProcessStats.checkOffset("waitCpuTime", 24);
        SolarisProcessStats.checkOffset("activeTime", 0);
        SolarisProcessStats.checkOffset("cpuUsed", 0);
        SolarisProcessStats.checkOffset("memoryUsed", 1);
    }
}

