/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.internal.SocketInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ReadableByteChannel;

public class SocketInputWrapper
extends FilterInputStream {
    private final Socket socket;
    private final boolean hasChannel;

    SocketInputWrapper(Socket s, InputStream is) {
        super(is);
        this.socket = s;
        this.hasChannel = s.getChannel() != null;
    }

    public void setTimeout(long timeoutMs) throws SocketException {
        if (this.hasChannel) {
            ((SocketInputStream)this.in).setTimeout(timeoutMs);
        } else {
            this.socket.setSoTimeout((int)timeoutMs);
        }
    }

    public ReadableByteChannel getReadableByteChannel() {
        return (SocketInputStream)this.in;
    }
}

