/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.PureJavaMode;
import com.gemstone.gemfire.internal.SmHelper;
import com.gemstone.gemfire.internal.lang.SystemUtils;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class SharedLibrary {
    private static final String SOLARIS_LIBRARY_SUFFIX = "_sol";
    private static final boolean is64Bit;
    private static final int referenceSize;
    private static final int objectHeaderSize;
    private static final UnsafeWrapper unsafe;

    public static boolean is64Bit() {
        return is64Bit;
    }

    public static boolean isSolaris() {
        String osName = System.getProperty("os.name");
        return osName.equals("SunOS");
    }

    public static String getName() {
        StringBuffer result = new StringBuffer("gemfire");
        if (SharedLibrary.isSolaris()) {
            result.append(SOLARIS_LIBRARY_SUFFIX);
        }
        if (SharedLibrary.is64Bit()) {
            result.append("64");
        }
        if (Boolean.getBoolean("gemfire.debug")) {
            result.append("_g");
        }
        return result.toString();
    }

    public static void loadLibrary(boolean debug) throws UnsatisfiedLinkError {
        String library;
        block9: {
            library = SharedLibrary.getName();
            try {
                URL gemfireJarURL = GemFireVersion.getJarURL();
                if (gemfireJarURL == null) {
                    throw new InternalGemFireError("Unable to locate jar file.");
                }
                String gemfireJar = null;
                try {
                    gemfireJar = URLDecoder.decode(gemfireJarURL.getFile(), "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    throw new RuntimeException(uee);
                }
                int index = gemfireJar.lastIndexOf("/");
                if (index == -1) {
                    throw new InternalGemFireError("Unable to parse gemfire jar path.");
                }
                String libDir = gemfireJar.substring(0, index + 1);
                File libraryPath = new File(libDir, System.mapLibraryName(library));
                if (libraryPath.exists()) {
                    System.load(libraryPath.getPath());
                    return;
                }
            }
            catch (InternalGemFireError ige) {
                if (debug) {
                    System.out.println("Problem loading library from URL path: " + ige);
                }
            }
            catch (UnsatisfiedLinkError ule) {
                if (!debug) break block9;
                System.out.println("Problem loading library from URL path: " + ule);
            }
        }
        System.loadLibrary(library);
    }

    public static int pointerSizeBytes() {
        return SmHelper.pointerSizeBytes();
    }

    public static final boolean getIs64Bit() {
        return PureJavaMode.is64Bit();
    }

    public static int getReferenceSize() {
        return referenceSize;
    }

    public static int getObjectHeaderSize() {
        return objectHeaderSize;
    }

    static {
        int ibmbits;
        UnsafeWrapper tmp = null;
        try {
            tmp = new UnsafeWrapper();
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Error error) {
            // empty catch block
        }
        unsafe = tmp;
        int sunbits = Integer.getInteger("sun.arch.data.model", 0);
        is64Bit = sunbits == 64 ? true : (sunbits == 32 ? false : ((ibmbits = Integer.getInteger("com.ibm.vm.bitmode", 0).intValue()) == 64 ? true : (ibmbits == 32 ? false : (unsafe != null ? unsafe.getAddressSize() == 8 : false))));
        if (!is64Bit) {
            referenceSize = 4;
            objectHeaderSize = 8;
        } else {
            int scaleIndex = 0;
            int tmpReferenceSize = 0;
            int tmpObjectHeaderSize = 0;
            if (SystemUtils.isAzulJVM()) {
                tmpObjectHeaderSize = 8;
                tmpReferenceSize = 8;
            } else {
                if (unsafe != null) {
                    scaleIndex = unsafe.arrayScaleIndex(Object[].class);
                    if (scaleIndex == 4) {
                        tmpReferenceSize = 4;
                        tmpObjectHeaderSize = 12;
                    } else if (scaleIndex == 8) {
                        tmpReferenceSize = 8;
                        tmpObjectHeaderSize = 16;
                    } else {
                        System.out.println("Unexpected arrayScaleIndex " + scaleIndex + ". Using max heap size to estimate reference size.");
                        scaleIndex = 0;
                    }
                }
                if (scaleIndex == 0) {
                    long SMALL_OOP_BOUNDARY = 32L;
                    if (SystemUtils.isJavaVersionAtLeast("1.8")) {
                        SMALL_OOP_BOUNDARY = 64L;
                    }
                    if (Runtime.getRuntime().maxMemory() > SMALL_OOP_BOUNDARY * 1024L * 1024L * 1024L) {
                        tmpReferenceSize = 8;
                        tmpObjectHeaderSize = 16;
                    } else {
                        tmpReferenceSize = 4;
                        tmpObjectHeaderSize = 12;
                    }
                }
            }
            referenceSize = tmpReferenceSize;
            objectHeaderSize = tmpObjectHeaderSize;
        }
    }
}

