/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.HostStatHelper;
import com.gemstone.gemfire.internal.LocalStatisticsImpl;
import com.gemstone.gemfire.internal.ProcessStats;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;

public class OSXProcessStats {
    private static final StatisticsType myType;

    private static void checkOffset(String name, int offset) {
        int id = myType.nameToId(name);
        Assert.assertTrue(offset == id, "Expected the offset for " + name + " to be " + offset + " but it was " + id);
    }

    private OSXProcessStats() {
    }

    public static StatisticsType getType() {
        return myType;
    }

    static ProcessStats createProcessStats(Statistics stats) {
        if (stats instanceof LocalStatisticsImpl) {
            HostStatHelper.refresh((LocalStatisticsImpl)stats);
        }
        return new ProcessStats(stats){

            @Override
            public long getProcessSize() {
                return 0L;
            }
        };
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        myType = f.createType("OSXProcessStats", "Statistics on a OS X process.", new StatisticDescriptor[]{f.createIntGauge("dummyStat", "Placeholder", "megabytes")});
    }
}

