/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.ObjToByteArraySerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public final class NullDataOutputStream
extends OutputStream
implements ObjToByteArraySerializer {
    private int size = 0;

    @Override
    public final void write(int b) {
        ++this.size;
    }

    @Override
    public final void write(byte[] source, int offset, int len) {
        this.size += len;
    }

    public final int size() {
        return this.size;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.size += 2;
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.size += 2;
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.size += 4;
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.size += 8;
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.size += 4;
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.size += 8;
    }

    @Override
    public final void writeBytes(String str) throws IOException {
        int strlen = str.length();
        if (strlen > 0) {
            this.size += strlen;
        }
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int len = s.length();
        if (len > 0) {
            this.size += len * 2;
        }
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        int strlen = str.length();
        if (strlen > 65535) {
            throw new UTFDataFormatException();
        }
        int utfSize = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utfSize;
                continue;
            }
            if (c > '\u07ff') {
                utfSize += 3;
                continue;
            }
            utfSize += 2;
        }
        if (utfSize > 65535) {
            throw new UTFDataFormatException();
        }
        this.size += utfSize + 2;
    }

    @Override
    public void writeAsSerializedByteArray(Object v) throws IOException {
        if (v instanceof HeapDataOutputStream) {
            this.size += 4;
            this.size += ((HeapDataOutputStream)v).size();
        } else {
            this.size += 5;
            DataSerializer.writeObject(v, this);
        }
    }
}

