/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.LogWrapper;
import com.gemstone.gemfire.management.internal.cli.util.GfshConsoleReader;
import java.io.Console;

public class GfeConsoleReaderFactory {
    private static GfeConsoleReader defaultConsoleReader = GfeConsoleReaderFactory.createConsoleReader();

    public static final GfeConsoleReader getDefaultConsoleReader() {
        return defaultConsoleReader;
    }

    public static final GfeConsoleReader createConsoleReader() {
        GfeConsoleReader consoleReader = null;
        if (CliUtil.isGfshVM()) {
            LogWrapper.getInstance().info("GfeConsoleReaderFactory.createConsoleReader(): isGfshVM");
            consoleReader = new GfshConsoleReader();
            LogWrapper.getInstance().info("GfeConsoleReaderFactory.createConsoleReader(): consoleReader: " + consoleReader + "=" + consoleReader.isSupported());
        }
        if (consoleReader == null) {
            consoleReader = new GfeConsoleReader();
        }
        return consoleReader;
    }

    public static class GfeConsoleReader {
        private Console console = System.console();

        protected GfeConsoleReader() {
        }

        public boolean isSupported() {
            return this.console != null;
        }

        public String readLine(String textToPrompt) {
            if (this.isSupported()) {
                return this.console.readLine(textToPrompt, new Object[0]);
            }
            return null;
        }

        public char[] readPassword(String textToPrompt) {
            if (this.isSupported()) {
                return this.console.readPassword(textToPrompt, new Object[0]);
            }
            return null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": isSupported=" + this.isSupported();
        }
    }
}

