/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.JarClassLoader;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.util.CollectionUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;

public final class ClassPathLoader {
    public static final String ENABLE_TRACE_PROPERTY = "gemfire.ClassPathLoader.enableTrace";
    public static final String ENABLE_TRACE_DEFAULT_VALUE = "false";
    private final boolean ENABLE_TRACE = false;
    private static final Logger logger;
    public static final String EXCLUDE_TCCL_PROPERTY = "gemfire.excludeThreadContextClassLoader";
    public static final boolean EXCLUDE_TCCL_DEFAULT_VALUE = false;
    private boolean excludeTCCL;
    public static final File EXT_LIB_DIR;
    private static final ClassLoader TCCL_PLACEHOLDER;
    private static final AtomicReference<ClassPathLoader> latest;
    private final List<ClassLoader> classLoaders;
    private static final Set<ClassLoader> defaultLoaders;

    private static List<URL> getJarURLsFromFiles(File ... files) {
        ArrayList<URL> urls = new ArrayList<URL>();
        Assert.assertTrue(files != null, "file list cannot be null");
        for (File file : files) {
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                urls.addAll(ClassPathLoader.getJarURLsFromFiles(file.listFiles()));
                continue;
            }
            if (!JarClassLoader.hasValidJarContent(file)) {
                logger.warn("Invalid JAR content when attempting to create ClassLoader for file: {}", new Object[]{file.getAbsolutePath()});
                continue;
            }
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException muex) {
                logger.warn("Encountered invalid URL when attempting to create ClassLoader for file: {}:{}", new Object[]{file.getAbsolutePath(), muex.getMessage()});
            }
        }
        return urls;
    }

    private ClassPathLoader(List<ClassLoader> classLoaders, boolean excludeTCCL) {
        Assert.assertTrue(classLoaders != null, "custom loaders must not be null");
        for (ClassLoader classLoader : classLoaders) {
            Assert.assertTrue(classLoader != null, "null classloaders not allowed");
        }
        this.classLoaders = new ArrayList<ClassLoader>(classLoaders);
        this.excludeTCCL = excludeTCCL;
    }

    public Collection<ClassLoader> getClassLoaders() {
        ArrayList<ClassLoader> classLoadersCopy = new ArrayList<ClassLoader>(this.classLoaders);
        for (int i = 0; i < classLoadersCopy.size(); ++i) {
            if (!((ClassLoader)classLoadersCopy.get(i)).equals(TCCL_PLACEHOLDER)) continue;
            if (this.excludeTCCL) {
                classLoadersCopy.remove(i);
                break;
            }
            classLoadersCopy.set(i, Thread.currentThread().getContextClassLoader());
            break;
        }
        return classLoadersCopy;
    }

    static ClassPathLoader createWithDefaults(boolean excludeTCCL) {
        LinkedList<ClassLoader> classLoaders = new LinkedList<ClassLoader>();
        classLoaders.add(TCCL_PLACEHOLDER);
        for (ClassLoader classLoader : defaultLoaders) {
            classLoaders.add(classLoader);
        }
        try {
            if (EXT_LIB_DIR.exists()) {
                if (!EXT_LIB_DIR.isDirectory() || !EXT_LIB_DIR.canRead()) {
                    logger.warn("Cannot read from directory when attempting to load JAR files: {}", new Object[]{EXT_LIB_DIR.getAbsolutePath()});
                } else {
                    ClassLoader classLoader;
                    List<URL> extLibJarURLs = ClassPathLoader.getJarURLsFromFiles(EXT_LIB_DIR);
                    classLoader = new URLClassLoader(extLibJarURLs.toArray(new URL[extLibJarURLs.size()]));
                    classLoaders.add(classLoader);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return new ClassPathLoader(classLoaders, excludeTCCL);
    }

    public static ClassPathLoader setLatestToDefault() {
        return ClassPathLoader.setLatestToDefault(Boolean.getBoolean(EXCLUDE_TCCL_PROPERTY));
    }

    public static ClassPathLoader setLatestToDefault(boolean excludeTCCL) {
        ClassPathLoader classPathLoader = ClassPathLoader.createWithDefaults(excludeTCCL);
        ClassPathLoader oldClassPathLoader = latest.getAndSet(classPathLoader);
        if (oldClassPathLoader != null) {
            for (ClassLoader classLoader : oldClassPathLoader.classLoaders) {
                if (!(classLoader instanceof JarClassLoader)) continue;
                ((JarClassLoader)classLoader).cleanUp();
            }
        }
        return classPathLoader;
    }

    ClassPathLoader addOrReplace(ClassLoader classLoader) {
        boolean isDebugEnabled = logger.isTraceEnabled();
        if (isDebugEnabled) {
            logger.trace("adding classLoader: {}", new Object[]{classLoader});
        }
        ArrayList<ClassLoader> classLoadersCopy = new ArrayList<ClassLoader>(this.classLoaders);
        classLoadersCopy.add(0, classLoader);
        ClassLoader removingClassLoader = null;
        int index = classLoadersCopy.lastIndexOf(classLoader);
        if (index != 0) {
            removingClassLoader = (ClassLoader)classLoadersCopy.get(index);
            if (isDebugEnabled) {
                logger.trace("removing previous classLoader: {}", new Object[]{removingClassLoader});
            }
            classLoadersCopy.remove(index);
        }
        if (removingClassLoader != null && removingClassLoader instanceof JarClassLoader) {
            ((JarClassLoader)removingClassLoader).cleanUp();
        }
        return new ClassPathLoader(classLoadersCopy, this.excludeTCCL);
    }

    public ClassPathLoader addOrReplaceAndSetLatest(ClassLoader classLoader) {
        ClassPathLoader classPathLoader = this.addOrReplace(classLoader);
        latest.set(classPathLoader);
        return classPathLoader;
    }

    ClassPathLoader remove(ClassLoader classLoader) {
        boolean isDebugEnabled = logger.isTraceEnabled();
        if (isDebugEnabled) {
            logger.trace("removing classLoader: {}", new Object[]{classLoader});
        }
        ArrayList<ClassLoader> classLoadersCopy = new ArrayList<ClassLoader>();
        classLoadersCopy.addAll(this.classLoaders);
        if (!classLoadersCopy.contains(classLoader)) {
            if (isDebugEnabled) {
                logger.trace("cannot remove classLoader since it doesn't exist: {}", new Object[]{classLoader});
            }
            return this;
        }
        classLoadersCopy.remove(classLoader);
        if (classLoader instanceof JarClassLoader) {
            ((JarClassLoader)classLoader).cleanUp();
        }
        return new ClassPathLoader(classLoadersCopy, this.excludeTCCL);
    }

    public ClassPathLoader removeAndSetLatest(ClassLoader classLoader) {
        ClassPathLoader classPathLoader = this.remove(classLoader);
        latest.set(classPathLoader);
        return classPathLoader;
    }

    public URL getResource(String name) {
        boolean isDebugEnabled = logger.isTraceEnabled();
        if (isDebugEnabled) {
            logger.trace("getResource({})", new Object[]{name});
        }
        URL url = null;
        ClassLoader tccl = null;
        if (!this.excludeTCCL) {
            tccl = Thread.currentThread().getContextClassLoader();
        }
        for (ClassLoader classLoader : this.classLoaders) {
            if (classLoader == TCCL_PLACEHOLDER) {
                try {
                    if (tccl != null) {
                        if (isDebugEnabled) {
                            logger.trace("getResource trying TCCL: {}", new Object[]{tccl});
                        }
                        if ((url = tccl.getResource(name)) == null) continue;
                        if (isDebugEnabled) {
                            logger.trace("getResource found by TCCL");
                        }
                        return url;
                    }
                    if (!isDebugEnabled) continue;
                    logger.trace("getResource skipping TCCL because it's null");
                }
                catch (SecurityException securityException) {}
                continue;
            }
            if (!this.excludeTCCL && classLoader.equals(tccl)) continue;
            if (isDebugEnabled) {
                logger.trace("getResource trying classLoader: {}", new Object[]{classLoader});
            }
            if ((url = classLoader.getResource(name)) == null) continue;
            if (isDebugEnabled) {
                logger.trace("getResource found by classLoader: {}", new Object[]{classLoader});
            }
            return url;
        }
        if (isDebugEnabled) {
            logger.trace("getResource returning null");
        }
        return url;
    }

    public Class<?> forName(String name) throws ClassNotFoundException {
        boolean isDebugEnabled = logger.isTraceEnabled();
        if (isDebugEnabled) {
            logger.trace("forName({})", new Object[]{name});
        }
        Class<?> clazz = null;
        ClassLoader tccl = null;
        if (!this.excludeTCCL) {
            tccl = Thread.currentThread().getContextClassLoader();
        }
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                if (classLoader == TCCL_PLACEHOLDER) {
                    if (tccl == null) continue;
                    if (isDebugEnabled) {
                        logger.trace("forName trying TCCL: {}", new Object[]{tccl});
                    }
                    if ((clazz = Class.forName(name, true, tccl)) != null) {
                        if (isDebugEnabled) {
                            logger.trace("forName found by TCCL");
                        }
                        return clazz;
                    }
                    if (!isDebugEnabled) continue;
                    logger.trace("forName skipping TCCL because it's null");
                    continue;
                }
                if (!this.excludeTCCL && classLoader.equals(tccl)) continue;
                if (isDebugEnabled) {
                    logger.trace("forName trying classLoader: {}", new Object[]{classLoader});
                }
                if ((clazz = Class.forName(name, true, classLoader)) == null) continue;
                if (isDebugEnabled) {
                    logger.trace("forName found by classLoader: {}", new Object[]{classLoader});
                }
                return clazz;
            }
            catch (SecurityException securityException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (isDebugEnabled) {
            logger.trace("forName throwing ClassNotFoundException");
        }
        throw new ClassNotFoundException(name);
    }

    public Class<?> getProxyClass(Class<?>[] classObjs) {
        IllegalArgumentException ex = null;
        ClassLoader tccl = null;
        if (!this.excludeTCCL) {
            tccl = Thread.currentThread().getContextClassLoader();
        }
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                if (classLoader == TCCL_PLACEHOLDER) {
                    if (tccl == null) continue;
                    return Proxy.getProxyClass(tccl, classObjs);
                }
                if (!this.excludeTCCL && classLoader.equals(tccl)) continue;
                return Proxy.getProxyClass(classLoader, classObjs);
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException iaex) {
                ex = iaex;
            }
        }
        assert (ex != null);
        if (ex != null) {
            throw ex;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("isLatest=").append(ClassPathLoader.getLatest() == this);
        sb.append(", excludeTCCL=").append(this.excludeTCCL);
        sb.append(", classLoaders=[");
        for (int i = 0; i < this.classLoaders.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.classLoaders.get(i).toString());
        }
        sb.append("]");
        if (!this.excludeTCCL) {
            sb.append(", TCCL=").append(Thread.currentThread().getContextClassLoader());
        }
        sb.append("]}");
        return sb.toString();
    }

    public URL getResource(Class<?> contextClass, String name) {
        URL url;
        if (contextClass != null && (url = contextClass.getResource(name)) != null) {
            return url;
        }
        return this.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public InputStream getResourceAsStream(Class<?> contextClass, String name) {
        InputStream is;
        if (contextClass != null && (is = contextClass.getResourceAsStream(name)) != null) {
            return is;
        }
        return this.getResourceAsStream(name);
    }

    public Enumeration<URL> getResources(Class<?> contextClass, String name) throws IOException {
        boolean isDebugEnabled = logger.isTraceEnabled();
        if (isDebugEnabled) {
            logger.trace((Object)new StringBuilder("getResources(").append(name).append(")"));
        }
        LinkedHashSet urls = new LinkedHashSet();
        try {
            if (contextClass != null) {
                CollectionUtils.addAll(urls, contextClass.getClassLoader().getResources(name));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Enumeration<URL> resources = null;
        ClassLoader tccl = null;
        if (!this.excludeTCCL) {
            tccl = Thread.currentThread().getContextClassLoader();
        }
        IOException ioException = null;
        for (ClassLoader classLoader : this.classLoaders) {
            ioException = null;
            if (classLoader == TCCL_PLACEHOLDER) {
                try {
                    if (tccl != null) {
                        if (isDebugEnabled) {
                            logger.trace("getResources trying TCCL: {}", new Object[]{tccl});
                        }
                        if ((resources = tccl.getResources(name)) == null || !resources.hasMoreElements()) continue;
                        if (isDebugEnabled) {
                            logger.trace("getResources found by TCCL");
                        }
                        CollectionUtils.addAll(urls, resources);
                        continue;
                    }
                    if (!isDebugEnabled) continue;
                    logger.trace("getResources skipping TCCL because it's null");
                }
                catch (SecurityException securityException) {
                }
                catch (IOException ignore) {
                    ioException = ignore;
                }
                continue;
            }
            if (!this.excludeTCCL && classLoader.equals(tccl)) continue;
            try {
                if (isDebugEnabled) {
                    logger.trace("getResources trying classLoader: {}", new Object[]{classLoader});
                }
                if ((resources = classLoader.getResources(name)) == null || !resources.hasMoreElements()) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)new StringBuilder("getResources found by classLoader: ").append(classLoader));
                }
                CollectionUtils.addAll(urls, resources);
            }
            catch (IOException ignore) {
                ioException = ignore;
            }
        }
        if (ioException != null) {
            if (isDebugEnabled) {
                logger.trace("getResources throwing IOException");
            }
            throw ioException;
        }
        if (isDebugEnabled) {
            logger.trace("getResources returning empty enumeration");
        }
        return Collections.enumeration(urls);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getResources(null, name);
    }

    public ClassLoader asClassLoader() {
        return new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return ClassPathLoader.this.forName(name);
            }

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                return ClassPathLoader.this.forName(name);
            }

            @Override
            public URL getResource(String name) {
                return ClassPathLoader.this.getResource(name);
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                return ClassPathLoader.this.getResources(name);
            }

            @Override
            public InputStream getResourceAsStream(String name) {
                return ClassPathLoader.this.getResourceAsStream(name);
            }
        };
    }

    public static ClassPathLoader getLatest() {
        return latest.get();
    }

    public static final ClassLoader getLatestAsClassLoader() {
        return latest.get().asClassLoader();
    }

    static {
        ClassLoader classLoader2;
        logger = LogService.getLogger();
        EXT_LIB_DIR = new File(new File(ClassPathLoader.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent(), "ext");
        TCCL_PLACEHOLDER = new ClassLoader(){};
        latest = new AtomicReference();
        defaultLoaders = new HashSet<ClassLoader>();
        try {
            classLoader2 = ClassPathLoader.class.getClassLoader();
            if (classLoader2 != null) {
                defaultLoaders.add(classLoader2);
            }
        }
        catch (SecurityException classLoader2) {
            // empty catch block
        }
        try {
            classLoader2 = ClassLoader.getSystemClassLoader();
            if (classLoader2 != null) {
                defaultLoaders.add(classLoader2);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ClassPathLoader.setLatestToDefault();
    }
}

