/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedDataStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class ByteArrayDataInput
extends InputStream
implements DataInput,
VersionedDataStream {
    private byte[] bytes;
    private int nBytes;
    private int pos;
    private char[] charBuf;
    private Version version;

    public final void initialize(byte[] bytes, Version version) {
        this.bytes = bytes;
        this.nBytes = bytes.length;
        this.pos = 0;
        this.version = version;
    }

    @Override
    public final Version getVersion() {
        return this.version;
    }

    private final int skipOver(long n) {
        int capacity = this.nBytes - this.pos;
        if (n <= (long)capacity) {
            this.pos += (int)n;
            return (int)n;
        }
        this.pos += capacity;
        return capacity;
    }

    @Override
    public final int read() throws IOException {
        if (this.pos < this.nBytes) {
            return this.bytes[this.pos++] & 0xFF;
        }
        throw new EOFException();
    }

    @Override
    public final int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || b.length < off + len) {
            throw new IndexOutOfBoundsException();
        }
        int capacity = this.nBytes - this.pos;
        if (len > capacity) {
            len = capacity;
        }
        if (len > 0) {
            System.arraycopy(this.bytes, this.pos, b, off, len);
            this.pos += len;
            return len;
        }
        return 0;
    }

    @Override
    public final long skip(long n) {
        return this.skipOver(n);
    }

    @Override
    public final int available() {
        return this.nBytes - this.pos;
    }

    public final int position() {
        return this.pos;
    }

    public final void setPosition(int pos) {
        this.pos = pos;
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        int len = b.length;
        System.arraycopy(this.bytes, this.pos, b, 0, len);
        this.pos += len;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        if (len > 0) {
            if (this.nBytes - this.pos < len) throw new EOFException();
            System.arraycopy(this.bytes, this.pos, b, off, len);
            this.pos += len;
            return;
        } else {
            if (len >= 0) return;
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public final int skipBytes(int n) {
        return this.skipOver(n);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        if (this.pos < this.nBytes) {
            return this.bytes[this.pos++] != 0;
        }
        throw new EOFException();
    }

    @Override
    public final byte readByte() throws IOException {
        if (this.pos < this.nBytes) {
            return this.bytes[this.pos++];
        }
        throw new EOFException();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.read();
    }

    @Override
    public final short readShort() throws IOException {
        if (this.pos + 1 < this.nBytes) {
            int result = this.bytes[this.pos++] & 0xFF;
            return (short)(result << 8 | this.bytes[this.pos++] & 0xFF);
        }
        throw new EOFException();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        if (this.pos + 1 < this.nBytes) {
            int result = this.bytes[this.pos++] & 0xFF;
            return result << 8 | this.bytes[this.pos++] & 0xFF;
        }
        throw new EOFException();
    }

    @Override
    public char readChar() throws IOException {
        if (this.pos + 1 < this.nBytes) {
            int result = this.bytes[this.pos++] << 8;
            return (char)(result | this.bytes[this.pos++] & 0xFF);
        }
        throw new EOFException();
    }

    @Override
    public int readInt() throws IOException {
        if (this.pos + 3 < this.nBytes) {
            int result = this.bytes[this.pos++] & 0xFF;
            result = result << 8 | this.bytes[this.pos++] & 0xFF;
            result = result << 8 | this.bytes[this.pos++] & 0xFF;
            return result << 8 | this.bytes[this.pos++] & 0xFF;
        }
        throw new EOFException();
    }

    @Override
    public final long readLong() throws IOException {
        if (this.pos + 7 < this.nBytes) {
            long result = this.bytes[this.pos++] & 0xFF;
            result = result << 8 | (long)(this.bytes[this.pos++] & 0xFF);
            result = result << 8 | (long)(this.bytes[this.pos++] & 0xFF);
            result = result << 8 | (long)(this.bytes[this.pos++] & 0xFF);
            result = result << 8 | (long)(this.bytes[this.pos++] & 0xFF);
            result = result << 8 | (long)(this.bytes[this.pos++] & 0xFF);
            result = result << 8 | (long)(this.bytes[this.pos++] & 0xFF);
            return result << 8 | (long)(this.bytes[this.pos++] & 0xFF);
        }
        throw new EOFException();
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readUTF() throws IOException {
        int utfLen = this.readUnsignedShort();
        if (this.pos + utfLen <= this.nBytes) {
            int char1;
            if (this.charBuf == null || this.charBuf.length < utfLen) {
                int charBufLength = (utfLen / 2 + 1) * 3;
                this.charBuf = new char[charBufLength];
            }
            byte[] bytes = this.bytes;
            char[] chars = this.charBuf;
            int index = this.pos;
            int limit = index + utfLen;
            int nChars = 0;
            while (index < limit && (char1 = bytes[index] & 0xFF) < 128) {
                chars[nChars] = (char)char1;
                ++index;
                ++nChars;
            }
            while (index < limit) {
                char1 = bytes[index] & 0xFF;
                switch (char1 >> 5) {
                    case 6: {
                        byte char2;
                        if (index + 1 < limit) {
                            if (((char2 = bytes[++index]) & 0xC0) == 128) {
                                chars[nChars] = (char)((char1 & 0x1F) << 6 | char2 & 0x3F);
                                break;
                            }
                            this.throwUTFEncodingError(index, char1, char2, null, 2);
                            break;
                        }
                        throw new UTFDataFormatException("partial 2-byte character at end (char1=" + char1 + ')');
                    }
                    case 7: {
                        byte char2;
                        if (index + 2 < limit) {
                            if (((char2 = bytes[++index]) & 0xC0) == 128) {
                                byte char3;
                                if (((char3 = bytes[++index]) & 0xC0) == 128) {
                                    chars[nChars] = (char)((char1 & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                                    break;
                                }
                                this.throwUTFEncodingError(index, char1, char2, Integer.valueOf(char3), 3);
                                break;
                            }
                            this.throwUTFEncodingError(index, char1, char2, null, 3);
                            break;
                        }
                        throw new UTFDataFormatException("partial 3-byte character at end (char1=" + char1 + ')');
                    }
                    default: {
                        chars[nChars] = (char)char1;
                    }
                }
                ++index;
                ++nChars;
            }
            this.pos = limit;
            return new String(chars, 0, nChars);
        }
        throw new EOFException();
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.bytes = null;
        this.nBytes = 0;
        this.pos = 0;
        this.version = null;
    }

    public String toString() {
        return this.version == null ? super.toString() : super.toString() + " (" + this.version + ')';
    }

    private void throwUTFEncodingError(int index, int char1, int char2, Integer char3, int enc) throws UTFDataFormatException {
        throw new UTFDataFormatException("malformed input for " + enc + "-byte encoding at " + index + " (char1=" + char1 + " char2=" + char2 + (char3 == null ? ")" : " char3=" + char3 + ')'));
    }
}

