/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.tcpserver;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.UnsupportedVersionException;
import com.gemstone.gemfire.distributed.internal.tcpserver.InfoRequest;
import com.gemstone.gemfire.distributed.internal.tcpserver.InfoResponse;
import com.gemstone.gemfire.distributed.internal.tcpserver.ShutdownRequest;
import com.gemstone.gemfire.distributed.internal.tcpserver.TcpServer;
import com.gemstone.gemfire.distributed.internal.tcpserver.VersionRequest;
import com.gemstone.gemfire.distributed.internal.tcpserver.VersionResponse;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedDataInputStream;
import com.gemstone.gemfire.internal.VersionedDataOutputStream;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class TcpClient {
    private static final Logger logger = LogService.getLogger();
    private static final int REQUEST_TIMEOUT = 120000;
    private static Map<InetSocketAddress, Short> serverVersions = new HashMap<InetSocketAddress, Short>();

    public static void stop(InetAddress addr, int port) throws ConnectException {
        try {
            ShutdownRequest request = new ShutdownRequest();
            TcpClient.requestToServer(addr, port, request, 120000);
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (Exception ex) {
            logger.error("TcpClient.stop(): exception connecting to locator " + addr + ":" + port + ": " + ex);
        }
    }

    public static String[] getInfo(InetAddress addr, int port) {
        try {
            InfoRequest request = new InfoRequest();
            InfoResponse response = (InfoResponse)TcpClient.requestToServer(addr, port, request, 120000);
            return response.getInfo();
        }
        catch (ConnectException ignore) {
            return null;
        }
        catch (Exception ex) {
            logger.error("TcpClient.getInfo(): exception connecting to locator " + addr + ":" + port + ": " + ex);
            return null;
        }
    }

    public static Object requestToServer(InetAddress addr, int port, Object request, int timeout) throws IOException, ClassNotFoundException {
        return TcpClient.requestToServer(addr, port, request, timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object requestToServer(InetAddress addr, int port, Object request, int timeout, boolean replyExpected) throws IOException, ClassNotFoundException {
        long newTimeout;
        InetSocketAddress ipAddr = addr == null ? new InetSocketAddress(port) : new InetSocketAddress(addr, port);
        long giveupTime = System.currentTimeMillis() + (long)timeout;
        short serverVersion = TcpClient.getServerVersion(ipAddr, timeout);
        if (serverVersion > Version.CURRENT_ORDINAL) {
            serverVersion = Version.CURRENT_ORDINAL;
        }
        int gossipVersion = TcpServer.getCurrentGossipVersion();
        if (Version.GFE_71.compareTo(serverVersion) > 0) {
            gossipVersion = TcpServer.getOldGossipVersion();
        }
        if ((newTimeout = giveupTime - System.currentTimeMillis()) <= 0L) {
            return null;
        }
        logger.debug("TcpClient sending {} to {}", new Object[]{request, ipAddr});
        Socket sock = SocketCreator.getDefaultInstance().connect(ipAddr.getAddress(), ipAddr.getPort(), (int)newTimeout, null, false);
        sock.setSoTimeout((int)newTimeout);
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(sock.getOutputStream());
            if (serverVersion < Version.CURRENT_ORDINAL) {
                out = new VersionedDataOutputStream(out, Version.fromOrdinalNoThrow(serverVersion, false));
            }
            out.writeInt(gossipVersion);
            if (gossipVersion > TcpServer.getOldGossipVersion()) {
                out.writeShort(serverVersion);
            }
            DataSerializer.writeObject(request, out);
            out.flush();
            if (replyExpected) {
                DataInputStream in = new DataInputStream(sock.getInputStream());
                in = new VersionedDataInputStream(in, Version.fromOrdinal(serverVersion, false));
                try {
                    Object response = DataSerializer.readObject(in);
                    logger.debug("received response: {}", new Object[]{response});
                    Object t = response;
                    return t;
                }
                catch (EOFException ex) {
                    throw new EOFException("Locator at " + ipAddr + " did not respond. This is normal if the locator was shutdown. If it wasn't check its log for exceptions.");
                }
            }
            Object in = null;
            return in;
        }
        catch (UnsupportedVersionException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Remote TcpServer version: " + serverVersion + " is higher than local version: " + Version.CURRENT_ORDINAL + ". This is never expected as remoteVersion");
            }
            Object var15_18 = null;
            return var15_18;
        }
        finally {
            try {
                if (replyExpected) {
                    sock.setSoLinger(true, 0);
                }
                sock.close();
            }
            catch (Exception e) {
                logger.error("Error closing socket ", (Throwable)e);
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Short getServerVersion(InetSocketAddress ipAddr, int timeout) throws IOException, ClassNotFoundException {
        block23: {
            int gossipVersion = TcpServer.getCurrentGossipVersion();
            Short serverVersion = null;
            Map<InetSocketAddress, Short> map = serverVersions;
            synchronized (map) {
                serverVersion = serverVersions.get(ipAddr);
            }
            if (serverVersion != null) {
                return serverVersion;
            }
            gossipVersion = TcpServer.getOldGossipVersion();
            Socket sock = SocketCreator.getDefaultInstance().connect(ipAddr.getAddress(), ipAddr.getPort(), timeout, null, false);
            sock.setSoTimeout(timeout);
            try {
                DataOutputStream out = new DataOutputStream(sock.getOutputStream());
                out = new VersionedDataOutputStream(out, Version.GFE_57);
                out.writeInt(gossipVersion);
                VersionRequest verRequest = new VersionRequest();
                DataSerializer.writeObject(verRequest, out);
                out.flush();
                DataInputStream in = new DataInputStream(sock.getInputStream());
                in = new VersionedDataInputStream(in, Version.GFE_90);
                try {
                    VersionResponse response = (VersionResponse)DataSerializer.readObject(in);
                    if (response == null) break block23;
                    serverVersion = response.getVersionOrdinal();
                    Object object = serverVersions;
                    synchronized (object) {
                        serverVersions.put(ipAddr, serverVersion);
                    }
                    object = serverVersion;
                    return object;
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            finally {
                try {
                    sock.setSoLinger(true, 0);
                    sock.close();
                }
                catch (Exception e) {
                    logger.error("Error closing socket ", (Throwable)e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Locator " + ipAddr + " did not respond to a request for its version.  I will assume it is using v5.7 for safety.");
        }
        Map<InetSocketAddress, Short> map = serverVersions;
        synchronized (map) {
            serverVersions.put(ipAddr, Version.GFE_90.ordinal());
        }
        return Version.GFE_90.ordinal();
    }

    private TcpClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearStaticData() {
        Map<InetSocketAddress, Short> map = serverVersions;
        synchronized (map) {
            serverVersions.clear();
        }
    }
}

