/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.gms.mgr;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.SystemConnectException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.ToDataException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.AdminMessageType;
import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.OverflowQueueWithDMStats;
import com.gemstone.gemfire.distributed.internal.SizeableRunnable;
import com.gemstone.gemfire.distributed.internal.StartupMessage;
import com.gemstone.gemfire.distributed.internal.direct.DirectChannel;
import com.gemstone.gemfire.distributed.internal.direct.DirectChannelListener;
import com.gemstone.gemfire.distributed.internal.direct.ShunnedMemberException;
import com.gemstone.gemfire.distributed.internal.membership.DistributedMembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.MembershipManager;
import com.gemstone.gemfire.distributed.internal.membership.MembershipTestHook;
import com.gemstone.gemfire.distributed.internal.membership.NetView;
import com.gemstone.gemfire.distributed.internal.membership.QuorumChecker;
import com.gemstone.gemfire.distributed.internal.membership.gms.GMSMember;
import com.gemstone.gemfire.distributed.internal.membership.gms.Services;
import com.gemstone.gemfire.distributed.internal.membership.gms.SuspectMember;
import com.gemstone.gemfire.distributed.internal.membership.gms.fd.GMSHealthMonitor;
import com.gemstone.gemfire.distributed.internal.membership.gms.interfaces.Manager;
import com.gemstone.gemfire.distributed.internal.membership.gms.membership.GMSJoinLeave;
import com.gemstone.gemfire.distributed.internal.membership.gms.messenger.GMSQuorumChecker;
import com.gemstone.gemfire.distributed.internal.membership.gms.mgr.LocalViewMessage;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.SystemTimer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.admin.remote.RemoteTransportConfig;
import com.gemstone.gemfire.internal.cache.CacheServerImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalCache;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessageWithDirectReply;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheServerCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.AlertAppender;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.shared.StringPrintWriter;
import com.gemstone.gemfire.internal.tcp.ConnectExceptions;
import com.gemstone.gemfire.internal.tcp.MemberShunnedException;
import com.gemstone.gemfire.internal.util.Breadcrumbs;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class GMSMembershipManager
implements MembershipManager,
Manager {
    private static final Logger logger = Services.getLogger();
    volatile boolean disableMulticastForRollingUpgrade;
    boolean wasReconnectingSystem;
    private volatile QuorumChecker quorumChecker;
    private ThreadLocal<Boolean> forceUseUDPMessaging = new ThreadLocal();
    private int membershipCheckTimeout = 1000;
    protected final EventProcessingLock startupLock = new EventProcessingLock();
    protected NetView latestView = new NetView();
    protected ReadWriteLock latestViewLock = new ReentrantReadWriteLock();
    protected DistributedMembershipListener listener;
    List membershipTestHooks;
    protected InternalDistributedMember address = null;
    protected DirectChannel directChannel;
    protected MyDCReceiver dcReceiver;
    volatile boolean isJoining;
    volatile boolean hasJoined;
    protected final Map shunnedMembers = new ConcurrentHashMap();
    private final Map shutdownMembers = new BoundedLinkedHashMap(1000);
    protected final HashSet shunnedAndWarnedMembers = new HashSet();
    protected final Map<InternalDistributedMember, Long> surpriseMembers = new ConcurrentHashMap<InternalDistributedMember, Long>();
    protected int surpriseMemberTimeout;
    private final Map<InternalDistributedMember, Long> suspectedMembers = new ConcurrentHashMap<InternalDistributedMember, Long>();
    private final long suspectMemberTimeout = 180000L;
    private static final int SHUNNED_SUNSET = Integer.getInteger("gemfire.shunned-member-timeout", 300);
    protected volatile boolean shutdownInProgress = false;
    protected volatile boolean processingEvents = false;
    long latestViewId = -1L;
    DMStats stats;
    protected LinkedList<StartupEvent> startupMessages = new LinkedList();
    private final HashMap memberLatch = new HashMap();
    private SystemTimer cleanupTimer;
    private Services services;
    private boolean mcastEnabled;
    private boolean tcpDisabled;
    private final Object startupMutex = new Object();
    private static volatile boolean emergencyClassesLoaded = false;
    protected static volatile boolean inhibitForceDisconnectLogging;
    boolean beingSick;
    boolean playingDead;

    public void enableNetworkPartitionDetection() {
        if (logger.isDebugEnabled()) {
            logger.debug("Network partition detection is being enabled");
        }
        this.services.getConfig().getDistributionConfig().setEnableNetworkPartitionDetection(true);
        this.services.getConfig().setNetworkPartitionDetectionEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processView(long newViewId, NetView newView) {
        if (logger.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer(200);
            msg.append("Membership: Processing view ");
            msg.append(newView);
            msg.append("} on " + this.address.toString());
            if (!newView.contains(this.address)) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_THE_MEMBER_WITH_ID_0_IS_NO_LONGER_IN_MY_OWN_VIEW_1, new Object[]{this.address, newView}));
            }
        }
        this.latestViewLock.writeLock().lock();
        try {
            InternalDistributedMember m;
            Map.Entry<InternalDistributedMember, Long> entry;
            InternalDistributedMember m2;
            int i;
            Version itsVersion;
            Version version = Version.CURRENT;
            Iterator<Object> it = this.surpriseMembers.entrySet().iterator();
            while (it.hasNext()) {
                InternalDistributedMember mbr = it.next().getKey();
                itsVersion = mbr.getVersionObject();
                if (itsVersion == null || version.compareTo(itsVersion) >= 0) continue;
                version = itsVersion;
            }
            for (InternalDistributedMember mbr : newView.getMembers()) {
                itsVersion = mbr.getVersionObject();
                if (itsVersion == null || itsVersion.compareTo(version) >= 0) continue;
                version = mbr.getVersionObject();
            }
            boolean bl = this.disableMulticastForRollingUpgrade = !version.equals(Version.CURRENT);
            if (newViewId < this.latestViewId) {
                return;
            }
            NetView priorView = this.latestView;
            this.latestViewId = newViewId;
            this.latestView = new NetView(newView, newView.getViewId());
            for (i = 0; i < newView.getMembers().size(); ++i) {
                CountDownLatch currentLatch;
                boolean isSecure;
                m2 = newView.getMembers().get(i);
                boolean wasSurprise = this.surpriseMembers.remove(m2) != null;
                this.suspectedMembers.remove(m2);
                if (priorView.contains(m2) || wasSurprise) continue;
                String authInit = this.services.getConfig().getDistributionConfig().getSecurityPeerAuthInit();
                boolean bl2 = isSecure = authInit != null && authInit.length() != 0;
                if (isSecure && (currentLatch = (CountDownLatch)this.memberLatch.get(m2)) != null) {
                    currentLatch.countDown();
                }
                if (this.shutdownInProgress()) {
                    this.addShunnedMember(m2);
                    continue;
                }
                boolean wasShunned = this.endShun(m2);
                if (wasShunned && logger.isDebugEnabled()) {
                    logger.debug("No longer shunning {} as it is in the current membership view", new Object[]{m2});
                }
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_MEMBERSHIP_PROCESSING_ADDITION__0_, m2));
                try {
                    this.listener.newMemberConnected(m2);
                    continue;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (DistributedSystemDisconnectedException err) {
                    continue;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_MEMBERSHIP_FAULT_WHILE_PROCESSING_VIEW_ADDITION_OF__0, m2), t);
                }
            }
            for (i = 0; i < priorView.getMembers().size(); ++i) {
                m2 = priorView.getMembers().get(i);
                if (newView.contains(m2) || this.surpriseMembers.containsKey(m2)) continue;
                try {
                    this.removeWithViewLock(m2, newView.getCrashedMembers().contains(m2) || this.suspectedMembers.containsKey(m2), "departed membership view");
                    continue;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_MEMBERSHIP_FAULT_WHILE_PROCESSING_VIEW_REMOVAL_OF__0, m2), t);
                }
            }
            long oldestAllowed = System.currentTimeMillis() - (long)this.surpriseMemberTimeout;
            Iterator<Map.Entry<InternalDistributedMember, Long>> it2 = this.surpriseMembers.entrySet().iterator();
            while (it2.hasNext()) {
                entry = it2.next();
                Long birthtime = entry.getValue();
                if (birthtime < oldestAllowed) {
                    it2.remove();
                    m = entry.getKey();
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_MEMBERSHIP_EXPIRING_MEMBERSHIP_OF_SURPRISE_MEMBER_0, m));
                    this.removeWithViewLock(m, true, "not seen in membership view in " + this.surpriseMemberTimeout + "ms");
                    continue;
                }
                if (this.latestView.contains(entry.getKey())) continue;
                this.latestView.add(entry.getKey());
            }
            oldestAllowed = System.currentTimeMillis() - this.suspectMemberTimeout;
            it2 = this.suspectedMembers.entrySet().iterator();
            while (it2.hasNext()) {
                entry = it2.next();
                Long birthtime = entry.getValue();
                if (birthtime >= oldestAllowed) continue;
                m = entry.getKey();
                it2.remove();
            }
            try {
                this.listener.viewInstalled(this.latestView);
                this.startCleanupTimer();
            }
            catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
                // empty catch block
            }
        }
        finally {
            this.latestViewLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isMulticastAllowed() {
        return !this.disableMulticastForRollingUpgrade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void join() {
        this.services.setShutdownCause(null);
        this.services.getCancelCriterion().cancel(null);
        this.latestViewLock.writeLock().lock();
        try {
            try {
                this.isJoining = true;
                long start = System.currentTimeMillis();
                boolean ok = this.services.getJoinLeave().join();
                if (!ok) {
                    throw new GemFireConfigException("Unable to join the distributed system.  Operation either timed out, was stopped or Locator does not exist.");
                }
                long delta = System.currentTimeMillis() - start;
                logger.info(LogMarker.DISTRIBUTION, (Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_JOINED_TOOK__0__MS, delta));
                NetView initialView = this.services.getJoinLeave().getView();
                this.latestView = new NetView(initialView, initialView.getViewId());
                this.listener.viewInstalled(this.latestView);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                if (ex.getCause() != null && ex.getCause().getCause() instanceof SystemConnectException) {
                    throw (SystemConnectException)ex.getCause().getCause();
                }
                throw new DistributionException(LocalizedStrings.GroupMembershipService_AN_EXCEPTION_WAS_THROWN_WHILE_JOINING.toLocalizedString(), ex);
            }
            finally {
                this.isJoining = false;
            }
        }
        finally {
            this.latestViewLock.writeLock().unlock();
        }
    }

    public GMSMembershipManager(DistributedMembershipListener listener) {
        Assert.assertTrue(listener != null);
        this.listener = listener;
    }

    @Override
    public void init(Services services) {
        this.services = services;
        Assert.assertTrue(services != null);
        this.stats = services.getStatistics();
        DistributionConfig config = services.getConfig().getDistributionConfig();
        RemoteTransportConfig transport = services.getConfig().getTransport();
        this.membershipCheckTimeout = config.getSecurityPeerMembershipTimeout();
        this.wasReconnectingSystem = transport.getIsReconnectingDS();
        this.mcastEnabled = transport.isMcastEnabled();
        this.tcpDisabled = transport.isTcpDisabled();
        if (!this.tcpDisabled) {
            this.dcReceiver = new MyDCReceiver(this.listener);
        }
        this.surpriseMemberTimeout = Math.max(100000, 20 * config.getMemberTimeout());
        this.surpriseMemberTimeout = Integer.getInteger("gemfire.surprise-member-timeout", this.surpriseMemberTimeout);
    }

    @Override
    public void start() {
        DistributionConfig config = this.services.getConfig().getDistributionConfig();
        RemoteTransportConfig transport = this.services.getConfig().getTransport();
        int dcPort = 0;
        if (!this.tcpDisabled) {
            this.directChannel = new DirectChannel(this, this.dcReceiver, config);
            dcPort = this.directChannel.getPort();
        }
        this.services.getMessenger().getMemberID().setDirectChannelPort(dcPort);
    }

    @Override
    public void joinDistributedSystem() {
        long startTime = System.currentTimeMillis();
        try {
            this.join();
        }
        catch (RuntimeException e) {
            if (this.directChannel != null) {
                this.directChannel.disconnect(e);
            }
            throw e;
        }
        this.address = this.services.getMessenger().getMemberID();
        int dcPort = 0;
        if (this.directChannel != null) {
            dcPort = this.directChannel.getPort();
        }
        if (this.directChannel != null) {
            this.directChannel.setLocalAddr(this.address);
        }
        this.hasJoined = true;
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_entered_into_membership_in_group_0_with_id_1, new Object[]{"" + (System.currentTimeMillis() - startTime)}));
    }

    @Override
    public void started() {
    }

    @Override
    public void quorumLost(Collection<InternalDistributedMember> failures, NetView view) {
        boolean notify;
        boolean bl = notify = failures.size() > 1;
        if (!notify) {
            notify = this.services.getConfig().isNetworkPartitionDetectionEnabled();
        }
        if (notify) {
            ArrayList<InternalDistributedMember> remaining = new ArrayList<InternalDistributedMember>(view.getMembers());
            remaining.removeAll(failures);
            if (inhibitForceDisconnectLogging && logger.isDebugEnabled()) {
                logger.debug("<ExpectedException action=add>Possible loss of quorum</ExpectedException>");
            }
            logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_POSSIBLE_LOSS_OF_QUORUM_DETECTED, new Object[]{failures.size(), failures}));
            if (inhibitForceDisconnectLogging && logger.isDebugEnabled()) {
                logger.debug("<ExpectedException action=remove>Possible loss of quorum</ExpectedException>");
            }
            try {
                this.listener.quorumLost(new HashSet<InternalDistributedMember>(failures), remaining);
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean testMulticast() {
        try {
            return this.services.getMessenger().testMulticast(this.services.getConfig().getMemberTimeout());
        }
        catch (InterruptedException e) {
            this.services.getCancelCriterion().checkCancelInProgress(e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    protected void removeWithViewLock(InternalDistributedMember dm, boolean crashed, String reason) {
        boolean wasShunned = this.isShunned(dm);
        this.destroyMember(dm, crashed, reason);
        if (wasShunned) {
            return;
        }
        try {
            this.listener.memberDeparted(dm, crashed, reason);
        }
        catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleOrDeferSurpriseConnect(InternalDistributedMember member) {
        EventProcessingLock eventProcessingLock = this.startupLock;
        synchronized (eventProcessingLock) {
            if (!this.processingEvents) {
                this.startupMessages.add(new StartupEvent(member));
                return;
            }
        }
        this.processSurpriseConnect(member);
    }

    @Override
    public void startupMessageFailed(DistributedMember mbr, String failureMessage) {
        this.addShunnedMember((InternalDistributedMember)mbr);
        try {
            this.listener.memberDeparted((InternalDistributedMember)mbr, true, "failed to pass startup checks");
        }
        catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSurpriseMember(DistributedMember dm) {
        final InternalDistributedMember member = (InternalDistributedMember)dm;
        boolean warn = false;
        this.latestViewLock.writeLock().lock();
        try {
            if (this.latestView.contains(member)) {
                boolean bl = true;
                return bl;
            }
            if (this.surpriseMembers.containsKey(member)) {
                boolean bl = true;
                return bl;
            }
            if (member.getVmViewId() < 0) {
                logger.warn("adding a surprise member that has not yet joined the distributed system: " + member, (Throwable)new Exception("stack trace"));
            }
            if (this.latestView.getViewId() > member.getVmViewId()) {
                new Thread(Thread.currentThread().getThreadGroup(), "Removing shunned GemFire node " + member){

                    @Override
                    public void run() {
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_Invalid_Surprise_Member, new Object[]{member, GMSMembershipManager.this.latestView}));
                        GMSMembershipManager.this.requestMemberRemoval(member, "this member is no longer in the view but is initiating connections");
                    }
                }.start();
                this.addShunnedMember(member);
                boolean bl = false;
                return bl;
            }
            this.surpriseMembers.put(member, System.currentTimeMillis());
            if (this.shutdownInProgress()) {
                String msg = LocalizedStrings.GroupMembershipService_THIS_DISTRIBUTED_SYSTEM_IS_SHUTTING_DOWN.toLocalizedString();
                if (this.directChannel != null) {
                    try {
                        this.directChannel.closeEndpoint(member, msg);
                    }
                    catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
                        // empty catch block
                    }
                }
                this.destroyMember(member, false, msg);
                boolean bl = true;
                return bl;
            }
            if (this.isShunned(member)) {
                warn = true;
                this.surpriseMembers.remove(member);
            } else {
                if (this.cleanupTimer == null) {
                    this.startCleanupTimer();
                }
                NetView newMembers = new NetView(this.latestView, this.latestView.getViewId());
                newMembers.add(member);
                this.latestView = newMembers;
            }
        }
        finally {
            this.latestViewLock.writeLock().unlock();
        }
        if (warn) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_MEMBERSHIP_IGNORING_SURPRISE_CONNECT_FROM_SHUNNED_MEMBER_0, member));
        } else {
            this.listener.newMemberConnected(member);
        }
        return !warn;
    }

    private void startCleanupTimer() {
        this.latestViewLock.writeLock().lock();
        try {
            if (this.cleanupTimer != null) {
                return;
            }
            InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
            if (ds != null && ((DistributedSystem)ds).isConnected()) {
                this.cleanupTimer = new SystemTimer(ds, true);
                SystemTimer.SystemTimerTask st = new SystemTimer.SystemTimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run2() {
                        GMSMembershipManager.this.latestViewLock.writeLock().lock();
                        try {
                            long oldestAllowed = System.currentTimeMillis() - (long)GMSMembershipManager.this.surpriseMemberTimeout;
                            Iterator<Map.Entry<InternalDistributedMember, Long>> it = GMSMembershipManager.this.surpriseMembers.entrySet().iterator();
                            while (it.hasNext()) {
                                Map.Entry<InternalDistributedMember, Long> entry = it.next();
                                Long birthtime = entry.getValue();
                                if (birthtime >= oldestAllowed) continue;
                                it.remove();
                                InternalDistributedMember m = entry.getKey();
                                logger.info((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_MEMBERSHIP_EXPIRING_MEMBERSHIP_OF_SURPRISE_MEMBER_0, m));
                                GMSMembershipManager.this.removeWithViewLock(m, true, "not seen in membership view in " + GMSMembershipManager.this.surpriseMemberTimeout + "ms");
                            }
                        }
                        finally {
                            GMSMembershipManager.this.latestViewLock.writeLock().unlock();
                        }
                    }
                };
                this.cleanupTimer.scheduleAtFixedRate(st, this.surpriseMemberTimeout, this.surpriseMemberTimeout / 3);
            }
        }
        finally {
            this.latestViewLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleOrDeferMessage(DistributionMessage msg) {
        EventProcessingLock eventProcessingLock = this.startupLock;
        synchronized (eventProcessingLock) {
            if ((this.beingSick || this.playingDead) && (msg.containsRegionContentChange() || msg instanceof PartitionMessageWithDirectReply)) {
                this.startupMessages.add(new StartupEvent(msg));
                return;
            }
            if (!this.processingEvents) {
                this.startupMessages.add(new StartupEvent(msg));
                return;
            }
        }
        this.dispatchMessage(msg);
    }

    @Override
    public void warnShun(DistributedMember m) {
        this.latestViewLock.writeLock().lock();
        try {
            if (!this.shunnedMembers.containsKey(m)) {
                return;
            }
            if (this.shunnedAndWarnedMembers.contains(m)) {
                return;
            }
            this.shunnedAndWarnedMembers.add(m);
        }
        finally {
            this.latestViewLock.writeLock().unlock();
        }
        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_MEMBERSHIP_DISREGARDING_SHUNNED_MEMBER_0, m));
    }

    @Override
    public void processMessage(DistributionMessage msg) {
        this.handleOrDeferMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchMessage(DistributionMessage msg) {
        boolean isNew = false;
        InternalDistributedMember m = msg.getSender();
        boolean shunned = false;
        this.latestViewLock.writeLock().lock();
        try {
            if (this.isShunned(m)) {
                if (msg instanceof StartupMessage) {
                    this.endShun(m);
                } else {
                    shunned = true;
                }
            }
            if (!shunned) {
                boolean bl = isNew = !this.latestView.contains(m) && !this.surpriseMembers.containsKey(m);
                if (isNew) {
                    shunned = !this.addSurpriseMember(m);
                }
            }
        }
        finally {
            this.latestViewLock.writeLock().unlock();
        }
        if (shunned) {
            this.warnShun(m);
            logger.info("Membership: Ignoring message from shunned member <{}>:{}", new Object[]{m, msg});
            throw new MemberShunnedException(m);
        }
        this.listener.messageReceived(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleOrDeferViewEvent(NetView viewArg) {
        if (this.isJoining) {
            EventProcessingLock eventProcessingLock = this.startupLock;
            synchronized (eventProcessingLock) {
                this.startupMessages.add(new StartupEvent(viewArg));
                return;
            }
        }
        this.latestViewLock.writeLock().lock();
        try {
            EventProcessingLock eventProcessingLock = this.startupLock;
            synchronized (eventProcessingLock) {
                if (!this.processingEvents) {
                    this.startupMessages.add(new StartupEvent(viewArg));
                    return;
                }
            }
            NetView newView = viewArg;
            long newId = viewArg.getViewId();
            LocalViewMessage v = new LocalViewMessage(this.address, newId, newView, this);
            this.listener.messageReceived(v);
            return;
        }
        finally {
            this.latestViewLock.writeLock().unlock();
        }
    }

    @Override
    public void memberSuspected(InternalDistributedMember initiator, InternalDistributedMember suspect, String reason) {
        SuspectMember s = new SuspectMember(initiator, suspect, reason);
        this.handleOrDeferSuspect(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleOrDeferSuspect(SuspectMember suspectInfo) {
        this.latestViewLock.writeLock().lock();
        try {
            EventProcessingLock eventProcessingLock = this.startupLock;
            synchronized (eventProcessingLock) {
                if (!this.processingEvents) {
                    return;
                }
            }
            InternalDistributedMember suspect = suspectInfo.suspectedMember;
            InternalDistributedMember who = suspectInfo.whoSuspected;
            this.suspectedMembers.put(suspect, System.currentTimeMillis());
            try {
                this.listener.memberSuspect(suspect, who, suspectInfo.reason);
                return;
            }
            catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
                // empty catch block
                return;
            }
        }
        finally {
            this.latestViewLock.writeLock().unlock();
        }
    }

    private void processSurpriseConnect(InternalDistributedMember member) {
        this.addSurpriseMember(member);
    }

    private void processStartupEvent(StartupEvent o) {
        if (o.isDistributionMessage()) {
            try {
                this.dispatchMessage(o.dmsg);
            }
            catch (MemberShunnedException memberShunnedException) {}
        } else if (o.isGmsView()) {
            this.processView(o.gmsView.getViewId(), o.gmsView);
        } else if (o.isSurpriseConnect()) {
            this.processSurpriseConnect(o.member);
        } else {
            throw new InternalGemFireError(LocalizedStrings.GroupMembershipService_UNKNOWN_STARTUP_EVENT_0.toLocalizedString(o));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startEventProcessing() {
        Object object = this.startupMutex;
        synchronized (object) {
            if (logger.isDebugEnabled()) {
                logger.debug("Membership: draining startup events.");
            }
            while (true) {
                StartupEvent ev;
                EventProcessingLock eventProcessingLock = this.startupLock;
                synchronized (eventProcessingLock) {
                    int remaining = this.startupMessages.size();
                    if (remaining == 0) {
                        this.processingEvents = true;
                        this.startupLock.notifyAll();
                        // MONITOREXIT @DISABLED, blocks:[3, 4, 7, 9] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                        if (!logger.isDebugEnabled()) return;
                        logger.debug("Membership: finished processing startup events.");
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Membership: {} remaining startup message(s)", new Object[]{remaining});
                    }
                    ev = this.startupMessages.removeFirst();
                }
                try {
                    this.processStartupEvent(ev);
                    continue;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_MEMBERSHIP_ERROR_HANDLING_STARTUP_EVENT), t);
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForEventProcessing() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.processingEvents) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Membership: waiting until the system is ready for events");
        }
        while (true) {
            this.directChannel.getCancelCriterion().checkCancelInProgress(null);
            EventProcessingLock eventProcessingLock = this.startupLock;
            synchronized (eventProcessingLock) {
                if (this.processingEvents) {
                    break;
                }
                boolean interrupted = Thread.interrupted();
                try {
                    this.startupLock.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    this.directChannel.getCancelCriterion().checkCancelInProgress(e);
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Membership: continuing");
        }
    }

    public List<StartupEvent> getStartupEvents() {
        return this.startupMessages;
    }

    @Override
    public ReadWriteLock getViewLock() {
        return this.latestViewLock;
    }

    @Override
    public NetView getView() {
        this.latestViewLock.readLock().lock();
        NetView v = this.latestView;
        this.latestViewLock.readLock().unlock();
        NetView result = new NetView(v, v.getViewId());
        for (InternalDistributedMember m : v.getMembers()) {
            if (!this.isShunned(m)) continue;
            result.remove(m);
        }
        return result;
    }

    @Override
    public DistributedMember getLeadMember() {
        this.latestViewLock.readLock().lock();
        try {
            InternalDistributedMember internalDistributedMember = this.latestView == null ? null : this.latestView.getLeadMember();
            return internalDistributedMember;
        }
        finally {
            this.latestViewLock.readLock().unlock();
        }
    }

    protected boolean isJoining() {
        return this.isJoining;
    }

    @Override
    public DistributedMember getCoordinator() {
        this.latestViewLock.readLock().lock();
        try {
            InternalDistributedMember internalDistributedMember = this.latestView == null ? null : this.latestView.getCoordinator();
            return internalDistributedMember;
        }
        finally {
            this.latestViewLock.readLock().unlock();
        }
    }

    @Override
    public boolean memberExists(DistributedMember m) {
        this.latestViewLock.readLock().lock();
        NetView v = this.latestView;
        this.latestViewLock.readLock().unlock();
        return v.getMembers().contains(m);
    }

    @Override
    public InternalDistributedMember getLocalMember() {
        return this.address;
    }

    public Services getServices() {
        return this.services;
    }

    @Override
    public void postConnect() {
    }

    public static void loadEmergencyClasses() {
        if (emergencyClassesLoaded) {
            return;
        }
        emergencyClassesLoaded = true;
        DirectChannel.loadEmergencyClasses();
        GMSJoinLeave.loadEmergencyClasses();
        GMSHealthMonitor.loadEmergencyClasses();
    }

    @Override
    public void emergencyClose() {
        boolean DEBUG = false;
        this.setShutdown();
        this.services.emergencyClose();
        if (this.directChannel != null) {
            this.directChannel.emergencyClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownMessageReceived(InternalDistributedMember id, String reason) {
        if (logger.isDebugEnabled()) {
            logger.debug("Membership: recording shutdown status of {}", new Object[]{id});
        }
        Map map = this.shutdownMembers;
        synchronized (map) {
            this.shutdownMembers.put(id, id);
            this.services.getHealthMonitor().memberShutdown(id, reason);
            this.services.getJoinLeave().memberShutdown(id, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShuttingDown(InternalDistributedMember mbr) {
        Map map = this.shutdownMembers;
        synchronized (map) {
            return this.shutdownMembers.containsKey(mbr);
        }
    }

    @Override
    public void shutdown() {
        this.setShutdown();
        this.services.stop();
    }

    @Override
    public void stop() {
        logger.debug("MembershipManager closing");
        if (this.directChannel != null) {
            this.directChannel.disconnect(null);
            if (this.address != null) {
                this.latestViewLock.writeLock().lock();
                try {
                    this.destroyMember(this.address, false, "orderly shutdown");
                }
                finally {
                    this.latestViewLock.writeLock().unlock();
                }
            }
        }
        if (this.cleanupTimer != null) {
            this.cleanupTimer.cancel();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Membership: channel closed");
        }
    }

    @Override
    public void uncleanShutdown(String reason, Exception e) {
        GMSMembershipManager.inhibitForcedDisconnectLogging(false);
        if (this.services.getShutdownCause() == null) {
            this.services.setShutdownCause(e);
        }
        if (this.directChannel != null) {
            this.directChannel.disconnect(e);
        }
        this.services.emergencyClose();
        if (e != null) {
            try {
                List l;
                if (this.membershipTestHooks != null) {
                    l = this.membershipTestHooks;
                    for (MembershipTestHook dml : l) {
                        dml.beforeMembershipFailure(reason, e);
                    }
                }
                this.listener.membershipFailure(reason, e);
                if (this.membershipTestHooks != null) {
                    l = this.membershipTestHooks;
                    for (MembershipTestHook dml : l) {
                        dml.afterMembershipFailure(reason, e);
                    }
                }
            }
            catch (RuntimeException re) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_EXCEPTION_CAUGHT_WHILE_SHUTTING_DOWN), (Throwable)re);
            }
        }
    }

    public void saveCacheXmlForReconnect() {
        boolean sharedConfigEnabled = this.services.getConfig().getDistributionConfig().getUseSharedConfiguration();
        this.saveCacheXmlForReconnect(sharedConfigEnabled);
    }

    public void saveCacheXmlForReconnect(boolean sharedConfigEnabled) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && cache instanceof Cache) {
            if (!(Boolean.getBoolean("gemfire.autoReconnect-useCacheXMLFile") || cache.isSqlfSystem() || sharedConfigEnabled)) {
                try {
                    logger.info("generating XML to rebuild the cache after reconnect completes");
                    StringPrintWriter pw = new StringPrintWriter();
                    CacheXmlGenerator.generate((Cache)cache, (PrintWriter)pw, true, false);
                    String cacheXML = pw.toString();
                    cache.getCacheConfig().setCacheXMLDescription(cacheXML);
                    logger.info("XML generation completed: {}", new Object[]{cacheXML});
                }
                catch (CancelException e) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_PROBLEM_GENERATING_CACHE_XML), (Throwable)e);
                }
            } else if (sharedConfigEnabled && !cache.getCacheServers().isEmpty()) {
                ArrayList<CacheServerCreation> list = new ArrayList<CacheServerCreation>(cache.getCacheServers().size());
                for (CacheServerImpl cs : cache.getCacheServers()) {
                    if (!cs.isDefaultServer()) continue;
                    CacheServerCreation bsc = new CacheServerCreation((InternalCache)cache, cs);
                    list.add(bsc);
                }
                cache.getCacheConfig().setCacheServerCreation(list);
                logger.info("CacheServer configuration saved");
            }
        }
    }

    @Override
    public boolean requestMemberRemoval(DistributedMember mbr, String reason) {
        if (mbr.equals(this.address)) {
            return false;
        }
        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_MEMBERSHIP_REQUESTING_REMOVAL_OF_0_REASON_1, new Object[]{mbr, reason}));
        try {
            this.services.getJoinLeave().remove((InternalDistributedMember)mbr, reason);
        }
        catch (RuntimeException e) {
            Exception problem = e;
            if (this.services.getShutdownCause() != null) {
                Exception cause = this.services.getShutdownCause();
                if (cause instanceof ForcedDisconnectException) {
                    problem = cause;
                } else {
                    Throwable ne = problem;
                    while (ne.getCause() != null) {
                        ne = ne.getCause();
                    }
                    try {
                        ne.initCause(this.services.getShutdownCause());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            if (!this.services.getConfig().getDistributionConfig().getDisableAutoReconnect()) {
                this.saveCacheXmlForReconnect();
            }
            this.listener.membershipFailure("Channel closed", problem);
            throw new DistributedSystemDisconnectedException("Channel closed", problem);
        }
        return true;
    }

    @Override
    public void suspectMembers(Set members, String reason) {
        Iterator it = members.iterator();
        while (it.hasNext()) {
            this.verifyMember((DistributedMember)it.next(), reason);
        }
    }

    @Override
    public void suspectMember(DistributedMember mbr, String reason) {
        if (!this.shutdownInProgress && !this.shutdownMembers.containsKey(mbr)) {
            this.verifyMember(mbr, reason);
        }
    }

    @Override
    public boolean verifyMember(DistributedMember mbr, String reason) {
        if (mbr != null && this.memberExists((InternalDistributedMember)mbr)) {
            return this.services.getHealthMonitor().checkIfAvailable(mbr, reason, true);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<InternalDistributedMember> directChannelSend(InternalDistributedMember[] destinations, DistributionMessage content, DMStats theStats) throws NotSerializableException {
        InternalDistributedMember[] keys;
        boolean allDestinations;
        if (content.forAll()) {
            allDestinations = true;
            this.latestViewLock.writeLock().lock();
            try {
                List<InternalDistributedMember> keySet = this.latestView.getMembers();
                keys = new InternalDistributedMember[keySet.size()];
                keys = keySet.toArray(keys);
            }
            finally {
                this.latestViewLock.writeLock().unlock();
            }
        } else {
            allDestinations = false;
            keys = destinations;
        }
        int sentBytes = 0;
        try {
            sentBytes = this.directChannel.send(this, keys, content, this.services.getConfig().getDistributionConfig().getAckWaitThreshold(), this.services.getConfig().getDistributionConfig().getAckSevereAlertThreshold());
            if (theStats != null) {
                theStats.incSentBytes(sentBytes);
            }
            if (sentBytes == 0 && this.services.getCancelCriterion().cancelInProgress() != null) {
                throw new DistributedSystemDisconnectedException();
            }
        }
        catch (DistributedSystemDisconnectedException ex) {
            if (this.services.getShutdownCause() != null) {
                throw new DistributedSystemDisconnectedException("DistributedSystem is shutting down", this.services.getShutdownCause());
            }
            throw ex;
        }
        catch (ConnectExceptions ex) {
            if (allDestinations) {
                return null;
            }
            List members = ex.getMembers();
            NetView view = this.services.getJoinLeave().getView();
            Iterator it_mem = members.iterator();
            Iterator it_causes = ex.getCauses().iterator();
            while (it_mem.hasNext()) {
                InternalDistributedMember member = (InternalDistributedMember)it_mem.next();
                Throwable th = (Throwable)it_causes.next();
                if (!view.contains(member) || th instanceof ShunnedMemberException) continue;
                logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_FAILED_TO_SEND_MESSAGE_0_TO_MEMBER_1_VIEW_2, new Object[]{content, member, view}), th);
            }
            return new HashSet<InternalDistributedMember>(members);
        }
        catch (CancelException | ToDataException e) {
            throw e;
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Membership: directChannelSend caught exception: {}", new Object[]{e.getMessage(), e});
            }
            if (e instanceof NotSerializableException) {
                throw (NotSerializableException)e;
            }
        }
        catch (RuntimeException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Membership: directChannelSend caught exception: {}", new Object[]{e.getMessage(), e});
            }
            throw e;
        }
        catch (Error e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Membership: directChannelSend caught exception: {}", new Object[]{e.getMessage(), e});
            }
            throw e;
        }
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.hasJoined && !this.shutdownInProgress;
    }

    @Override
    public boolean isReconnectingDS() {
        if (this.hasJoined) {
            return false;
        }
        return this.wasReconnectingSystem;
    }

    @Override
    public QuorumChecker getQuorumChecker() {
        QuorumChecker impl;
        if (!this.services.isShutdownDueToForcedDisconnect()) {
            return null;
        }
        if (this.quorumChecker != null) {
            return this.quorumChecker;
        }
        this.quorumChecker = impl = this.services.getMessenger().getQuorumChecker();
        return impl;
    }

    @Override
    public void releaseQuorumChecker(QuorumChecker checker) {
        ((GMSQuorumChecker)checker).suspend();
        InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
        if (system == null || !system.isConnected()) {
            checker.close();
        }
    }

    public Set send(InternalDistributedMember dest, DistributionMessage msg) throws NotSerializableException {
        InternalDistributedMember[] dests = new InternalDistributedMember[]{dest};
        return this.send(dests, msg, null);
    }

    @Override
    public Set send(InternalDistributedMember[] destinations, DistributionMessage msg, DMStats theStats) throws NotSerializableException {
        Set<InternalDistributedMember> result = null;
        boolean allDestinations = msg.forAll();
        if (this.services.getCancelCriterion().cancelInProgress() != null) {
            throw new DistributedSystemDisconnectedException("Distributed System is shutting down", this.services.getCancelCriterion().generateCancelledException(null));
        }
        if (this.playingDead) {
            while (this.playingDead && !this.shutdownInProgress) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (this.isJoining()) {
            if (allDestinations) {
                return null;
            }
            result = new HashSet<InternalDistributedMember>();
            for (int i = 0; i < destinations.length; ++i) {
                result.add(destinations[i]);
            }
            return result;
        }
        if (msg instanceof AdminMessageType && this.shutdownInProgress) {
            return new HashSet<InternalDistributedMember>(Arrays.asList(msg.getRecipients()));
        }
        if (destinations == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Membership: Message send: returning early because null set passed in: '{}'", new Object[]{msg});
            }
            return null;
        }
        if (destinations.length == 0) {
            if (logger.isTraceEnabled()) {
                logger.trace("Membership: Message send: returning early because empty destination list passed in: '{}'", new Object[]{msg});
            }
            return null;
        }
        msg.setSender(this.address);
        msg.setBreadcrumbsInSender();
        Breadcrumbs.setProblem(null);
        boolean useMcast = false;
        if (this.mcastEnabled) {
            useMcast = msg.getMulticast() || allDestinations;
        }
        boolean sendViaMessenger = this.isForceUDPCommunications();
        if (useMcast || this.tcpDisabled || sendViaMessenger) {
            this.checkAddressesForUUIDs(destinations);
            result = this.services.getMessenger().send(msg);
        } else {
            result = this.directChannelSend(destinations, msg, theStats);
        }
        if (allDestinations) {
            return null;
        }
        return result;
    }

    @Override
    public void forceUDPMessagingForCurrentThread() {
        this.forceUseUDPMessaging.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAddressesForUUIDs(InternalDistributedMember[] addresses) {
        for (int i = 0; i < addresses.length; ++i) {
            GMSMember id;
            InternalDistributedMember m = addresses[i];
            if (m == null || (id = (GMSMember)m.getNetMember()).hasUUID()) continue;
            this.latestViewLock.readLock().lock();
            try {
                addresses[i] = this.latestView.getCanonicalID(addresses[i]);
                continue;
            }
            finally {
                this.latestViewLock.readLock().unlock();
            }
        }
    }

    private boolean isForceUDPCommunications() {
        Boolean forced = this.forceUseUDPMessaging.get();
        return forced == Boolean.TRUE;
    }

    @Override
    public void releaseUDPMessagingForCurrentThread() {
    }

    @Override
    public void setShutdown() {
        this.latestViewLock.writeLock().lock();
        this.shutdownInProgress = true;
        this.latestViewLock.writeLock().unlock();
    }

    @Override
    public boolean shutdownInProgress() {
        DistributionManager dm = this.listener.getDM();
        return this.shutdownInProgress || dm != null && dm.shutdownInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyMember(final InternalDistributedMember member, boolean crashed, final String reason) {
        DirectChannel dc;
        this.latestViewLock.writeLock().lock();
        try {
            if (this.latestView.contains(member)) {
                NetView newView = new NetView(this.latestView, this.latestView.getViewId());
                newView.remove(member);
                this.latestView = newView;
            }
        }
        finally {
            this.latestViewLock.writeLock().unlock();
        }
        this.surpriseMembers.remove(member);
        if (!this.isShunned(member)) {
            this.addShunnedMember(member);
        }
        if ((dc = this.directChannel) != null) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(Integer.getInteger("p2p.disconnectDelay", 3000).intValue());
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    if (!dc.isOpen()) {
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Membership: closing connections for departed member {}", new Object[]{member});
                    }
                    dc.closeEndpoint(member, reason, false);
                }
            };
            t.setDaemon(true);
            t.setName("disconnect thread for " + member);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShunned(DistributedMember m) {
        this.latestViewLock.writeLock().lock();
        try {
            long now;
            if (!this.shunnedMembers.containsKey(m)) {
                boolean bl = false;
                return bl;
            }
            long shunTime = (Long)this.shunnedMembers.get(m);
            if (shunTime + (long)(SHUNNED_SUNSET * 1000) > (now = System.currentTimeMillis())) {
                boolean bl = true;
                return bl;
            }
            this.endShun(m);
            boolean bl = false;
            return bl;
        }
        finally {
            this.latestViewLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSurpriseMember(DistributedMember m) {
        this.latestViewLock.readLock().lock();
        try {
            if (this.surpriseMembers.containsKey(m)) {
                long now;
                long birthTime = this.surpriseMembers.get(m);
                boolean bl = birthTime >= (now = System.currentTimeMillis()) - (long)this.surpriseMemberTimeout;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.latestViewLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSurpriseMemberForTesting(DistributedMember m, long birthTime) {
        if (logger.isDebugEnabled()) {
            logger.debug("test hook is adding surprise member {} birthTime={}", new Object[]{m, birthTime});
        }
        this.latestViewLock.writeLock().lock();
        try {
            this.surpriseMembers.put((InternalDistributedMember)m, birthTime);
        }
        finally {
            this.latestViewLock.writeLock().unlock();
        }
    }

    public int getSurpriseMemberTimeout() {
        return this.surpriseMemberTimeout;
    }

    private boolean endShun(DistributedMember m) {
        boolean wasShunned = this.shunnedMembers.remove(m) != null;
        this.shunnedAndWarnedMembers.remove(m);
        return wasShunned;
    }

    protected void addShunnedMember(InternalDistributedMember m) {
        long deathTime = System.currentTimeMillis() - (long)(SHUNNED_SUNSET * 1000);
        this.surpriseMembers.remove(m);
        if (!this.isShunned(m)) {
            this.shunnedMembers.put(m, System.currentTimeMillis());
        }
        HashSet oldMembers = new HashSet(this.shunnedMembers.entrySet());
        HashSet<InternalDistributedMember> removedMembers = new HashSet<InternalDistributedMember>();
        for (Map.Entry entry : oldMembers) {
            long ll = (Long)entry.getValue();
            if (ll >= deathTime) continue;
            InternalDistributedMember mm = (InternalDistributedMember)entry.getKey();
            if (this.latestView.contains(mm)) {
                this.destroyMember(mm, true, "shunned but never disconnected");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Membership: finally removed shunned member entry <{}>", new Object[]{mm});
            }
            removedMembers.add(mm);
        }
        if (removedMembers.size() > 0) {
            for (InternalDistributedMember internalDistributedMember : removedMembers) {
                this.endShun(internalDistributedMember);
            }
        }
    }

    public Object getThreadLocalData() {
        HashMap result = new HashMap();
        return result;
    }

    public int getDirectChannelPort() {
        return this.directChannel == null ? 0 : this.directChannel.getPort();
    }

    protected void setDirectChannel(DirectChannel dc) {
        this.directChannel = dc;
        this.tcpDisabled = false;
    }

    @Override
    public Map getMessageState(DistributedMember member, boolean includeMulticast) {
        HashMap result = new HashMap();
        DirectChannel dc = this.directChannel;
        if (dc != null) {
            dc.getChannelStates(member, result);
        }
        this.services.getMessenger().getMessageState((InternalDistributedMember)member, result, includeMulticast);
        return result;
    }

    @Override
    public void waitForMessageState(DistributedMember otherMember, Map state) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        DirectChannel dc = this.directChannel;
        if (dc != null) {
            dc.waitForChannelState(otherMember, state);
        }
        this.services.getMessenger().waitForMessageState((InternalDistributedMember)otherMember, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean waitForDeparture(DistributedMember mbr) throws TimeoutException, InterruptedException {
        boolean wait;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean result = false;
        DirectChannel dc = this.directChannel;
        InternalDistributedMember idm = (InternalDistributedMember)mbr;
        int memberTimeout = this.services.getConfig().getDistributionConfig().getMemberTimeout();
        long pauseTime = memberTimeout < 1000 ? 100L : (long)(memberTimeout / 10);
        int numWaits = 0;
        do {
            OverflowQueueWithDMStats serialQueue;
            wait = false;
            if (dc != null) {
                if (dc.hasReceiversFor(idm)) {
                    wait = true;
                }
                if (wait && logger.isDebugEnabled()) {
                    logger.info("waiting for receivers for {} to shut down", new Object[]{mbr});
                }
            }
            if (!wait) {
                this.latestViewLock.readLock().lock();
                try {
                    wait = this.latestView.contains(idm);
                }
                finally {
                    this.latestViewLock.readLock().unlock();
                }
                if (wait && logger.isDebugEnabled()) {
                    logger.debug("waiting for {} to leave the membership view", new Object[]{mbr});
                }
            }
            if (!wait && (serialQueue = this.listener.getDM().getSerialQueue(idm)) != null) {
                boolean[] done = new boolean[1];
                final FlushingMessage msg = new FlushingMessage(done);
                serialQueue.add(new SizeableRunnable(100){

                    @Override
                    public void run() {
                        msg.invoke();
                    }

                    public String toString() {
                        return "Processing fake message";
                    }
                });
                boolean[] blArray = done;
                // MONITORENTER : done
                while (!done[0]) {
                    done.wait(10L);
                }
                result = true;
                // MONITOREXIT : blArray
            }
            if (!wait) continue;
            if (++numWaits > 40) {
                throw new TimeoutException("waited too long for " + idm + " to be removed");
            }
            Thread.sleep(pauseTime);
        } while (wait && dc != null && dc.isOpen() && this.services.getCancelCriterion().cancelInProgress() == null);
        if (!logger.isDebugEnabled()) return result;
        logger.debug("operations for {} should all be in the cache at this point", new Object[]{mbr});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForMembershipCheck(InternalDistributedMember remoteId) {
        boolean foundRemoteId = false;
        CountDownLatch currentLatch = null;
        this.latestViewLock.writeLock().lock();
        try {
            if (this.latestView == null) {
            } else if (this.latestView.contains(remoteId)) {
                foundRemoteId = true;
            } else {
                currentLatch = (CountDownLatch)this.memberLatch.get(remoteId);
                if (currentLatch == null) {
                    currentLatch = new CountDownLatch(1);
                    this.memberLatch.put(remoteId, currentLatch);
                }
            }
        }
        finally {
            this.latestViewLock.writeLock().unlock();
        }
        if (!foundRemoteId) {
            try {
                if (currentLatch.await(this.membershipCheckTimeout, TimeUnit.MILLISECONDS)) {
                    foundRemoteId = true;
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_THE_MEMBERSHIP_CHECK_WAS_TERMINATED_WITH_AN_EXCEPTION));
            }
        }
        return foundRemoteId;
    }

    @Override
    public Throwable getShutdownCause() {
        return this.services.getShutdownCause();
    }

    @Override
    public void registerTestHook(MembershipTestHook mth) {
        this.latestViewLock.writeLock().lock();
        try {
            if (this.membershipTestHooks == null) {
                this.membershipTestHooks = Collections.singletonList(mth);
            } else {
                ArrayList<MembershipTestHook> l = new ArrayList<MembershipTestHook>(this.membershipTestHooks);
                l.add(mth);
                this.membershipTestHooks = l;
            }
        }
        finally {
            this.latestViewLock.writeLock().unlock();
        }
    }

    @Override
    public void unregisterTestHook(MembershipTestHook mth) {
        this.latestViewLock.writeLock().lock();
        try {
            if (this.membershipTestHooks != null) {
                if (this.membershipTestHooks.size() == 1) {
                    this.membershipTestHooks = null;
                } else {
                    ArrayList l = new ArrayList(this.membershipTestHooks);
                    l.remove(mth);
                }
            }
        }
        finally {
            this.latestViewLock.writeLock().unlock();
        }
    }

    @Override
    public synchronized void beSick() {
        if (!this.beingSick) {
            this.beingSick = true;
            logger.info("GroupMembershipService.beSick invoked for {} - simulating sickness", new Object[]{this.address});
            this.services.getJoinLeave().beSick();
            this.services.getHealthMonitor().beSick();
            if (this.directChannel != null) {
                this.directChannel.beSick();
            }
        }
    }

    @Override
    public synchronized void playDead() {
        if (!this.playingDead) {
            this.playingDead = true;
            logger.info("GroupMembershipService.playDead invoked for {}", new Object[]{this.address});
            this.services.getJoinLeave().playDead();
            this.services.getHealthMonitor().playDead();
            this.services.getMessenger().playDead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void beHealthy() {
        if (this.beingSick || this.playingDead) {
            Object object = this.startupMutex;
            synchronized (object) {
                this.beingSick = false;
                this.playingDead = false;
                this.startEventProcessing();
            }
            logger.info("GroupMembershipService.beHealthy invoked for {} - recovering health now", new Object[]{this.address});
            if (this.directChannel != null) {
                this.directChannel.beHealthy();
            }
            this.services.getJoinLeave().beHealthy();
            this.services.getHealthMonitor().beHealthy();
            this.services.getMessenger().beHealthy();
        }
    }

    @Override
    public boolean isBeingSick() {
        return this.beingSick;
    }

    public static void inhibitForcedDisconnectLogging(boolean b) {
        inhibitForceDisconnectLogging = true;
    }

    public void setCacheTimeOffset(InternalDistributedMember coord, long timeOffset, boolean isJoin) {
        if (this.listener != null) {
            DistributionManager dm = this.listener.getDM();
            dm.getSystem().getClock().setCacheTimeOffset(coord, timeOffset, isJoin);
        }
    }

    @Override
    public void stopped() {
    }

    @Override
    public void installView(NetView v) {
        if (this.latestViewId < 0L && !this.isConnected()) {
            if (this.directChannel != null) {
                this.directChannel.setMembershipSize(v.getMembers().size());
            }
            this.latestViewId = v.getViewId();
            this.latestView = v;
            logger.debug("MembershipManager: initial view is {}", new Object[]{this.latestView});
        } else {
            this.handleOrDeferViewEvent(v);
        }
    }

    @Override
    public Set<InternalDistributedMember> send(DistributionMessage m) throws NotSerializableException {
        return this.send(m.getRecipients(), m, this.services.getStatistics());
    }

    @Override
    public void forceDisconnect(final String reason) {
        if (this.shutdownInProgress || this.isJoining()) {
            return;
        }
        this.setShutdown();
        final ForcedDisconnectException shutdownCause = new ForcedDisconnectException(reason);
        this.services.setShutdownCause(shutdownCause);
        this.services.getCancelCriterion().cancel(reason);
        AlertAppender.getInstance().shuttingDown();
        if (!inhibitForceDisconnectLogging) {
            logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.GroupMembershipService_MEMBERSHIP_SERVICE_FAILURE_0, reason), (Throwable)shutdownCause);
        }
        if (!this.services.getConfig().getDistributionConfig().getDisableAutoReconnect()) {
            this.saveCacheXmlForReconnect();
        }
        Thread reconnectThread = new Thread(new Runnable(){

            @Override
            public void run() {
                InternalLocator loc = (InternalLocator)Locator.getLocator();
                if (loc != null) {
                    loc.stop(true, !GMSMembershipManager.this.services.getConfig().getDistributionConfig().getDisableAutoReconnect(), false);
                }
                GMSMembershipManager.this.uncleanShutdown(reason, shutdownCause);
            }
        });
        reconnectThread.setName("DisconnectThread");
        reconnectThread.setDaemon(false);
        reconnectThread.start();
    }

    public void disableDisconnectOnQuorumLossForTesting() {
        this.services.getJoinLeave().disableDisconnectOnQuorumLossForTesting();
    }

    static class BoundedLinkedHashMap
    extends LinkedHashMap {
        private static final long serialVersionUID = -3419897166186852692L;
        protected int _maximumNumberOfEntries;

        public BoundedLinkedHashMap(int maximumNumberOfEntries) {
            this._maximumNumberOfEntries = maximumNumberOfEntries;
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > this._maximumNumberOfEntries;
        }
    }

    static class FlushingMessage
    extends DistributionMessage {
        boolean[] done;

        FlushingMessage(boolean[] done) {
            this.done = done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke() {
            boolean[] blArray = this.done;
            synchronized (this.done) {
                this.done[0] = true;
                this.done.notify();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        protected void process(DistributionManager dm) {
        }

        @Override
        public int getDSFID() {
            return 0;
        }

        @Override
        public int getProcessorType() {
            return 74;
        }
    }

    class MyDCReceiver
    implements DirectChannelListener {
        DirectChannelListener upCall;

        MyDCReceiver(DirectChannelListener up) {
            this.upCall = up;
        }

        @Override
        public void messageReceived(DistributionMessage msg) {
            GMSMembershipManager.this.services.getHealthMonitor().contactedBy(msg.getSender());
            GMSMembershipManager.this.handleOrDeferMessage(msg);
        }

        @Override
        public DistributionManager getDM() {
            return this.upCall.getDM();
        }
    }

    static class StartupEvent {
        static final int SURPRISE_CONNECT = 1;
        static final int VIEW = 2;
        static final int MESSAGE = 3;
        private int kind;
        InternalDistributedMember member;
        boolean crashed;
        String reason;
        DistributionMessage dmsg;
        NetView gmsView;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("kind=");
            switch (this.kind) {
                case 1: {
                    sb.append("connect; member = <" + this.member + ">");
                    break;
                }
                case 2: {
                    String text = this.gmsView.toString();
                    sb.append("view <" + text + ">");
                    break;
                }
                case 3: {
                    sb.append("message <" + this.dmsg + ">");
                    break;
                }
                default: {
                    sb.append("unknown=<" + this.kind + ">");
                }
            }
            return sb.toString();
        }

        StartupEvent(InternalDistributedMember member) {
            this.kind = 1;
            this.member = member;
        }

        boolean isSurpriseConnect() {
            return this.kind == 1;
        }

        StartupEvent(NetView v) {
            this.kind = 2;
            this.gmsView = v;
        }

        boolean isGmsView() {
            return this.kind == 2;
        }

        StartupEvent(DistributionMessage d) {
            this.kind = 3;
            this.dmsg = d;
        }

        boolean isDistributionMessage() {
            return this.kind == 3;
        }
    }

    static class EventProcessingLock {
    }
}

