/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.gms.messenger;

import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.NetView;
import com.gemstone.gemfire.distributed.internal.membership.QuorumChecker;
import com.gemstone.gemfire.distributed.internal.membership.gms.messenger.GMSPingPonger;
import com.gemstone.gemfire.distributed.internal.membership.gms.messenger.JGAddress;
import com.gemstone.gemfire.internal.concurrent.ConcurrentHashSet;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;

public class GMSQuorumChecker
implements QuorumChecker {
    private static final Logger logger = LogService.getLogger();
    private boolean isDebugEnabled = false;
    private Map<SocketAddress, InternalDistributedMember> addressConversionMap;
    private GMSPingPonger pingPonger;
    private Set<InternalDistributedMember> receivedAcks;
    private NetView lastView;
    private boolean quorumAchieved = false;
    private JChannel channel;
    private JGAddress myAddress;
    private int partitionThreshold;

    public GMSQuorumChecker(NetView jgView, int partitionThreshold, JChannel channel) {
        this.lastView = jgView;
        this.partitionThreshold = partitionThreshold;
        this.channel = channel;
    }

    public void initialize() {
        this.receivedAcks = new ConcurrentHashSet<InternalDistributedMember>();
        this.pingPonger = new GMSPingPonger();
        this.myAddress = (JGAddress)((Object)this.channel.down(new Event(91)));
        this.addressConversionMap = new ConcurrentHashMap<SocketAddress, InternalDistributedMember>(this.lastView.size());
        List<InternalDistributedMember> members = this.lastView.getMembers();
        for (InternalDistributedMember addr : members) {
            InetSocketAddress sockaddr = new InetSocketAddress(addr.getNetMember().getInetAddress(), addr.getPort());
            this.addressConversionMap.put(sockaddr, addr);
        }
        this.isDebugEnabled = logger.isDebugEnabled();
        this.resume();
    }

    @Override
    public synchronized boolean checkForQuorum(long timeout) throws InterruptedException {
        if (this.quorumAchieved) {
            return true;
        }
        if (this.isDebugEnabled) {
            logger.debug("beginning quorum check with {}", new Object[]{this});
        }
        this.sendPingMessages();
        this.quorumAchieved = this.waitForResponses(this.lastView.getMembers().size(), timeout);
        if (!this.quorumAchieved) {
            this.quorumAchieved = this.calculateQuorum();
        }
        return this.quorumAchieved;
    }

    @Override
    public void suspend() {
    }

    @Override
    public void close() {
        if (this.channel != null && !this.channel.isClosed()) {
            this.channel.close();
        }
    }

    @Override
    public void resume() {
        this.channel.setReceiver(null);
        this.channel.setReceiver((Receiver)new QuorumCheckerReceiver());
    }

    @Override
    public NetView getView() {
        return this.lastView;
    }

    @Override
    public Object getMembershipInfo() {
        return this.channel;
    }

    private boolean calculateQuorum() {
        int weight = this.getWeight(this.lastView.getMembers(), this.lastView.getLeadMember());
        int ackedWeight = this.getWeight(this.receivedAcks, this.lastView.getLeadMember());
        int lossThreshold = (int)Math.round((double)(weight * this.partitionThreshold) / 100.0);
        if (this.isDebugEnabled) {
            logger.debug("quorum check: contacted {} processes with {} member weight units.  Threshold for a quorum is {}", new Object[]{this.receivedAcks.size(), ackedWeight, lossThreshold});
        }
        return ackedWeight >= lossThreshold;
    }

    private boolean waitForResponses(int numMembers, long timeout) throws InterruptedException {
        block5: {
            long endTime = System.currentTimeMillis() + timeout;
            do {
                long time;
                long remaining;
                if ((remaining = endTime - (time = System.currentTimeMillis())) <= 0L) {
                    if (this.isDebugEnabled) {
                        logger.debug("quorum check: timeout waiting for responses.  {} responses received", new Object[]{this.receivedAcks.size()});
                    }
                    break block5;
                }
                if (this.isDebugEnabled) {
                    logger.debug("quorum check: waiting up to {}ms to receive a quorum of responses", new Object[]{remaining});
                }
                Thread.sleep(500L);
            } while (this.receivedAcks.size() != numMembers);
            if (this.isDebugEnabled) {
                logger.debug("quorum check: received responses from all members that were in the old distributed system");
            }
            return true;
        }
        return false;
    }

    private int getWeight(Collection<InternalDistributedMember> idms, InternalDistributedMember leader) {
        int weight = 0;
        for (InternalDistributedMember mbr : idms) {
            int thisWeight = mbr.getNetMember().getMemberWeight();
            if (mbr.getVmKind() == 10) {
                thisWeight += 10;
                if (leader != null && mbr.equals(leader)) {
                    thisWeight += 5;
                }
            } else if (mbr.getNetMember().preferredForCoordinator()) {
                thisWeight += 3;
            }
            weight += thisWeight;
        }
        return weight;
    }

    private void sendPingMessages() {
        List<InternalDistributedMember> members = this.lastView.getMembers();
        for (InternalDistributedMember addr : members) {
            if (this.receivedAcks.contains(addr)) continue;
            JGAddress dest = new JGAddress(addr);
            if (this.isDebugEnabled) {
                logger.debug("quorum check: sending request to {}", new Object[]{addr});
            }
            try {
                this.pingPonger.sendPingMessage(this.channel, (Address)this.myAddress, dest);
            }
            catch (Exception e) {
                logger.debug("Failed sending Ping message to " + (Object)((Object)dest));
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " on view " + this.lastView;
    }

    private class QuorumCheckerReceiver
    implements Receiver {
        private QuorumCheckerReceiver() {
        }

        public void receive(Message msg) {
            byte[] contents = msg.getBuffer();
            if (contents instanceof byte[]) {
                byte[] msgBytes = contents;
                if (GMSQuorumChecker.this.pingPonger.isPingMessage(msgBytes)) {
                    try {
                        GMSQuorumChecker.this.pingPonger.sendPongMessage(GMSQuorumChecker.this.channel, (Address)GMSQuorumChecker.this.myAddress, msg.getSrc());
                    }
                    catch (Exception e) {
                        logger.debug("Failed sending Pong message to " + msg.getSrc());
                    }
                } else if (GMSQuorumChecker.this.pingPonger.isPongMessage(msgBytes)) {
                    this.pongReceived(msg.getSrc());
                }
            }
        }

        public void getState(OutputStream output) throws Exception {
        }

        public void setState(InputStream input) throws Exception {
        }

        public void viewAccepted(View new_view) {
        }

        public void suspect(Address suspected_mbr) {
        }

        public void block() {
        }

        public void unblock() {
        }

        public void pongReceived(Address sender) {
            logger.debug("received ping-pong response from {}", new Object[]{sender});
            JGAddress jgSender = (JGAddress)sender;
            InetSocketAddress sockaddr = new InetSocketAddress(jgSender.getInetAddress(), jgSender.getPort());
            InternalDistributedMember memberAddr = (InternalDistributedMember)GMSQuorumChecker.this.addressConversionMap.get(sockaddr);
            if (memberAddr != null) {
                logger.debug("quorum check: mapped address to member ID {}", new Object[]{memberAddr});
                GMSQuorumChecker.this.receivedAcks.add(memberAddr);
            }
        }
    }
}

