/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.gms.messages;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.gms.messages.HasMemberID;
import com.gemstone.gemfire.internal.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class RemoveMemberMessage
extends HighPriorityDistributionMessage
implements HasMemberID {
    private InternalDistributedMember memberID;
    private String reason;

    public RemoveMemberMessage(InternalDistributedMember recipient, InternalDistributedMember id, String reason) {
        this.setRecipient(recipient);
        this.memberID = id;
        this.reason = reason;
    }

    public RemoveMemberMessage(List<InternalDistributedMember> recipients, InternalDistributedMember id, String reason) {
        this.setRecipients(recipients);
        this.memberID = id;
        this.reason = reason;
    }

    public RemoveMemberMessage() {
    }

    @Override
    public int getDSFID() {
        return -153;
    }

    @Override
    public void process(DistributionManager dm) {
        throw new IllegalStateException("this message is not intended to execute in a thread pool");
    }

    @Override
    public InternalDistributedMember getMemberID() {
        return this.memberID;
    }

    public String getReason() {
        return this.reason;
    }

    @Override
    public String toString() {
        return this.getShortClassName() + "(" + this.memberID + "; reason=" + this.reason + ")";
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.memberID, out);
        DataSerializer.writeString(this.reason, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.memberID = (InternalDistributedMember)DataSerializer.readObject(in);
        this.reason = DataSerializer.readString(in);
    }
}

