/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.gms.locator;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.gms.locator.PeerLocatorRequest;
import com.gemstone.gemfire.internal.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class FindCoordinatorRequest
extends HighPriorityDistributionMessage
implements PeerLocatorRequest {
    private InternalDistributedMember memberID;
    private Collection<InternalDistributedMember> rejectedCoordinators;
    private int lastViewId;

    public FindCoordinatorRequest(InternalDistributedMember myId) {
        this.memberID = myId;
    }

    public FindCoordinatorRequest(InternalDistributedMember myId, Collection<InternalDistributedMember> rejectedCoordinators, int lastViewId) {
        this.memberID = myId;
        this.rejectedCoordinators = rejectedCoordinators;
        this.lastViewId = lastViewId;
    }

    public FindCoordinatorRequest() {
    }

    public InternalDistributedMember getMemberID() {
        return this.memberID;
    }

    public Collection<InternalDistributedMember> getRejectedCoordinators() {
        return this.rejectedCoordinators;
    }

    public int getLastViewId() {
        return this.lastViewId;
    }

    @Override
    public String toString() {
        if (this.rejectedCoordinators != null) {
            return "FindCoordinatorRequest(memberID=" + this.memberID + ", rejected=" + this.rejectedCoordinators + ", lastViewId=" + this.lastViewId + ")";
        }
        return "FindCoordinatorRequest(memberID=" + this.memberID + ")";
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public int getDSFID() {
        return -145;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.memberID, out);
        if (this.rejectedCoordinators != null) {
            out.writeInt(this.rejectedCoordinators.size());
            for (InternalDistributedMember mbr : this.rejectedCoordinators) {
                DataSerializer.writeObject(mbr, out);
            }
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.lastViewId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.memberID = (InternalDistributedMember)DataSerializer.readObject(in);
        int size = in.readInt();
        this.rejectedCoordinators = new ArrayList<InternalDistributedMember>(size);
        for (int i = 0; i < size; ++i) {
            this.rejectedCoordinators.add((InternalDistributedMember)DataSerializer.readObject(in));
        }
        this.lastViewId = in.readInt();
    }

    @Override
    protected void process(DistributionManager dm) {
        throw new IllegalStateException("this message should not be executed");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lastViewId;
        result = 31 * result + (this.memberID == null ? 0 : this.memberID.hashCode());
        result = 31 * result + (this.rejectedCoordinators == null ? 0 : this.rejectedCoordinators.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FindCoordinatorRequest other = (FindCoordinatorRequest)obj;
        if (this.lastViewId != other.lastViewId) {
            return false;
        }
        if (this.memberID == null ? other.memberID != null : !this.memberID.equals(other.memberID)) {
            return false;
        }
        return !(this.rejectedCoordinators == null ? other.rejectedCoordinators != null : !this.rejectedCoordinators.equals(other.rejectedCoordinators));
    }
}

