/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.gms.auth;

import com.gemstone.gemfire.cache.CacheCallback;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.NetView;
import com.gemstone.gemfire.distributed.internal.membership.gms.Services;
import com.gemstone.gemfire.internal.ClassLoadUtil;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.InternalLogWriter;
import com.gemstone.gemfire.security.AuthInitialize;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.gemstone.gemfire.security.AuthenticationRequiredException;
import com.gemstone.gemfire.security.Authenticator;
import com.gemstone.gemfire.security.GemFireSecurityException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Properties;
import java.util.Set;

public class GMSAuthenticator
implements com.gemstone.gemfire.distributed.internal.membership.gms.interfaces.Authenticator {
    private static final String secPrefix = "gemfire.sys.security-";
    private static final int gemfireSysPrefixLen = "gemfire.sys.".length();
    private Services services;
    private Properties securityProps = this.getSecurityProps();

    @Override
    public void init(Services s) {
        this.services = s;
    }

    @Override
    public void start() {
    }

    @Override
    public void started() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void stopped() {
    }

    @Override
    public void installView(NetView v) {
    }

    @Override
    public void beSick() {
    }

    @Override
    public void playDead() {
    }

    @Override
    public void beHealthy() {
    }

    @Override
    public void memberSuspected(InternalDistributedMember initiator, InternalDistributedMember suspect, String reason) {
    }

    @Override
    public String authenticate(InternalDistributedMember member, Object credentials) throws AuthenticationFailedException {
        return this.authenticate(member, credentials, this.securityProps, this.services.getJoinLeave().getMemberID());
    }

    String authenticate(DistributedMember member, Object credentials, Properties secProps, DistributedMember localMember) throws AuthenticationFailedException {
        String authMethod = secProps.getProperty("security-peer-authenticator");
        if (authMethod == null || authMethod.length() == 0) {
            return null;
        }
        InternalLogWriter securityLogWriter = this.services.getSecurityLogWriter();
        String failMsg = null;
        if (credentials != null) {
            try {
                this.invokeAuthenticator(authMethod, member, credentials);
            }
            catch (Exception ex) {
                securityLogWriter.warning(LocalizedStrings.AUTH_PEER_AUTHENTICATION_FAILED_WITH_EXCEPTION, new Object[]{member, authMethod, ex.getLocalizedMessage()}, (Throwable)ex);
                failMsg = LocalizedStrings.AUTH_PEER_AUTHENTICATION_FAILED.toLocalizedString(localMember);
            }
        } else {
            securityLogWriter.warning(LocalizedStrings.AUTH_PEER_AUTHENTICATION_MISSING_CREDENTIALS, new Object[]{member, authMethod});
            failMsg = LocalizedStrings.AUTH_PEER_AUTHENTICATION_MISSING_CREDENTIALS.toLocalizedString(member, authMethod);
        }
        return failMsg;
    }

    Principal invokeAuthenticator(String authMethod, DistributedMember member, Object credentials) throws AuthenticationFailedException {
        try (CacheCallback auth = null;){
            Method getter = ClassLoadUtil.methodFromName(authMethod);
            auth = (Authenticator)getter.invoke(null, (Object[])null);
            if (auth == null) {
                throw new AuthenticationFailedException(LocalizedStrings.HandShake_AUTHENTICATOR_INSTANCE_COULD_NOT_BE_OBTAINED.toLocalizedString());
            }
            InternalLogWriter logWriter = this.services.getLogWriter();
            InternalLogWriter securityLogWriter = this.services.getSecurityLogWriter();
            auth.init(this.securityProps, logWriter, securityLogWriter);
            Principal principal = auth.authenticate((Properties)credentials, member);
            return principal;
        }
    }

    @Override
    public Object getCredentials(InternalDistributedMember member) {
        try {
            return this.getCredentials(member, this.securityProps);
        }
        catch (Exception e) {
            String authMethod = this.securityProps.getProperty("security-peer-auth-init");
            this.services.getSecurityLogWriter().warning(LocalizedStrings.AUTH_FAILED_TO_OBTAIN_CREDENTIALS_IN_0_USING_AUTHINITIALIZE_1_2, new Object[]{authMethod, e.getLocalizedMessage()});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getCredentials(DistributedMember member, Properties secProps) {
        Properties credentials;
        block7: {
            credentials = null;
            String authMethod = secProps.getProperty("security-peer-auth-init");
            try {
                if (authMethod == null || authMethod.length() <= 0) break block7;
                Method getter = ClassLoadUtil.methodFromName(authMethod);
                AuthInitialize auth = (AuthInitialize)getter.invoke(null, (Object[])null);
                if (auth == null) {
                    throw new AuthenticationRequiredException(LocalizedStrings.AUTH_FAILED_TO_ACQUIRE_AUTHINITIALIZE_INSTANCE.toLocalizedString(authMethod));
                }
                try {
                    InternalLogWriter logWriter = this.services.getLogWriter();
                    InternalLogWriter securityLogWriter = this.services.getSecurityLogWriter();
                    auth.init(logWriter, securityLogWriter);
                    credentials = auth.getCredentials(secProps, member, true);
                }
                finally {
                    auth.close();
                }
            }
            catch (GemFireSecurityException gse) {
                throw gse;
            }
            catch (Exception ex) {
                throw new AuthenticationRequiredException(LocalizedStrings.HandShake_FAILED_TO_ACQUIRE_AUTHINITIALIZE_METHOD_0.toLocalizedString(authMethod), ex);
            }
        }
        return credentials;
    }

    Properties getSecurityProps() {
        Properties props = new Properties();
        Set<Object> keys = System.getProperties().keySet();
        for (Object key : keys) {
            String propKey = (String)key;
            if (!propKey.startsWith(secPrefix)) continue;
            props.setProperty(propKey.substring(gemfireSysPrefixLen), System.getProperty(propKey));
        }
        return props;
    }

    @Override
    public void emergencyClose() {
    }
}

