/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.gms;

import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.SystemConnectException;
import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionException;
import com.gemstone.gemfire.distributed.internal.LocatorStats;
import com.gemstone.gemfire.distributed.internal.membership.DistributedMembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.MemberAttributes;
import com.gemstone.gemfire.distributed.internal.membership.MemberServices;
import com.gemstone.gemfire.distributed.internal.membership.MembershipManager;
import com.gemstone.gemfire.distributed.internal.membership.NetMember;
import com.gemstone.gemfire.distributed.internal.membership.gms.GMSMember;
import com.gemstone.gemfire.distributed.internal.membership.gms.NetLocator;
import com.gemstone.gemfire.distributed.internal.membership.gms.Services;
import com.gemstone.gemfire.distributed.internal.membership.gms.locator.GMSLocator;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.admin.remote.RemoteTransportConfig;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.tcp.ConnectionException;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import com.gemstone.gemfire.security.AuthenticationRequiredException;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class GMSMemberFactory
implements MemberServices {
    @Override
    public NetMember newNetMember(InetAddress i, int p, boolean splitBrainEnabled, boolean canBeCoordinator, MemberAttributes attr, short version) {
        GMSMember result = new GMSMember(attr, i, p, splitBrainEnabled, canBeCoordinator, version, 0L, 0L);
        return result;
    }

    @Override
    public NetMember newNetMember(InetAddress i, int p) {
        return new GMSMember(MemberAttributes.INVALID, i, p, false, true, Version.CURRENT_ORDINAL, 0L, 0L);
    }

    @Override
    public NetMember newNetMember(String s, int p) {
        InetAddress inetAddr = null;
        try {
            inetAddr = SocketCreator.getLocalHost();
        }
        catch (UnknownHostException e2) {
            throw new RuntimeException("Unable to create an identifier for testing for " + s, e2);
        }
        return this.newNetMember(inetAddr, p);
    }

    @Override
    public MembershipManager newMembershipManager(DistributedMembershipListener listener, DistributionConfig config, RemoteTransportConfig transport, DMStats stats) throws DistributionException {
        Services services = new Services(listener, config, transport, stats);
        try {
            services.init();
            services.start();
        }
        catch (ConnectionException e) {
            throw new DistributionException(LocalizedStrings.MemberFactory_UNABLE_TO_CREATE_MEMBERSHIP_MANAGER.toLocalizedString(), e);
        }
        catch (GemFireConfigException | SystemConnectException | AuthenticationFailedException | AuthenticationRequiredException e) {
            throw e;
        }
        catch (RuntimeException e) {
            Services.getLogger().error("Unexpected problem starting up membership services", (Throwable)e);
            throw new SystemConnectException("Problem starting up membership services", e);
        }
        return (MembershipManager)((Object)services.getManager());
    }

    @Override
    public NetLocator newLocatorHandler(InetAddress bindAddress, File stateFile, String locatorString, boolean usePreferredCoordinators, boolean networkPartitionDetectionEnabled, LocatorStats stats) {
        return new GMSLocator(bindAddress, stateFile, locatorString, usePreferredCoordinators, networkPartitionDetectionEnabled, stats);
    }
}

