/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class NetView
implements DataSerializableFixedID {
    private int viewId;
    private List<InternalDistributedMember> members;
    private int[] failureDetectionPorts = new int[10];
    private Set<InternalDistributedMember> shutdownMembers;
    private Set<InternalDistributedMember> crashedMembers;
    private InternalDistributedMember creator;
    private Set<InternalDistributedMember> hashedMembers;
    public static final Random RANDOM = new Random();

    public NetView() {
        this.viewId = 0;
        this.members = new ArrayList<InternalDistributedMember>(4);
        this.hashedMembers = new HashSet<InternalDistributedMember>(this.members);
        this.shutdownMembers = Collections.emptySet();
        this.crashedMembers = new HashSet<InternalDistributedMember>();
        this.creator = null;
        Arrays.fill(this.failureDetectionPorts, -1);
    }

    public NetView(InternalDistributedMember creator) {
        this.viewId = 0;
        this.members = new ArrayList<InternalDistributedMember>(4);
        this.members.add(creator);
        this.hashedMembers = new HashSet<InternalDistributedMember>(this.members);
        this.shutdownMembers = new HashSet<InternalDistributedMember>();
        this.crashedMembers = Collections.emptySet();
        this.creator = creator;
        Arrays.fill(this.failureDetectionPorts, -1);
    }

    public NetView(InternalDistributedMember creator, int viewId, List<InternalDistributedMember> members) {
        this.viewId = viewId;
        this.members = new ArrayList<InternalDistributedMember>(members);
        this.hashedMembers = new HashSet<InternalDistributedMember>(this.members);
        this.shutdownMembers = new HashSet<InternalDistributedMember>();
        this.crashedMembers = Collections.emptySet();
        this.creator = creator;
        Arrays.fill(this.failureDetectionPorts, -1);
    }

    public NetView(int size, long viewId) {
        this.viewId = (int)viewId;
        this.members = new ArrayList<InternalDistributedMember>(size);
        this.hashedMembers = new HashSet<InternalDistributedMember>();
        this.shutdownMembers = new HashSet<InternalDistributedMember>();
        this.crashedMembers = Collections.emptySet();
        this.creator = null;
        Arrays.fill(this.failureDetectionPorts, -1);
    }

    public NetView(NetView other, int viewId) {
        this.creator = other.creator;
        this.viewId = viewId;
        this.members = new ArrayList<InternalDistributedMember>(other.members);
        this.hashedMembers = new HashSet<InternalDistributedMember>(other.members);
        this.failureDetectionPorts = new int[other.failureDetectionPorts.length];
        System.arraycopy(other.failureDetectionPorts, 0, this.failureDetectionPorts, 0, other.failureDetectionPorts.length);
        this.shutdownMembers = new HashSet<InternalDistributedMember>(other.shutdownMembers);
        this.crashedMembers = new HashSet<InternalDistributedMember>(other.crashedMembers);
    }

    public NetView(InternalDistributedMember creator, int viewId, List<InternalDistributedMember> mbrs, Set<InternalDistributedMember> shutdowns, Set<InternalDistributedMember> crashes) {
        this.creator = creator;
        this.viewId = viewId;
        this.members = mbrs;
        this.hashedMembers = new HashSet<InternalDistributedMember>(mbrs);
        this.shutdownMembers = shutdowns;
        this.crashedMembers = crashes;
        this.failureDetectionPorts = new int[mbrs.size() + 10];
        Arrays.fill(this.failureDetectionPorts, -1);
    }

    public int getViewId() {
        return this.viewId;
    }

    public InternalDistributedMember getCreator() {
        return this.creator;
    }

    public void setCreator(InternalDistributedMember creator) {
        this.creator = creator;
    }

    public int[] getFailureDetectionPorts() {
        return this.failureDetectionPorts;
    }

    public int getFailureDetectionPort(InternalDistributedMember mbr) {
        int idx = this.members.indexOf(mbr);
        if (idx < 0 || idx >= this.failureDetectionPorts.length) {
            return -1;
        }
        return this.failureDetectionPorts[idx];
    }

    public void setFailureDetectionPort(InternalDistributedMember mbr, int port) {
        int idx = this.members.indexOf(mbr);
        if (idx < 0) {
            throw new IllegalArgumentException("element not found in members list:" + mbr);
        }
        this.ensureFDCapacity(idx);
        this.failureDetectionPorts[idx] = port;
    }

    public void setFailureDetectionPorts(NetView otherView) {
        int[] ports = otherView.getFailureDetectionPorts();
        if (ports != null) {
            int idx = 0;
            int portsSize = ports.length;
            for (InternalDistributedMember mbr : otherView.getMembers()) {
                if (this.contains(mbr)) {
                    if (idx < portsSize) {
                        this.setFailureDetectionPort(mbr, ports[idx]);
                    } else {
                        this.setFailureDetectionPort(mbr, -1);
                    }
                }
                ++idx;
            }
        }
    }

    private void ensureFDCapacity(int idx) {
        if (idx >= this.failureDetectionPorts.length) {
            int[] p = new int[idx + 10];
            if (this.failureDetectionPorts.length > 0) {
                System.arraycopy(this.failureDetectionPorts, 0, p, 0, this.failureDetectionPorts.length);
            }
            Arrays.fill(p, idx, idx + 9, -1);
            this.failureDetectionPorts = p;
        }
    }

    public List<InternalDistributedMember> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public List<InternalDistributedMember> getNewMembers(NetView olderView) {
        ArrayList<InternalDistributedMember> result = new ArrayList<InternalDistributedMember>(this.members);
        result.removeAll(olderView.getMembers());
        return result;
    }

    public List<InternalDistributedMember> getNewMembers() {
        ArrayList<InternalDistributedMember> result = new ArrayList<InternalDistributedMember>(5);
        for (InternalDistributedMember mbr : this.members) {
            if (mbr.getVmViewId() != this.viewId) continue;
            result.add(mbr);
        }
        return result;
    }

    public Object get(int i) {
        return this.members.get(i);
    }

    public void add(InternalDistributedMember mbr) {
        this.hashedMembers.add(mbr);
        this.members.add(mbr);
        int idx = this.members.size() - 1;
        this.ensureFDCapacity(idx);
        this.failureDetectionPorts[idx] = -1;
    }

    public void addCrashedMembers(Set<InternalDistributedMember> mbr) {
        this.crashedMembers.addAll(mbr);
    }

    public void addShutdownMembers(Set<InternalDistributedMember> mbr) {
        this.shutdownMembers.addAll(mbr);
    }

    public boolean remove(InternalDistributedMember mbr) {
        this.hashedMembers.remove(mbr);
        int idx = this.members.indexOf(mbr);
        if (idx >= 0) {
            System.arraycopy(this.failureDetectionPorts, idx + 1, this.failureDetectionPorts, idx, this.failureDetectionPorts.length - idx - 1);
            this.failureDetectionPorts[this.failureDetectionPorts.length - 1] = -1;
        }
        return this.members.remove(mbr);
    }

    public void removeAll(Collection<InternalDistributedMember> ids) {
        this.hashedMembers.removeAll(ids);
        for (InternalDistributedMember mbr : ids) {
            this.remove(mbr);
        }
    }

    public boolean contains(DistributedMember mbr) {
        return this.hashedMembers.contains(mbr);
    }

    public int size() {
        return this.members.size();
    }

    public InternalDistributedMember getLeadMember() {
        for (InternalDistributedMember mbr : this.members) {
            if (mbr.getVmKind() != 10) continue;
            return mbr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalDistributedMember getCoordinator() {
        List<InternalDistributedMember> list = this.members;
        synchronized (list) {
            for (InternalDistributedMember addr : this.members) {
                if (!addr.getNetMember().preferredForCoordinator()) continue;
                return addr;
            }
            if (this.members.size() > 0) {
                return this.members.get(0);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalDistributedMember getCoordinator(Collection<InternalDistributedMember> rejections) {
        if (rejections == null) {
            return this.getCoordinator();
        }
        List<InternalDistributedMember> list = this.members;
        synchronized (list) {
            for (InternalDistributedMember addr : this.members) {
                if (!addr.getNetMember().preferredForCoordinator() || rejections.contains(addr)) continue;
                return addr;
            }
            for (InternalDistributedMember addr : this.members) {
                if (rejections.contains(addr)) continue;
                return addr;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InternalDistributedMember> getPreferredCoordinators(Set<InternalDistributedMember> filter, InternalDistributedMember localAddress, int maxNumberDesired) {
        ArrayList<InternalDistributedMember> results = new ArrayList<InternalDistributedMember>();
        ArrayList<InternalDistributedMember> notPreferredCoordinatorList = new ArrayList<InternalDistributedMember>();
        List<InternalDistributedMember> list = this.members;
        synchronized (list) {
            for (InternalDistributedMember addr : this.members) {
                if (addr.equals(localAddress)) continue;
                if (addr.getNetMember().preferredForCoordinator()) {
                    results.add(addr);
                    if (results.size() < maxNumberDesired) continue;
                    break;
                }
                if (filter.contains(addr)) continue;
                notPreferredCoordinatorList.add(addr);
            }
            results.add(localAddress);
            if (notPreferredCoordinatorList.size() > 0) {
                int idx = RANDOM.nextInt(notPreferredCoordinatorList.size());
                results.add((InternalDistributedMember)notPreferredCoordinatorList.get(idx));
            }
        }
        return results;
    }

    public Set<InternalDistributedMember> getShutdownMembers() {
        return this.shutdownMembers;
    }

    public Set<InternalDistributedMember> getCrashedMembers() {
        return this.crashedMembers;
    }

    public boolean shouldBeCoordinator(InternalDistributedMember who) {
        Iterator<InternalDistributedMember> it = this.members.iterator();
        InternalDistributedMember firstNonPreferred = null;
        while (it.hasNext()) {
            InternalDistributedMember mbr = it.next();
            if (mbr.getNetMember().preferredForCoordinator()) {
                return mbr.equals(who);
            }
            if (firstNonPreferred != null) continue;
            firstNonPreferred = mbr;
        }
        return firstNonPreferred == null || firstNonPreferred.equals(who);
    }

    public int memberWeight() {
        int result = 0;
        InternalDistributedMember lead = this.getLeadMember();
        block5: for (InternalDistributedMember mbr : this.members) {
            result += mbr.getNetMember().getMemberWeight();
            switch (mbr.getVmKind()) {
                case 10: {
                    result += 10;
                    if (lead == null || !mbr.equals(lead)) continue block5;
                    result += 5;
                    continue block5;
                }
                case 11: {
                    result += 3;
                    continue block5;
                }
                case 12: {
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown member type: " + mbr.getVmKind());
        }
        return result;
    }

    public int getCrashedMemberWeight(NetView oldView) {
        int result = 0;
        InternalDistributedMember lead = oldView.getLeadMember();
        block5: for (InternalDistributedMember mbr : this.crashedMembers) {
            if (!oldView.contains(mbr)) continue;
            result += mbr.getNetMember().getMemberWeight();
            switch (mbr.getVmKind()) {
                case 10: {
                    result += 10;
                    if (lead == null || !mbr.equals(lead)) continue block5;
                    result += 5;
                    continue block5;
                }
                case 11: {
                    result += 3;
                    continue block5;
                }
                case 12: {
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown member type: " + mbr.getVmKind());
        }
        return result;
    }

    public Set<InternalDistributedMember> getActualCrashedMembers(NetView oldView) {
        HashSet<InternalDistributedMember> result = new HashSet<InternalDistributedMember>(this.crashedMembers.size());
        for (InternalDistributedMember mbr : this.crashedMembers) {
            if (mbr.getVmKind() == 12 || oldView != null && !oldView.contains(mbr)) continue;
            result.add(mbr);
        }
        return result;
    }

    public void logCrashedMemberWeights(NetView oldView, Logger log) {
        InternalDistributedMember lead = oldView.getLeadMember();
        for (InternalDistributedMember mbr : this.crashedMembers) {
            if (!oldView.contains(mbr)) continue;
            int mbrWeight = mbr.getNetMember().getMemberWeight();
            switch (mbr.getVmKind()) {
                case 10: {
                    if (lead != null && mbr.equals(lead)) {
                        mbrWeight += 15;
                        break;
                    }
                    mbrWeight += 10;
                    break;
                }
                case 11: {
                    mbrWeight += 3;
                    break;
                }
                case 12: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown member type: " + mbr.getVmKind());
                }
            }
            log.info("  " + mbr + " had a weight of " + mbrWeight);
        }
    }

    public String toString() {
        InternalDistributedMember lead = this.getLeadMember();
        StringBuilder sb = new StringBuilder(200);
        sb.append("View[").append(this.creator).append('|').append(this.viewId).append("] members: [");
        boolean first = true;
        for (InternalDistributedMember mbr : this.members) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(mbr);
            if (mbr == lead) {
                sb.append("{lead}");
            }
            first = false;
        }
        if (!this.shutdownMembers.isEmpty()) {
            sb.append("]  shutdown: [");
            first = true;
            for (InternalDistributedMember mbr : this.shutdownMembers) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(mbr);
                first = false;
            }
        }
        if (!this.crashedMembers.isEmpty()) {
            sb.append("]  crashed: [");
            first = true;
            for (InternalDistributedMember mbr : this.crashedMembers) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(mbr);
                first = false;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public synchronized InternalDistributedMember getCanonicalID(InternalDistributedMember id) {
        if (this.hashedMembers.contains(id)) {
            for (InternalDistributedMember m : this.members) {
                if (!id.equals(m)) continue;
                return m;
            }
        }
        return id;
    }

    public synchronized boolean equals(Object arg0) {
        if (arg0 == this) {
            return true;
        }
        if (!(arg0 instanceof NetView)) {
            return false;
        }
        return this.members.equals(((NetView)arg0).getMembers());
    }

    public synchronized int hashCode() {
        return this.members.hashCode();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.creator, out);
        out.writeInt(this.viewId);
        this.writeAsArrayList(this.members, out);
        InternalDataSerializer.writeSet(this.shutdownMembers, out);
        InternalDataSerializer.writeSet(this.crashedMembers, out);
        DataSerializer.writeIntArray(this.failureDetectionPorts, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.creator = (InternalDistributedMember)DataSerializer.readObject(in);
        this.viewId = in.readInt();
        this.members = DataSerializer.readArrayList(in);
        this.hashedMembers = new HashSet<InternalDistributedMember>(this.members);
        this.shutdownMembers = InternalDataSerializer.readHashSet(in);
        this.crashedMembers = InternalDataSerializer.readHashSet(in);
        this.failureDetectionPorts = DataSerializer.readIntArray(in);
    }

    private void writeAsArrayList(List list, DataOutput out) throws IOException {
        int size = list == null ? -1 : list.size();
        InternalDataSerializer.writeArrayLength(size, out);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                DataSerializer.writeObject(list.get(i), out);
            }
        }
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public int getDSFID() {
        return -148;
    }
}

