/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.locks;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public class Collaboration {
    private static final Logger logger = LogService.getLogger();
    private static final Object NULL_TOPIC = null;
    private volatile Topic currentTopic;
    private final List topicsQueue = new ArrayList();
    private final Map topicsMap = new HashMap();
    private final CancelCriterion stopper;

    public Collaboration(CancelCriterion stopper) {
        this.stopper = stopper;
    }

    public void acquire(Object topicObject) throws InterruptedException {
        throw new UnsupportedOperationException(LocalizedStrings.Collaboration_NOT_IMPLEMENTED.toLocalizedString());
    }

    private void assertNotRecursingTopic(Object topicObject) {
        Assert.assertTrue(false, Thread.currentThread() + " attempting to lock topic " + topicObject + " while locking topic " + this.currentTopic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireUninterruptibly(Object topic) {
        Object topicObject = topic;
        if (topicObject == null) {
            topicObject = NULL_TOPIC;
        }
        Topic pendingTopic = null;
        List list = this.topicsQueue;
        synchronized (list) {
            if (this.currentTopic == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Collaboration.acquireUninterruptibly: {}: no current topic, setting topic to {}", new Object[]{this.toString(), topicObject});
                }
                this.setCurrentTopic(new Topic(topicObject));
                this.currentTopic.addThread(Thread.currentThread());
                this.topicsMap.put(topicObject, this.currentTopic);
                return;
            }
            if (this.isCurrentTopic(topicObject)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Collaboration.acquireUninterruptibly: {}: already current topic: {}", new Object[]{this.toString(), topicObject});
                }
                this.currentTopic.addThread(Thread.currentThread());
                return;
            }
            if (this.hasCurrentTopic(Thread.currentThread())) {
                this.assertNotRecursingTopic(topicObject);
            } else {
                pendingTopic = (Topic)this.topicsMap.get(topicObject);
                if (pendingTopic == null) {
                    pendingTopic = new Topic(topicObject);
                    this.topicsMap.put(topicObject, pendingTopic);
                    this.topicsQueue.add(pendingTopic);
                }
                pendingTopic.addThread(Thread.currentThread());
                if (logger.isDebugEnabled()) {
                    logger.debug("Collaboration.acquireUninterruptibly: {}: adding pendingTopic {}; current topic is {}", new Object[]{this.toString(), pendingTopic, this.currentTopic});
                }
            }
        }
        boolean interrupted = Thread.interrupted();
        try {
            this.awaitTopic(pendingTopic, false);
        }
        catch (InterruptedException e) {
            interrupted = true;
            this.stopper.checkCancelInProgress(e);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentTopic(Topic topic) {
        List list = this.topicsQueue;
        synchronized (list) {
            Topic topic2;
            if (this.currentTopic != null) {
                topic2 = this.currentTopic;
                synchronized (topic2) {
                    this.currentTopic.setCurrentTopic(false);
                    this.currentTopic.setOldTopic(true);
                }
            }
            if (topic != null) {
                topic2 = topic;
                synchronized (topic2) {
                    topic.setCurrentTopic(true);
                    this.currentTopic = topic;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Collaboration.setCurrentTopic: {}: new topic is {}", new Object[]{this.getIdentity(), topic});
                    }
                    this.currentTopic.notifyAll();
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Collaboration.setCurrentTopic: {} setting current topic to null", new Object[]{this.toString()});
                }
                this.currentTopic = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void awaitTopic(Topic topic, boolean interruptible) throws InterruptedException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        Topic topic2 = topic;
        synchronized (topic2) {
            while (!topic.isCurrentTopic()) {
                if (topic.isOldTopic()) {
                    Assert.assertTrue(false, "[" + this.getIdentity() + ".awaitTopic] attempting to wait on old topic");
                }
                boolean interrupted = Thread.interrupted();
                try {
                    Topic sniff = this.currentTopic;
                    if (isDebugEnabled) {
                        logger.debug("Collaboration.awaitTopic: {} waiting for topic {}; current topic probably {}, which may have a thread count of {}", new Object[]{this.getIdentity(), topic, sniff.toString(), sniff.threadCount()});
                    }
                    topic.wait();
                }
                catch (InterruptedException e) {
                    if (interruptible) {
                        throw e;
                    }
                    interrupted = true;
                    this.stopper.checkCancelInProgress(e);
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
    }

    public boolean tryAcquire(Object topicObject) {
        throw new UnsupportedOperationException(LocalizedStrings.Collaboration_NOT_IMPLEMENTED.toLocalizedString());
    }

    public boolean tryAcquire(Object topicObject, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException(LocalizedStrings.Collaboration_NOT_IMPLEMENTED.toLocalizedString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        List list = this.topicsQueue;
        synchronized (list) {
            Topic topic = this.currentTopic;
            if (topic == null) {
                throw new IllegalStateException(LocalizedStrings.Collaboration_COLLABORATION_HAS_NO_CURRENT_TOPIC.toLocalizedString());
            }
            if (isDebugEnabled) {
                logger.debug("Collaboration.release: {} releasing topic", new Object[]{this.toString()});
            }
            if (topic.isEmptyAfterRemovingThread(Thread.currentThread())) {
                if (isDebugEnabled) {
                    logger.debug("Collaboration.release: {} released old topic {}", new Object[]{this.toString(), topic});
                }
                this.topicsMap.remove(topic.getTopicObject());
                if (!this.topicsQueue.isEmpty()) {
                    Topic nextTopic = (Topic)this.topicsQueue.remove(0);
                    this.setCurrentTopic(nextTopic);
                } else {
                    this.setCurrentTopic(null);
                }
            } else if (isDebugEnabled) {
                logger.debug("Collaboration.release: {} released current topic ", new Object[]{this.toString()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCurrentTopic(Thread thread) {
        List list = this.topicsQueue;
        synchronized (list) {
            if (this.currentTopic == null) {
                return false;
            }
            return this.currentTopic.hasThread(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCurrentTopic() {
        List list = this.topicsQueue;
        synchronized (list) {
            return this.currentTopic != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrentTopic(Object topicObject) {
        if (topicObject == null) {
            throw new IllegalArgumentException(LocalizedStrings.Collaboration_TOPIC_MUST_BE_SPECIFIED.toLocalizedString());
        }
        List list = this.topicsQueue;
        synchronized (list) {
            if (this.currentTopic == null) {
                return false;
            }
            return this.currentTopic.getTopicObject().equals(topicObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List list = this.topicsQueue;
        synchronized (list) {
            Topic topic = this.currentTopic;
            int threadCount = 0;
            if (topic != null) {
                threadCount = topic.threadCount();
            }
            return this.getIdentity() + ": topic=" + topic + " threadCount=" + threadCount;
        }
    }

    protected String getIdentity() {
        String me = super.toString();
        return me.substring(me.lastIndexOf(".") + 1);
    }

    public static class Topic {
        private boolean isCurrentTopic = false;
        private boolean isOldTopic = false;
        private final Object topicObject;
        private final List participatingThreads = new ArrayList();

        public Topic(Object topicObject) {
            this.topicObject = topicObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCurrentTopic() {
            Topic topic = this;
            synchronized (topic) {
                return this.isCurrentTopic;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isOldTopic() {
            Topic topic = this;
            synchronized (topic) {
                return this.isOldTopic;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getTopicObject() {
            Topic topic = this;
            synchronized (topic) {
                return this.topicObject;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOldTopic(boolean v) {
            Topic topic = this;
            synchronized (topic) {
                this.isOldTopic = v;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCurrentTopic(boolean v) {
            Topic topic = this;
            synchronized (topic) {
                this.isOldTopic = v;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmptyAfterRemovingThread(Thread thread) {
            Topic topic = this;
            synchronized (topic) {
                boolean removed = this.participatingThreads.remove(thread);
                if (!removed) {
                    Assert.assertTrue(false, "thread " + thread + " was not participating in " + this);
                }
                return this.participatingThreads.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addThread(Thread thread) {
            Topic topic = this;
            synchronized (topic) {
                this.participatingThreads.add(thread);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeThread(Thread thread) {
            Topic topic = this;
            synchronized (topic) {
                return this.participatingThreads.remove(thread);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int threadCount() {
            Topic topic = this;
            synchronized (topic) {
                return this.participatingThreads.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasThread(Thread thread) {
            Topic topic = this;
            synchronized (topic) {
                return this.participatingThreads.contains(thread);
            }
        }

        public String toString() {
            String nick = super.toString();
            nick = nick.substring(nick.lastIndexOf(".") + 1);
            return nick + ": " + this.topicObject;
        }
    }
}

