/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.deadlock;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class UnsafeThreadLocal<T>
extends ThreadLocal<T> {
    public T get(Thread thread) {
        return (T)UnsafeThreadLocal.get(this, thread);
    }

    private static Object get(ThreadLocal threadLocal, Thread thread) {
        try {
            Object entry;
            Object threadLocalMap = UnsafeThreadLocal.invokePrivate(threadLocal, "getMap", new Class[]{Thread.class}, new Object[]{thread});
            if (threadLocalMap != null && (entry = UnsafeThreadLocal.invokePrivate(threadLocalMap, "getEntry", new Class[]{ThreadLocal.class}, new Object[]{threadLocal})) != null) {
                return UnsafeThreadLocal.getPrivate(entry, "value");
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to extract thread local", e);
        }
    }

    private static Object getPrivate(Object object, String fieldName) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = object.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(object);
    }

    private static Object invokePrivate(Object object, String methodName, Class[] argTypes, Object[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = null;
        Class<?> clazz = object.getClass();
        while (method == null) {
            try {
                method = clazz.getDeclaredMethod(methodName, argTypes);
            }
            catch (NoSuchMethodException e) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw e;
            }
        }
        method.setAccessible(true);
        Object result = method.invoke(object, args);
        return result;
    }
}

