/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.deadlock;

import com.gemstone.gemfire.internal.concurrent.LI;
import java.io.Serializable;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;

class LocalLockInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Serializable locatility;
    private final LI info;

    public LocalLockInfo(Serializable locatility, LockInfo sync) {
        this.locatility = locatility;
        this.info = sync instanceof MonitorInfo ? new LI(sync.getClassName(), sync.getIdentityHashCode(), ((MonitorInfo)sync).getLockedStackFrame()) : new LI(sync.getClassName(), sync.getIdentityHashCode());
    }

    public Serializable getLocality() {
        return this.locatility;
    }

    public LI getInfo() {
        return this.info;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.info == null ? 0 : this.info.getClassName().hashCode());
        result = 31 * result + (this.info == null ? 0 : this.info.getIdentityHashCode());
        result = 31 * result + (this.locatility == null ? 0 : this.locatility.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalLockInfo)) {
            return false;
        }
        LocalLockInfo other = (LocalLockInfo)obj;
        if (this.info == null) {
            if (other.info != null) {
                return false;
            }
        } else {
            if (!this.info.getClassName().equals(other.info.getClassName())) {
                return false;
            }
            if (this.info.getIdentityHashCode() != other.info.getIdentityHashCode()) {
                return false;
            }
        }
        return !(this.locatility == null ? other.locatility != null : !this.locatility.equals(other.locatility));
    }

    public String toString() {
        return this.locatility + ":" + this.info;
    }
}

