/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.StartupMessage;
import com.gemstone.gemfire.distributed.internal.StartupMessageReplyProcessor;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.RemoteTransportConfig;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class StartupOperation {
    private static final Logger logger = LogService.getLogger();
    DistributionManager dm;
    RemoteTransportConfig transport;
    Set newlyDeparted;

    StartupOperation(DistributionManager dm, RemoteTransportConfig transport) {
        this.dm = dm;
        this.transport = transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendStartupMessage(Set recipients, long timeout, Set interfaces, String redundancyZone, boolean enforceUniqueZone) throws InterruptedException, ReplyException, UnknownHostException, IOException {
        block15: {
            Iterator it;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            StartupMessageReplyProcessor proc = new StartupMessageReplyProcessor((DM)this.dm, recipients);
            boolean isSharedConfigurationEnabled = false;
            if (InternalLocator.hasLocator()) {
                isSharedConfigurationEnabled = InternalLocator.getLocator().isSharedConfigurationEnabled();
            }
            StartupMessage msg = new StartupMessage(InternalLocator.getLocatorStrings(), isSharedConfigurationEnabled);
            msg.setInterfaces(interfaces);
            msg.setDistributedSystemId(this.dm.getConfig().getDistributedSystemId());
            msg.setRedundancyZone(redundancyZone);
            msg.setEnforceUniqueZone(enforceUniqueZone);
            msg.setMcastEnabled(this.transport.isMcastEnabled());
            msg.setMcastPort(this.dm.getSystem().getOriginalConfig().getMcastPort());
            msg.setMcastHostAddress(this.dm.getSystem().getOriginalConfig().getMcastAddress());
            msg.setTcpDisabled(this.transport.isTcpDisabled());
            msg.setRecipients(recipients);
            msg.setReplyProcessorId(proc.getProcessorId());
            this.newlyDeparted = this.dm.sendOutgoing(msg);
            if (this.newlyDeparted != null && !this.newlyDeparted.isEmpty()) {
                for (InternalDistributedMember id : this.newlyDeparted) {
                    this.dm.handleManagerDeparture(id, false, LocalizedStrings.StartupOperation_LEFT_THE_MEMBERSHIP_VIEW.toLocalizedString());
                    proc.memberDeparted(id, true);
                }
            }
            if (proc.stillWaiting() && logger.isDebugEnabled()) {
                logger.debug("Waiting {} milliseconds to receive startup responses", new Object[]{timeout});
            }
            boolean timedOut = true;
            HashSet unresponsive = null;
            try {
                boolean bl = timedOut = !proc.waitForReplies(timeout);
                if (!timedOut) break block15;
                unresponsive = new HashSet();
                proc.collectUnresponsiveMembers(unresponsive);
                if (unresponsive.isEmpty()) break block15;
                it = unresponsive.iterator();
            }
            catch (Throwable throwable) {
                if (timedOut) {
                    unresponsive = new HashSet();
                    proc.collectUnresponsiveMembers(unresponsive);
                    if (!unresponsive.isEmpty()) {
                        Iterator it2 = unresponsive.iterator();
                        while (it2.hasNext()) {
                            InternalDistributedMember um = (InternalDistributedMember)it2.next();
                            if (!this.dm.getViewMembers().contains(um)) {
                                it2.remove();
                                this.dm.handleManagerDeparture(um, true, LocalizedStrings.StartupOperation_DISAPPEARED_DURING_STARTUP_HANDSHAKE.toLocalizedString());
                                continue;
                            }
                            if (!this.dm.isCurrentMember(um)) continue;
                            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.StartupOperation_MEMBERSHIP_RECEIVED_CONNECTION_FROM_0_BUT_RECEIVED_NO_STARTUP_RESPONSE_AFTER_1_MS, new Object[]{um, timeout}));
                        }
                        this.dm.setUnfinishedStartups(unresponsive);
                        if (!unresponsive.isEmpty()) {
                            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.StartupOperation_MEMBERSHIP_STARTUP_TIMED_OUT_AFTER_WAITING_0_MILLISECONDS_FOR_RESPONSES_FROM_1, new Object[]{timeout, unresponsive}));
                        }
                    }
                }
                throw throwable;
            }
            while (it.hasNext()) {
                InternalDistributedMember um = (InternalDistributedMember)it.next();
                if (!this.dm.getViewMembers().contains(um)) {
                    it.remove();
                    this.dm.handleManagerDeparture(um, true, LocalizedStrings.StartupOperation_DISAPPEARED_DURING_STARTUP_HANDSHAKE.toLocalizedString());
                    continue;
                }
                if (!this.dm.isCurrentMember(um)) continue;
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.StartupOperation_MEMBERSHIP_RECEIVED_CONNECTION_FROM_0_BUT_RECEIVED_NO_STARTUP_RESPONSE_AFTER_1_MS, new Object[]{um, timeout}));
            }
            this.dm.setUnfinishedStartups(unresponsive);
            if (!unresponsive.isEmpty()) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.StartupOperation_MEMBERSHIP_STARTUP_TIMED_OUT_AFTER_WAITING_0_MILLISECONDS_FOR_RESPONSES_FROM_1, new Object[]{timeout, unresponsive}));
            }
        }
        boolean problems = this.newlyDeparted != null && this.newlyDeparted.size() > 0;
        return !problems;
    }
}

