/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.AdminMessageType;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ShutdownMessage
extends HighPriorityDistributionMessage
implements AdminMessageType,
MessageWithReply {
    protected InternalDistributedMember id;
    private int processorId;

    void setDistributionManagerId(InternalDistributedMember id) {
        this.id = id;
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    public void setProcessorId(int pid) {
        this.processorId = pid;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    public boolean getInlineProcess() {
        return false;
    }

    @Override
    protected void process(DistributionManager dm) {
        Assert.assertTrue(this.id != null);
        dm.shutdownMessageReceived(this.id, LocalizedStrings.ShutdownMessage_SHUTDOWN_MESSAGE_RECEIVED.toLocalizedString());
    }

    @Override
    public int getDSFID() {
        return 98;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
        DataSerializer.writeObject(this.id, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
        this.id = (InternalDistributedMember)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return LocalizedStrings.ShutdownMessage_SHUTDOWNMESSAGE_DM_0_HAS_SHUTDOWN.toLocalizedString(this.id);
    }
}

