/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberManager;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberPattern;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.functions.ImportSharedConfigurationArtifactsFunction;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.configuration.callbacks.ConfigurationChangeListener;
import com.gemstone.gemfire.management.internal.configuration.domain.Configuration;
import com.gemstone.gemfire.management.internal.configuration.domain.SharedConfigurationStatus;
import com.gemstone.gemfire.management.internal.configuration.domain.XmlEntity;
import com.gemstone.gemfire.management.internal.configuration.functions.GetAllJarsFunction;
import com.gemstone.gemfire.management.internal.configuration.messages.ConfigurationRequest;
import com.gemstone.gemfire.management.internal.configuration.messages.ConfigurationResponse;
import com.gemstone.gemfire.management.internal.configuration.messages.SharedConfigurationStatusResponse;
import com.gemstone.gemfire.management.internal.configuration.utils.XmlUtils;
import com.gemstone.gemfire.management.internal.configuration.utils.ZipUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SharedConfiguration {
    private static final Logger logger = LogService.getLogger();
    public static final String CLUSTER_CONFIG_ARTIFACTS_DIR_NAME = "cluster_config";
    public static final String CLUSTER_CONFIG_DISK_STORE_NAME = "cluster_config";
    public static String CONFIG_DIR_PATH;
    public static final String CLUSTER_CONFIG_DISK_DIR_PREFIX = "ConfigDiskDir_";
    public static final String CLUSTER_CONFIG = "cluster";
    public static final String SHARED_CONFIG_LOCK_SERVICE_NAME = "__CLUSTER_CONFIG_LS";
    public static final String SHARED_CONFIG_LOCK_NAME = "__CLUSTER_CONFIG_LOCK";
    public static final String CONFIG_REGION_NAME = "_ConfigurationRegion";
    public String CONFIG_DISK_DIR_NAME;
    public String CONFIG_DISK_DIR_PATH;
    private final Set<PersistentMemberPattern> newerSharedConfigurationLocatorInfo = new HashSet<PersistentMemberPattern>();
    private final AtomicReference<SharedConfigurationStatus> status = new AtomicReference();
    private static final GetAllJarsFunction getAllJarsFunction;
    private static final JarFileFilter jarFileFilter;
    private GemFireCacheImpl cache;
    private final DistributedLockService sharedConfigLockingService;

    public static DistributedLockService getSharedConfigLockService(DistributedSystem ds) {
        DistributedLockService sharedConfigDls = DLockService.getServiceNamed(SHARED_CONFIG_LOCK_SERVICE_NAME);
        try {
            if (sharedConfigDls == null) {
                sharedConfigDls = DLockService.create(SHARED_CONFIG_LOCK_SERVICE_NAME, (InternalDistributedSystem)ds, true, true);
            }
        }
        catch (IllegalArgumentException e) {
            return DLockService.getServiceNamed(SHARED_CONFIG_LOCK_SERVICE_NAME);
        }
        return sharedConfigDls;
    }

    private static String[] getSubdirectories(String path) {
        File directory = new File(path);
        return directory.list((FilenameFilter)DirectoryFileFilter.INSTANCE);
    }

    public SharedConfiguration(Cache cache) throws IOException {
        this.cache = (GemFireCacheImpl)cache;
        this.CONFIG_DISK_DIR_NAME = CLUSTER_CONFIG_DISK_DIR_PREFIX + cache.getDistributedSystem().getName();
        String clusterConfigDir = cache.getDistributedSystem().getProperties().getProperty("cluster-configuration-dir");
        if (StringUtils.isBlank(clusterConfigDir)) {
            clusterConfigDir = System.getProperty("user.dir");
        } else {
            File diskDir = new File(clusterConfigDir);
            if (!diskDir.exists() && !diskDir.mkdirs()) {
                throw new IOException("Cannot create directory : " + clusterConfigDir);
            }
            clusterConfigDir = diskDir.getCanonicalPath();
        }
        this.CONFIG_DISK_DIR_PATH = FilenameUtils.concat((String)clusterConfigDir, (String)this.CONFIG_DISK_DIR_NAME);
        CONFIG_DIR_PATH = FilenameUtils.concat((String)clusterConfigDir, (String)"cluster_config");
        this.sharedConfigLockingService = SharedConfiguration.getSharedConfigLockService(cache.getDistributedSystem());
        this.status.set(SharedConfigurationStatus.NOT_STARTED);
    }

    public boolean addJars(String[] jarNames, byte[][] jarBytes, String[] groups) {
        boolean success = true;
        try {
            if (groups == null) {
                groups = new String[]{CLUSTER_CONFIG};
            }
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            for (String group : groups) {
                Configuration configuration = configRegion.get(group);
                if (configuration == null) {
                    configuration = new Configuration(group);
                    this.writeConfig(configuration);
                }
                configuration.addJarNames(jarNames);
                configRegion.put(group, configuration);
                String groupDir = FilenameUtils.concat((String)CONFIG_DIR_PATH, (String)group);
                this.writeJarFiles(groupDir, jarNames, jarBytes);
            }
        }
        catch (Exception e) {
            success = false;
            logger.info(e.getMessage(), (Throwable)e);
        }
        return success;
    }

    public void addXmlEntity(XmlEntity xmlEntity, String[] groups) throws Exception {
        Region<String, Configuration> configRegion = this.getConfigurationRegion();
        if (groups == null || groups.length == 0) {
            groups = new String[]{CLUSTER_CONFIG};
        }
        for (String group : groups) {
            String xmlContent;
            Configuration configuration = configRegion.get(group);
            if (configuration == null) {
                configuration = new Configuration(group);
            }
            if ((xmlContent = configuration.getCacheXmlContent()) == null || xmlContent.isEmpty()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                CacheXmlGenerator.generateDefault(pw);
                xmlContent = sw.toString();
            }
            Document doc = SharedConfiguration.createAndUpgradeDocumentFromXml(xmlContent);
            XmlUtils.addNewNode(doc, xmlEntity);
            configuration.setCacheXmlContent(XmlUtils.prettyXml(doc));
            configRegion.put(group, configuration);
            this.writeConfig(configuration);
        }
    }

    static Document createAndUpgradeDocumentFromXml(String xmlContent) throws SAXException, ParserConfigurationException, IOException, XPathExpressionException {
        Document doc = XmlUtils.createDocumentFromXml(xmlContent);
        if (!"1.0".equals(XmlUtils.getAttribute(doc.getDocumentElement(), "version", "http://geode.apache.org/schema/cache"))) {
            doc = XmlUtils.upgradeSchema(doc, "http://geode.apache.org/schema/cache", "http://geode.apache.org/schema/cache/cache-1.0.xsd", "1.0");
        }
        return doc;
    }

    public void clearSharedConfiguration() throws Exception {
        Region<String, Configuration> configRegion = this.getConfigurationRegion();
        if (configRegion != null) {
            configRegion.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSharedConfiguration(boolean loadSharedConfigFromDir) throws Exception {
        this.status.set(SharedConfigurationStatus.STARTED);
        Region<String, Configuration> configRegion = this.getConfigurationRegion();
        if (loadSharedConfigFromDir) {
            this.lockSharedConfiguration();
            try {
                HashSet<DistributedMember> locatorsWithSC;
                logger.info("Reading cluster configuration from '{}' directory", new Object[]{"cluster_config"});
                Map<String, Configuration> sharedConfigMap = this.readSharedConfigurationFromDisk();
                DM dm = this.cache.getDistributedSystem().getDistributionManager();
                if (dm.getNormalDistributionManagerIds().isEmpty() && !(locatorsWithSC = new HashSet<DistributedMember>(dm.getAllHostedLocatorsWithSharedConfiguration().keySet())).isEmpty()) {
                    ImportSharedConfigurationArtifactsFunction fn = new ImportSharedConfigurationArtifactsFunction();
                    Date date = new Date();
                    String zipFileName = CliStrings.format("cluster-config-{0}.zip", (Object)new Timestamp(date.getTime()).toString());
                    try {
                        ZipUtils.zip(this.getSharedConfigurationDirPath(), zipFileName);
                        File zipFile = new File(zipFileName);
                        byte[] zipBytes = FileUtils.readFileToByteArray((File)zipFile);
                        Object[] args = new Object[]{zipFileName, zipBytes};
                        CliUtil.executeFunction((Function)fn, (Object)args, locatorsWithSC).getResult();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                configRegion.clear();
                configRegion.putAll(sharedConfigMap);
            }
            finally {
                this.unlockSharedConfiguration();
            }
        }
        this.lockSharedConfiguration();
        try {
            Set<Map.Entry<String, Configuration>> configEntries = configRegion.entrySet();
            for (Map.Entry<String, Configuration> configEntry : configEntries) {
                Configuration configuration = configEntry.getValue();
                try {
                    this.writeConfig(configuration);
                }
                catch (Exception e) {
                    logger.info(e.getMessage(), (Throwable)e);
                }
            }
            logger.info("Completed writing the shared configuration to 'cluster_config' directory");
            this.getAllJarsFromOtherLocators();
        }
        finally {
            this.unlockSharedConfiguration();
        }
        this.status.set(SharedConfigurationStatus.RUNNING);
    }

    public boolean lockSharedConfiguration() {
        return this.sharedConfigLockingService.lock(SHARED_CONFIG_LOCK_NAME, -1L, -1L);
    }

    public void unlockSharedConfiguration() {
        this.sharedConfigLockingService.unlock(SHARED_CONFIG_LOCK_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationResponse createConfigurationReponse(ConfigurationRequest configRequest) throws Exception {
        ConfigurationResponse configResponse = new ConfigurationResponse();
        for (int i = 0; i < configRequest.getNumAttempts(); ++i) {
            boolean isLocked = this.sharedConfigLockingService.lock(SHARED_CONFIG_LOCK_NAME, 5000L, 5000L);
            try {
                if (!isLocked) continue;
                Set<String> groups = configRequest.getGroups();
                groups.add(CLUSTER_CONFIG);
                logger.info("Building up configuration response with following configurations: {}", new Object[]{groups});
                for (String group : groups) {
                    Configuration configuration = this.getConfiguration(group);
                    configResponse.addConfiguration(configuration);
                }
                Object[] jars = this.getAllJars(groups);
                if (jars != null) {
                    String[] jarNames = (String[])jars[0];
                    byte[][] jarBytes = (byte[][])jars[1];
                    configResponse.addJarsToBeDeployed(jarNames, jarBytes);
                }
                configResponse.setFailedToGetSharedConfig(false);
                ConfigurationResponse configurationResponse = configResponse;
                return configurationResponse;
            }
            finally {
                this.sharedConfigLockingService.unlock(SHARED_CONFIG_LOCK_NAME);
            }
        }
        configResponse.setFailedToGetSharedConfig(true);
        return configResponse;
    }

    public SharedConfigurationStatusResponse createStatusResponse() {
        SharedConfigurationStatusResponse response = new SharedConfigurationStatusResponse();
        response.setStatus(this.getStatus());
        response.addWaitingLocatorInfo(this.newerSharedConfigurationLocatorInfo);
        return response;
    }

    public void deleteXmlEntity(XmlEntity xmlEntity, String[] groups) throws Exception {
        Region<String, Configuration> configRegion = this.getConfigurationRegion();
        if (groups == null) {
            Set<String> groupSet = configRegion.keySet();
            groups = groupSet.toArray(new String[groupSet.size()]);
        }
        for (String group : groups) {
            String xmlContent;
            Configuration configuration = configRegion.get(group);
            if (configuration == null || (xmlContent = configuration.getCacheXmlContent()) == null || xmlContent.isEmpty()) continue;
            Document doc = SharedConfiguration.createAndUpgradeDocumentFromXml(xmlContent);
            XmlUtils.deleteNode(doc, xmlEntity);
            configuration.setCacheXmlContent(XmlUtils.prettyXml(doc));
            configRegion.put(group, configuration);
            this.writeConfig(configuration);
        }
    }

    public void modifyCacheAttributes(XmlEntity xmlEntity, String[] groups) throws Exception {
        Region<String, Configuration> configRegion = this.getConfigurationRegion();
        if (groups == null) {
            Set<String> groupSet = configRegion.keySet();
            groups = groupSet.toArray(new String[groupSet.size()]);
        }
        for (String group : groups) {
            String xmlContent;
            Configuration configuration = configRegion.get(group);
            if (configuration == null) {
                configuration = new Configuration(group);
            }
            if ((xmlContent = configuration.getCacheXmlContent()) == null || xmlContent.isEmpty()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                CacheXmlGenerator.generateDefault(pw);
                xmlContent = sw.toString();
            }
            Document doc = SharedConfiguration.createAndUpgradeDocumentFromXml(xmlContent);
            XmlUtils.modifyRootAttributes(doc, xmlEntity);
            configuration.setCacheXmlContent(XmlUtils.prettyXml(doc));
            configRegion.put(group, configuration);
            this.writeConfig(configuration);
        }
    }

    public void destroySharedConfiguration() {
        try {
            DiskStore configDiskStore;
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            if (configRegion != null) {
                configRegion.destroyRegion();
            }
            if ((configDiskStore = this.cache.findDiskStore("cluster_config")) != null) {
                configDiskStore.destroy();
                File file = new File(this.CONFIG_DISK_DIR_PATH);
                FileUtils.deleteDirectory((File)file);
            }
            FileUtils.deleteDirectory((File)new File(CONFIG_DIR_PATH));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public Object[] getAllJars(Set<String> groups) throws Exception {
        HashSet<String> jarsAdded = new HashSet<String>();
        Object[] jars = new Object[2];
        for (String group : groups) {
            Configuration configuration = this.getConfiguration(group);
            if (configuration == null) continue;
            jarsAdded.addAll(configuration.getJarNames());
        }
        int numJars = jarsAdded.size();
        jarsAdded.clear();
        if (numJars > 0) {
            String[] jarNames = new String[numJars];
            byte[][] jarBytes = new byte[numJars][];
            int ctr = 0;
            for (String group : groups) {
                Configuration configuration = this.getConfiguration(group);
                if (configuration == null) continue;
                Set<String> jarNameSet = configuration.getJarNames();
                for (String jarName : jarNameSet) {
                    String groupDirPath = FilenameUtils.concat((String)CONFIG_DIR_PATH, (String)group);
                    if (jarsAdded.contains(jarName)) continue;
                    String jarFilePath = FilenameUtils.concat((String)groupDirPath, (String)jarName);
                    jarNames[ctr] = jarName;
                    jarBytes[ctr] = FileUtils.readFileToByteArray((File)new File(jarFilePath));
                    ++ctr;
                }
            }
            jars[0] = jarNames;
            jars[1] = jarBytes;
        }
        return jars;
    }

    public void getAllJarsFromOtherLocators() throws Exception {
        logger.info("Getting Jar files from other locators");
        DM dm = this.cache.getDistributionManager();
        InternalDistributedMember me = this.cache.getMyId();
        HashSet<DistributedMember> locators = new HashSet<DistributedMember>(dm.getAllHostedLocatorsWithSharedConfiguration().keySet());
        locators.remove(me);
        String[] jarNames = null;
        byte[][] jarBytes = null;
        if (locators.isEmpty()) {
            logger.info("No other locators present");
            return;
        }
        ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)getAllJarsFunction, null, locators);
        List results = (List)rc.getResult();
        for (Object result : results) {
            if (result == null || result instanceof Exception) continue;
            Object[] jars = (Object[])result;
            jarNames = (String[])jars[0];
            jarBytes = (byte[][])jars[1];
            break;
        }
        if (jarNames != null && jarBytes != null) {
            HashMap<void, Integer> jarIndex = new HashMap<void, Integer>();
            for (int i = 0; i < jarNames.length; ++i) {
                void jarName = jarNames[i];
                jarIndex.put(jarName, i);
            }
            Map<String, Configuration> entireConfiguration = this.getEntireConfiguration();
            Set<String> groups = entireConfiguration.keySet();
            for (String group : groups) {
                Configuration config = entireConfiguration.get(group);
                Set<String> groupJarNames = config.getJarNames();
                String groupDirPath = FilenameUtils.concat((String)CONFIG_DIR_PATH, (String)group);
                for (String groupJarName : groupJarNames) {
                    Integer index = (Integer)jarIndex.get(groupJarName);
                    if (index != null) {
                        String jarFilePath = FilenameUtils.concat((String)groupDirPath, (String)groupJarName);
                        byte[] jarData = jarBytes[index];
                        try {
                            FileUtils.writeByteArrayToFile((File)new File(jarFilePath), (byte[])jarData);
                        }
                        catch (IOException e) {
                            logger.info(e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    logger.error("JarFile {} not delivered.", new Object[]{groupJarName});
                }
            }
        } else {
            logger.info("No deployed jars found on other locators.");
        }
    }

    public Configuration getConfiguration(String groupName) throws Exception {
        Configuration configuration = this.getConfigurationRegion().get(groupName);
        return configuration;
    }

    private Region<String, Configuration> getConfigurationRegion() throws Exception {
        Region configRegion = this.cache.getRegion(CONFIG_REGION_NAME);
        try {
            if (configRegion == null) {
                File diskDir = new File(this.CONFIG_DISK_DIR_PATH);
                if (!diskDir.exists() && !diskDir.mkdirs()) {
                    throw new IOException("Cannot create directory at " + this.CONFIG_DISK_DIR_PATH);
                }
                File[] diskDirs = new File[]{diskDir};
                this.cache.createDiskStoreFactory().setDiskDirs(diskDirs).setAutoCompact(true).setMaxOplogSize(10L).create("cluster_config");
                AttributesFactory<String, Configuration> regionAttrsFactory = new AttributesFactory<String, Configuration>();
                regionAttrsFactory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                regionAttrsFactory.setCacheListener(new ConfigurationChangeListener(this));
                regionAttrsFactory.setDiskStoreName("cluster_config");
                regionAttrsFactory.setScope(Scope.DISTRIBUTED_ACK);
                InternalRegionArguments internalArgs = new InternalRegionArguments();
                internalArgs.setIsUsedForMetaRegion(true);
                internalArgs.setMetaRegionWithTransactions(false);
                configRegion = this.cache.createVMRegion(CONFIG_REGION_NAME, regionAttrsFactory.create(), internalArgs);
            }
        }
        catch (CancelException e) {
            if (configRegion == null) {
                this.status.set(SharedConfigurationStatus.STOPPED);
            }
            throw e;
        }
        catch (Exception e) {
            if (configRegion == null) {
                this.status.set(SharedConfigurationStatus.STOPPED);
            }
            throw new Exception("Error occurred while initializing cluster configuration", e);
        }
        return configRegion;
    }

    public Map<String, Configuration> getEntireConfiguration() throws Exception {
        Set<String> keys = this.getConfigurationRegion().keySet();
        return this.getConfigurationRegion().getAll(keys);
    }

    public String getSharedConfigurationDirPath() {
        return CONFIG_DIR_PATH;
    }

    public SharedConfigurationStatus getStatus() {
        PersistentMemberManager pmm;
        Map<String, Set<PersistentMemberID>> waitingRegions;
        SharedConfigurationStatus scStatus = this.status.get();
        if (scStatus == SharedConfigurationStatus.STARTED && !(waitingRegions = (pmm = this.cache.getPersistentMemberManager()).getWaitingRegions()).isEmpty()) {
            this.status.compareAndSet(SharedConfigurationStatus.STARTED, SharedConfigurationStatus.WAITING);
            Set<PersistentMemberID> persMemIds = waitingRegions.get("/_ConfigurationRegion");
            for (PersistentMemberID persMemId : persMemIds) {
                this.newerSharedConfigurationLocatorInfo.add(new PersistentMemberPattern(persMemId));
            }
        }
        return this.status.get();
    }

    public void loadSharedConfigurationFromDisk() throws Exception {
        Map<String, Configuration> sharedConfigurationMap = this.readSharedConfigurationFromDisk();
        this.getConfigurationRegion().clear();
        this.getConfigurationRegion().putAll(sharedConfigurationMap);
    }

    public void modifyProperties(Properties properties, String[] groups) throws Exception {
        if (groups == null) {
            groups = new String[]{CLUSTER_CONFIG};
        }
        Region<String, Configuration> configRegion = this.getConfigurationRegion();
        for (String group : groups) {
            Configuration configuration = configRegion.get(group);
            if (configuration == null) {
                configuration = new Configuration(group);
            }
            configuration.getGemfireProperties().putAll((Map<?, ?>)properties);
            configRegion.put(group, configuration);
            this.writeConfig(configuration);
        }
    }

    private Configuration readConfiguration(String configName, String configDirectory) throws SAXException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        Configuration configuration = new Configuration(configName);
        String cacheXmlFullPath = FilenameUtils.concat((String)configDirectory, (String)configuration.getCacheXmlFileName());
        String propertiesFullPath = FilenameUtils.concat((String)configDirectory, (String)configuration.getPropertiesFileName());
        File file = new File(configDirectory);
        String[] jarFileNames = file.list(jarFileFilter);
        if (jarFileNames != null && jarFileNames.length != 0) {
            configuration.addJarNames(jarFileNames);
        }
        try {
            configuration.setCacheXmlContent(XmlUtils.readXmlAsStringFromFile(cacheXmlFullPath));
            configuration.setGemfireProperties(this.readProperties(propertiesFullPath));
        }
        catch (IOException e) {
            logger.info((Object)e);
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties readProperties(String propertiesFilePath) throws IOException {
        Properties properties = new Properties();
        File propsFile = new File(propertiesFilePath);
        FileInputStream fis = null;
        if (propsFile.exists()) {
            try {
                fis = new FileInputStream(propsFile);
                properties.load(fis);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        return properties;
    }

    private Map<String, Configuration> readSharedConfigurationFromDisk() throws SAXException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        String[] subdirectoryNames = SharedConfiguration.getSubdirectories(CONFIG_DIR_PATH);
        HashMap<String, Configuration> sharedConfiguration = new HashMap<String, Configuration>();
        if (subdirectoryNames != null) {
            for (String subdirectoryName : subdirectoryNames) {
                String fullpath = FilenameUtils.concat((String)CONFIG_DIR_PATH, (String)subdirectoryName);
                Configuration configuration = this.readConfiguration(subdirectoryName, fullpath);
                sharedConfiguration.put(subdirectoryName, configuration);
            }
        }
        return sharedConfiguration;
    }

    public void removeJarFiles(String dirPath, String[] jarNames) throws IOException {
        block3: {
            block2: {
                if (jarNames == null) break block2;
                for (int i = 0; i < jarNames.length; ++i) {
                    File jarFile = new File(FilenameUtils.concat((String)dirPath, (String)jarNames[i]));
                    if (!jarFile.exists()) continue;
                    FileUtils.forceDelete((File)jarFile);
                }
                break block3;
            }
            File dir = new File(dirPath);
            String[] jarFileNames = dir.list(jarFileFilter);
            if (jarFileNames.length == 0) break block3;
            for (String jarFileName : jarFileNames) {
                String fullPath = FilenameUtils.concat((String)dirPath, (String)jarFileName);
                File jarFileToBeDeleted = new File(fullPath);
                FileUtils.forceDelete((File)jarFileToBeDeleted);
            }
        }
    }

    public boolean removeJars(String[] jarNames, String[] groups) {
        boolean success = true;
        try {
            Configuration configuration;
            Region<String, Configuration> configRegion = this.getConfigurationRegion();
            if (groups == null) {
                Set<String> groupSet = configRegion.keySet();
                groups = groupSet.toArray(new String[groupSet.size()]);
            }
            for (String group : groups) {
                configuration = configRegion.get(group);
                if (configuration == null) continue;
                String dirPath = FilenameUtils.concat((String)this.getSharedConfigurationDirPath(), (String)configuration.getConfigName());
                this.removeJarFiles(dirPath, jarNames);
            }
            for (String group : groups) {
                configuration = configRegion.get(group);
                if (configuration == null || configuration.getJarNames().isEmpty()) continue;
                configuration.removeJarNames(jarNames);
                configRegion.put(group, configuration);
            }
        }
        catch (Exception e) {
            logger.info("Exception occurred while deleting the jar files", (Throwable)e);
            success = false;
        }
        return success;
    }

    public void renameExistingSharedConfigDirectory() {
        File configDirFile = new File(CONFIG_DIR_PATH);
        if (configDirFile.exists()) {
            String configDirFileName2 = "cluster_config" + new SimpleDateFormat("yyyyMMddhhmm").format(new Date()) + "." + System.nanoTime();
            File configDirFile2 = new File(FilenameUtils.concat((String)configDirFileName2, (String)configDirFileName2));
            try {
                FileUtils.moveDirectoryToDirectory((File)configDirFile, (File)configDirFile2, (boolean)true);
            }
            catch (IOException e) {
                logger.info((Object)e);
            }
        }
    }

    private void writeCacheXml(String dirPath, Configuration configuration) throws IOException {
        String fullPath = FilenameUtils.concat((String)dirPath, (String)configuration.getCacheXmlFileName());
        FileUtils.writeStringToFile((File)new File(fullPath), (String)configuration.getCacheXmlContent(), (String)"UTF-8");
    }

    public void writeConfig(Configuration configuration) throws Exception {
        File configDir = new File(this.getSharedConfigurationDirPath());
        if (!configDir.exists() && !configDir.mkdirs()) {
            throw new IOException("Cannot create directory : " + this.getSharedConfigurationDirPath());
        }
        String dirPath = FilenameUtils.concat((String)this.getSharedConfigurationDirPath(), (String)configuration.getConfigName());
        File file = new File(dirPath);
        if (!file.exists() && !file.mkdir()) {
            throw new IOException("Cannot create directory : " + dirPath);
        }
        this.writeProperties(dirPath, configuration);
        this.writeCacheXml(dirPath, configuration);
    }

    private void writeJarFiles(String dirPath, String[] jarNames, byte[][] jarBytes) {
        for (int i = 0; i < jarNames.length; ++i) {
            String filePath = FilenameUtils.concat((String)dirPath, (String)jarNames[i]);
            File jarFile = new File(filePath);
            try {
                FileUtils.writeByteArrayToFile((File)jarFile, (byte[])jarBytes[i]);
                continue;
            }
            catch (IOException e) {
                logger.info((Object)e);
            }
        }
    }

    private void writeProperties(String dirPath, Configuration configuration) throws IOException {
        String fullPath = FilenameUtils.concat((String)dirPath, (String)configuration.getPropertiesFileName());
        BufferedWriter bw = new BufferedWriter(new FileWriter(fullPath));
        configuration.getGemfireProperties().store(bw, "");
        bw.close();
    }

    static {
        getAllJarsFunction = new GetAllJarsFunction();
        jarFileFilter = new JarFileFilter();
    }

    static class JarFileFilter
    implements FilenameFilter {
        JarFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

