/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.SocketCreator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;

public class ServerLocation
implements DataSerializable,
Comparable {
    private static final long serialVersionUID = -5850116974987640560L;
    private String hostName;
    private int port;
    private long userId = -1L;
    private final AtomicInteger requiresCredentials = new AtomicInteger(0);
    public static final int INITIAL_REQUIRES_CREDENTIALS = 0;
    public static final int REQUIRES_CREDENTIALS = 1;
    public static final int REQUIRES_NO_CREDENTIALS = 2;

    public ServerLocation() {
    }

    public ServerLocation(String hostName, int port) {
        this.hostName = hostName;
        this.port = port;
    }

    public final String getHostName() {
        return this.hostName;
    }

    public final int getPort() {
        return this.port;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.hostName = DataSerializer.readString(in);
        this.port = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.hostName, out);
        out.writeInt(this.port);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerLocation)) {
            return false;
        }
        ServerLocation other = (ServerLocation)obj;
        if (this.hostName == null) {
            if (other.hostName != null) {
                return false;
            }
        } else {
            if (other.hostName == null) {
                return false;
            }
            if (!this.hostName.equals(other.hostName)) {
                String canonicalHostName;
                try {
                    canonicalHostName = SocketCreator.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    throw new IllegalStateException("getLocalHost failed with " + e);
                }
                if ("localhost".equals(this.hostName)) {
                    if (!canonicalHostName.equals(other.hostName)) {
                        return false;
                    }
                } else if ("localhost".equals(other.hostName)) {
                    if (!canonicalHostName.equals(this.hostName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }
        return this.port == other.port;
    }

    public String toString() {
        return this.hostName + ":" + this.port;
    }

    public int compareTo(Object o) {
        ServerLocation other = (ServerLocation)o;
        int difference = this.hostName.compareTo(other.hostName);
        if (difference != 0) {
            return difference;
        }
        return this.port - other.getPort();
    }

    public void setUserId(long id) {
        this.userId = id;
    }

    public long getUserId() {
        return this.userId;
    }

    public void compareAndSetRequiresCredentials(boolean bool) {
        int val = bool ? 1 : 2;
        this.requiresCredentials.compareAndSet(0, val);
    }

    public void setRequiresCredentials(boolean bool) {
        int val = bool ? 1 : 2;
        this.requiresCredentials.set(val);
    }

    public boolean getRequiresCredentials() {
        return this.requiresCredentials.get() == 1;
    }
}

