/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionConfigImpl;
import com.gemstone.gemfire.distributed.internal.DistributionConfigSnapshot;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.ConfigSource;
import com.gemstone.gemfire.internal.logging.log4j.LogWriterAppenders;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public final class RuntimeDistributionConfigImpl
extends DistributionConfigImpl {
    private static final long serialVersionUID = -805637520096606113L;
    private final transient InternalDistributedSystem ds;

    public RuntimeDistributionConfigImpl(InternalDistributedSystem ds) {
        super(ds.getOriginalConfig());
        this.ds = ds;
        this.modifiable = false;
    }

    @Override
    public void setLogLevel(int value) {
        this.logLevel = (Integer)this.checkAttribute("log-level", value);
        this.getAttSourceMap().put("log-level", ConfigSource.runtime());
        this.ds.getInternalLogWriter().setLogWriterLevel(value);
        LogWriterAppenders.configChanged(LogWriterAppenders.Identifier.MAIN);
    }

    @Override
    public void setStatisticSamplingEnabled(boolean value) {
        this.statisticSamplingEnabled = (Boolean)this.checkAttribute("statistic-sampling-enabled", value);
        this.getAttSourceMap().put("statistic-sampling-enabled", ConfigSource.runtime());
    }

    @Override
    public void setStatisticSampleRate(int value) {
        if ((value = ((Integer)this.checkAttribute("statistic-sample-rate", value)).intValue()) < 1000) {
            this.ds.getLogWriter().info("Setting statistic-sample-rate to 1000 instead of the requested " + value + " because VSD does not work with sub-second sampling.");
            value = 1000;
        }
        this.statisticSampleRate = value;
    }

    @Override
    public void setStatisticArchiveFile(File value) {
        if ((value = (File)this.checkAttribute("statistic-archive-file", value)) == null) {
            value = new File("");
        }
        try {
            this.ds.getStatSampler().changeArchive(value);
        }
        catch (GemFireIOException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        this.statisticArchiveFile = value;
        this.getAttSourceMap().put("statistic-archive-file", ConfigSource.runtime());
    }

    @Override
    public void setArchiveDiskSpaceLimit(int value) {
        this.archiveDiskSpaceLimit = (Integer)this.checkAttribute("archive-disk-space-limit", value);
        this.getAttSourceMap().put("archive-disk-space-limit", ConfigSource.runtime());
    }

    @Override
    public void setArchiveFileSizeLimit(int value) {
        this.archiveFileSizeLimit = (Integer)this.checkAttribute("archive-file-size-limit", value);
        this.getAttSourceMap().put("archive-file-size-limit", ConfigSource.runtime());
    }

    @Override
    public void setLogDiskSpaceLimit(int value) {
        this.logDiskSpaceLimit = (Integer)this.checkAttribute("log-disk-space-limit", value);
        this.getAttSourceMap().put("log-disk-space-limit", ConfigSource.runtime());
        LogWriterAppenders.configChanged(LogWriterAppenders.Identifier.MAIN);
    }

    @Override
    public void setLogFileSizeLimit(int value) {
        this.logFileSizeLimit = (Integer)this.checkAttribute("log-file-size-limit", value);
        this.getAttSourceMap().put("log-file-size-limit", ConfigSource.runtime());
        LogWriterAppenders.configChanged(LogWriterAppenders.Identifier.MAIN);
    }

    public DistributionConfig takeSnapshot() {
        return new DistributionConfigSnapshot(this);
    }

    @Override
    public List<String> getModifiableAttributes() {
        String[] modifiables = new String[]{"http-service-port", "jmx-manager-http-port", "archive-disk-space-limit", "archive-file-size-limit", "log-disk-space-limit", "log-file-size-limit", "log-level", "statistic-archive-file", "statistic-sample-rate", "statistic-sampling-enabled"};
        return Arrays.asList(modifiables);
    }
}

