/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.MembershipManager;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.PureLogWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;

public final class ProductUseLog
implements MembershipListener {
    protected static long MAX_PRODUCT_USE_FILE_SIZE = Long.getLong("max_view_log_size", 5000000L);
    private final int logLevel;
    private final File productUseLogFile;
    private PureLogWriter logWriter;
    private InternalDistributedSystem system;

    public ProductUseLog(File productUseLogFile) {
        this.productUseLogFile = productUseLogFile;
        this.logLevel = 800;
        this.createLogWriter();
    }

    public void monitorUse(InternalDistributedSystem system) {
        this.system = system;
        DM dmgr = system.getDistributionManager();
        dmgr.addMembershipListener(this);
        MembershipManager mmgr = dmgr.getMembershipManager();
        if (mmgr != null) {
            this.log("Log opened with new distributed system connection.  " + system.getDM().getMembershipManager().getView());
        } else {
            this.log("Log opened with new distributed system connection.  Membership view not yet available in this VM.");
        }
    }

    public synchronized void log(String logMessage) {
        if (!this.logWriter.isClosed()) {
            if (this.productUseLogFile.length() + (long)logMessage.length() + 100L > MAX_PRODUCT_USE_FILE_SIZE) {
                this.clearLog();
            }
            this.logWriter.info(logMessage);
        }
    }

    public synchronized void close() {
        if (!this.logWriter.isClosed()) {
            this.logWriter.close();
        }
    }

    public synchronized boolean isClosed() {
        return this.logWriter.isClosed();
    }

    public synchronized void reopen() {
        if (this.logWriter.isClosed()) {
            this.createLogWriter();
        }
    }

    private synchronized void clearLog() {
        this.logWriter.close();
        this.productUseLogFile.delete();
        this.createLogWriter();
    }

    private synchronized void createLogWriter() {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(this.productUseLogFile, true);
        }
        catch (FileNotFoundException ex) {
            String s = LocalizedStrings.InternalDistributedSystem_COULD_NOT_OPEN_LOG_FILE_0.toLocalizedString(this.productUseLogFile);
            throw new GemFireIOException(s, ex);
        }
        PrintStream out = new PrintStream(fos);
        this.logWriter = new PureLogWriter(this.logLevel, out);
    }

    @Override
    public void memberJoined(InternalDistributedMember id) {
        this.log("A new member joined: " + id + ".  " + this.system.getDM().getMembershipManager().getView());
    }

    @Override
    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
    }

    @Override
    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
    }

    @Override
    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    static {
        if (MAX_PRODUCT_USE_FILE_SIZE < 1000000L) {
            MAX_PRODUCT_USE_FILE_SIZE = 1000000L;
        }
    }
}

