/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.distributed.internal.AbstractDistributionConfig;
import com.gemstone.gemfire.distributed.internal.ConfigAttribute;
import com.gemstone.gemfire.distributed.internal.ConfigAttributeGetter;
import com.gemstone.gemfire.distributed.internal.ConfigAttributeSetter;
import com.gemstone.gemfire.distributed.internal.FlowControlParams;
import com.gemstone.gemfire.internal.Config;
import com.gemstone.gemfire.internal.ConfigSource;
import com.gemstone.gemfire.internal.logging.LogConfig;
import com.gemstone.gemfire.memcached.GemFireMemcachedServer;
import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public interface DistributionConfig
extends Config,
LogConfig {
    @ConfigAttribute(type=String.class)
    public static final String NAME_NAME = "name";
    public static final String DEFAULT_NAME = "";
    public static final int DEFAULT_MCAST_PORT = 0;
    public static final int MIN_MCAST_PORT = 0;
    public static final int MAX_MCAST_PORT = 65535;
    @ConfigAttribute(type=Integer.class, min=0, max=65535)
    public static final String MCAST_PORT_NAME = "mcast-port";
    public static final int DEFAULT_TCP_PORT = 0;
    public static final int MIN_TCP_PORT = 0;
    public static final int MAX_TCP_PORT = 65535;
    @ConfigAttribute(type=Integer.class, min=0, max=65535)
    public static final String TCP_PORT_NAME = "tcp-port";
    @ConfigAttribute(type=InetAddress.class)
    public static final String MCAST_ADDRESS_NAME = "mcast-address";
    public static final InetAddress DEFAULT_MCAST_ADDRESS = AbstractDistributionConfig._getDefaultMcastAddress();
    public static final int DEFAULT_MCAST_TTL = 32;
    public static final int MIN_MCAST_TTL = 0;
    public static final int MAX_MCAST_TTL = 255;
    @ConfigAttribute(type=Integer.class, min=0, max=255)
    public static final String MCAST_TTL_NAME = "mcast-ttl";
    @ConfigAttribute(type=String.class)
    public static final String BIND_ADDRESS_NAME = "bind-address";
    public static final String DEFAULT_BIND_ADDRESS = "";
    @ConfigAttribute(type=String.class)
    public static final String SERVER_BIND_ADDRESS_NAME = "server-bind-address";
    public static final String DEFAULT_SERVER_BIND_ADDRESS = "";
    @ConfigAttribute(type=String.class)
    public static final String LOCATORS_NAME = "locators";
    public static final String DEFAULT_LOCATORS = "";
    @ConfigAttribute(type=Integer.class)
    public static final String LOCATOR_WAIT_TIME_NAME = "locator-wait-time";
    public static final int DEFAULT_LOCATOR_WAIT_TIME = 0;
    @ConfigAttribute(type=String.class)
    public static final String START_LOCATOR_NAME = "start-locator";
    public static final String DEFAULT_START_LOCATOR = "";
    @ConfigAttribute(type=File.class)
    public static final String DEPLOY_WORKING_DIR = "deploy-working-dir";
    public static final File DEFAULT_DEPLOY_WORKING_DIR = new File(".");
    @ConfigAttribute(type=String.class)
    public static final String USER_COMMAND_PACKAGES = "user-command-packages";
    public static final String DEFAULT_USER_COMMAND_PACKAGES = "";
    @ConfigAttribute(type=File.class)
    public static final String LOG_FILE_NAME = "log-file";
    public static final File DEFAULT_LOG_FILE = new File("");
    public static final int DEFAULT_LOG_LEVEL = 700;
    public static final int MIN_LOG_LEVEL = Integer.MIN_VALUE;
    public static final int MAX_LOG_LEVEL = Integer.MAX_VALUE;
    @ConfigAttribute(type=String.class)
    public static final String LOG_LEVEL_NAME = "log-level";
    @ConfigAttribute(type=Boolean.class)
    public static final String STATISTIC_SAMPLING_ENABLED_NAME = "statistic-sampling-enabled";
    public static final boolean DEFAULT_STATISTIC_SAMPLING_ENABLED = true;
    public static final int DEFAULT_STATISTIC_SAMPLE_RATE = 1000;
    public static final int MIN_STATISTIC_SAMPLE_RATE = 100;
    public static final int MAX_STATISTIC_SAMPLE_RATE = 60000;
    @ConfigAttribute(type=Integer.class, min=100, max=60000)
    public static final String STATISTIC_SAMPLE_RATE_NAME = "statistic-sample-rate";
    @ConfigAttribute(type=File.class)
    public static final String STATISTIC_ARCHIVE_FILE_NAME = "statistic-archive-file";
    public static final File DEFAULT_STATISTIC_ARCHIVE_FILE = new File("");
    @ConfigAttribute(type=File.class)
    public static final String CACHE_XML_FILE_NAME = "cache-xml-file";
    public static final File DEFAULT_CACHE_XML_FILE = new File("cache.xml");
    public static final int DEFAULT_ACK_WAIT_THRESHOLD = 15;
    public static final int MIN_ACK_WAIT_THRESHOLD = 1;
    public static final int MAX_ACK_WAIT_THRESHOLD = Integer.MAX_VALUE;
    @ConfigAttribute(type=Integer.class, min=1)
    public static final String ACK_WAIT_THRESHOLD_NAME = "ack-wait-threshold";
    public static final int DEFAULT_ACK_SEVERE_ALERT_THRESHOLD = 0;
    public static final int MIN_ACK_SEVERE_ALERT_THRESHOLD = 0;
    public static final int MAX_ACK_SEVERE_ALERT_THRESHOLD = Integer.MAX_VALUE;
    @ConfigAttribute(type=Integer.class, min=0)
    public static final String ACK_SEVERE_ALERT_THRESHOLD_NAME = "ack-severe-alert-threshold";
    public static final int DEFAULT_ARCHIVE_FILE_SIZE_LIMIT = 0;
    public static final int MIN_ARCHIVE_FILE_SIZE_LIMIT = 0;
    public static final int MAX_ARCHIVE_FILE_SIZE_LIMIT = 1000000;
    @ConfigAttribute(type=Integer.class, min=0, max=1000000)
    public static final String ARCHIVE_FILE_SIZE_LIMIT_NAME = "archive-file-size-limit";
    public static final int DEFAULT_ARCHIVE_DISK_SPACE_LIMIT = 0;
    public static final int MIN_ARCHIVE_DISK_SPACE_LIMIT = 0;
    public static final int MAX_ARCHIVE_DISK_SPACE_LIMIT = 1000000;
    @ConfigAttribute(type=Integer.class, min=0, max=1000000)
    public static final String ARCHIVE_DISK_SPACE_LIMIT_NAME = "archive-disk-space-limit";
    public static final int DEFAULT_LOG_FILE_SIZE_LIMIT = 0;
    public static final int MIN_LOG_FILE_SIZE_LIMIT = 0;
    public static final int MAX_LOG_FILE_SIZE_LIMIT = 1000000;
    @ConfigAttribute(type=Integer.class, min=0, max=1000000)
    public static final String LOG_FILE_SIZE_LIMIT_NAME = "log-file-size-limit";
    public static final int DEFAULT_LOG_DISK_SPACE_LIMIT = 0;
    public static final int MIN_LOG_DISK_SPACE_LIMIT = 0;
    public static final int MAX_LOG_DISK_SPACE_LIMIT = 1000000;
    @ConfigAttribute(type=Integer.class, min=0, max=1000000)
    public static final String LOG_DISK_SPACE_LIMIT_NAME = "log-disk-space-limit";
    public static final boolean DEFAULT_SSL_ENABLED = false;
    @ConfigAttribute(type=Boolean.class)
    public static final String SSL_ENABLED_NAME = "ssl-enabled";
    public static final String DEFAULT_SSL_PROTOCOLS = "any";
    @ConfigAttribute(type=String.class)
    public static final String SSL_PROTOCOLS_NAME = "ssl-protocols";
    public static final String DEFAULT_SSL_CIPHERS = "any";
    @ConfigAttribute(type=String.class)
    public static final String SSL_CIPHERS_NAME = "ssl-ciphers";
    public static final boolean DEFAULT_SSL_REQUIRE_AUTHENTICATION = true;
    @ConfigAttribute(type=Boolean.class)
    public static final String SSL_REQUIRE_AUTHENTICATION_NAME = "ssl-require-authentication";
    public static final boolean DEFAULT_CLUSTER_SSL_ENABLED = false;
    @ConfigAttribute(type=Boolean.class)
    public static final String CLUSTER_SSL_ENABLED_NAME = "cluster-ssl-enabled";
    public static final String DEFAULT_CLUSTER_SSL_PROTOCOLS = "any";
    @ConfigAttribute(type=String.class)
    public static final String CLUSTER_SSL_PROTOCOLS_NAME = "cluster-ssl-protocols";
    public static final String DEFAULT_CLUSTER_SSL_CIPHERS = "any";
    @ConfigAttribute(type=String.class)
    public static final String CLUSTER_SSL_CIPHERS_NAME = "cluster-ssl-ciphers";
    public static final boolean DEFAULT_CLUSTER_SSL_REQUIRE_AUTHENTICATION = true;
    @ConfigAttribute(type=Boolean.class)
    public static final String CLUSTER_SSL_REQUIRE_AUTHENTICATION_NAME = "cluster-ssl-require-authentication";
    public static final String DEFAULT_CLUSTER_SSL_KEYSTORE = "";
    @ConfigAttribute(type=String.class)
    public static final String CLUSTER_SSL_KEYSTORE_NAME = "cluster-ssl-keystore";
    public static final String DEFAULT_CLUSTER_SSL_KEYSTORE_TYPE = "";
    @ConfigAttribute(type=String.class)
    public static final String CLUSTER_SSL_KEYSTORE_TYPE_NAME = "cluster-ssl-keystore-type";
    public static final String DEFAULT_CLUSTER_SSL_KEYSTORE_PASSWORD = "";
    @ConfigAttribute(type=String.class)
    public static final String CLUSTER_SSL_KEYSTORE_PASSWORD_NAME = "cluster-ssl-keystore-password";
    public static final String DEFAULT_CLUSTER_SSL_TRUSTSTORE = "";
    @ConfigAttribute(type=String.class)
    public static final String CLUSTER_SSL_TRUSTSTORE_NAME = "cluster-ssl-truststore";
    public static final String DEFAULT_CLUSTER_SSL_TRUSTSTORE_PASSWORD = "";
    @ConfigAttribute(type=String.class)
    public static final String CLUSTER_SSL_TRUSTSTORE_PASSWORD_NAME = "cluster-ssl-truststore-password";
    public static final String LOG_WRITER_NAME = "log-writer";
    public static final String DS_CONFIG_NAME = "ds-config";
    public static final String DS_RECONNECTING_NAME = "ds-reconnecting";
    public static final String DS_QUORUM_CHECKER_NAME = "ds-quorum-checker";
    public static final String SECURITY_LOG_WRITER_NAME = "security-log-writer";
    public static final String LOG_OUTPUTSTREAM_NAME = "log-output-stream";
    public static final String SECURITY_LOG_OUTPUTSTREAM_NAME = "security-log-output-stream";
    public static final int DEFAULT_SOCKET_LEASE_TIME = 60000;
    public static final int MIN_SOCKET_LEASE_TIME = 0;
    public static final int MAX_SOCKET_LEASE_TIME = 600000;
    @ConfigAttribute(type=Integer.class, min=0, max=600000)
    public static final String SOCKET_LEASE_TIME_NAME = "socket-lease-time";
    public static final int DEFAULT_SOCKET_BUFFER_SIZE = 32768;
    public static final int MIN_SOCKET_BUFFER_SIZE = 1024;
    public static final int MAX_SOCKET_BUFFER_SIZE = 0xFFFFFF;
    public static final boolean VALIDATE = Boolean.getBoolean("gemfire.validateMessageSize");
    public static final int VALIDATE_CEILING = Integer.getInteger("gemfire.validateMessageSizeCeiling", 0x800000);
    @ConfigAttribute(type=Integer.class, min=1024, max=0xFFFFFF)
    public static final String SOCKET_BUFFER_SIZE_NAME = "socket-buffer-size";
    public static final int DEFAULT_MCAST_SEND_BUFFER_SIZE = 65535;
    public static final int MIN_MCAST_SEND_BUFFER_SIZE = 2048;
    @ConfigAttribute(type=Integer.class, min=2048)
    public static final String MCAST_SEND_BUFFER_SIZE_NAME = "mcast-send-buffer-size";
    public static final int DEFAULT_MCAST_RECV_BUFFER_SIZE = 0x100000;
    public static final int MIN_MCAST_RECV_BUFFER_SIZE = 2048;
    @ConfigAttribute(type=Integer.class, min=2048)
    public static final String MCAST_RECV_BUFFER_SIZE_NAME = "mcast-recv-buffer-size";
    @ConfigAttribute(type=FlowControlParams.class)
    public static final String MCAST_FLOW_CONTROL_NAME = "mcast-flow-control";
    public static final FlowControlParams DEFAULT_MCAST_FLOW_CONTROL = new FlowControlParams(0x100000, 0.25f, 5000);
    public static final int MIN_FC_BYTE_ALLOWANCE = 10000;
    public static final float MIN_FC_RECHARGE_THRESHOLD = 0.1f;
    public static final float MAX_FC_RECHARGE_THRESHOLD = 0.5f;
    public static final int MIN_FC_RECHARGE_BLOCK_MS = 500;
    public static final int MAX_FC_RECHARGE_BLOCK_MS = 60000;
    public static final int DEFAULT_UDP_FRAGMENT_SIZE = 60000;
    public static final int MIN_UDP_FRAGMENT_SIZE = 1000;
    public static final int MAX_UDP_FRAGMENT_SIZE = 60000;
    @ConfigAttribute(type=Integer.class, min=1000, max=60000)
    public static final String UDP_FRAGMENT_SIZE_NAME = "udp-fragment-size";
    public static final int DEFAULT_UDP_SEND_BUFFER_SIZE = 65535;
    public static final int MIN_UDP_SEND_BUFFER_SIZE = 2048;
    @ConfigAttribute(type=Integer.class, min=2048)
    public static final String UDP_SEND_BUFFER_SIZE_NAME = "udp-send-buffer-size";
    public static final int DEFAULT_UDP_RECV_BUFFER_SIZE = 0x100000;
    public static final int DEFAULT_UDP_RECV_BUFFER_SIZE_REDUCED = 65535;
    public static final int MIN_UDP_RECV_BUFFER_SIZE = 2048;
    @ConfigAttribute(type=Integer.class, min=2048)
    public static final String UDP_RECV_BUFFER_SIZE_NAME = "udp-recv-buffer-size";
    @ConfigAttribute(type=Boolean.class)
    public static final String DISABLE_TCP_NAME = "disable-tcp";
    public static final boolean DEFAULT_DISABLE_TCP = false;
    @ConfigAttribute(type=Boolean.class)
    public static final String ENABLE_TIME_STATISTICS_NAME = "enable-time-statistics";
    public static final boolean DEFAULT_ENABLE_TIME_STATISTICS = false;
    @ConfigAttribute(type=Boolean.class)
    public static final String USE_CLUSTER_CONFIGURATION_NAME = "use-cluster-configuration";
    public static final boolean DEFAULT_USE_CLUSTER_CONFIGURATION = true;
    @ConfigAttribute(type=Boolean.class)
    public static final String ENABLE_CLUSTER_CONFIGURATION_NAME = "enable-cluster-configuration";
    public static final boolean DEFAULT_ENABLE_CLUSTER_CONFIGURATION = true;
    @ConfigAttribute(type=Boolean.class)
    public static final String LOAD_CLUSTER_CONFIG_FROM_DIR_NAME = "load-cluster-configuration-from-dir";
    public static final boolean DEFAULT_LOAD_CLUSTER_CONFIG_FROM_DIR = false;
    @ConfigAttribute(type=String.class)
    public static final String CLUSTER_CONFIGURATION_DIR = "cluster-configuration-dir";
    public static final String DEFAULT_CLUSTER_CONFIGURATION_DIR = System.getProperty("user.dir");
    @ConfigAttribute(type=Boolean.class)
    public static final String ENABLE_NETWORK_PARTITION_DETECTION_NAME = "enable-network-partition-detection";
    public static final boolean DEFAULT_ENABLE_NETWORK_PARTITION_DETECTION = false;
    public static final int DEFAULT_MEMBER_TIMEOUT = 5000;
    public static final int MIN_MEMBER_TIMEOUT = 10;
    public static final int MAX_MEMBER_TIMEOUT = 600000;
    @ConfigAttribute(type=Integer.class, min=10, max=600000)
    public static final String MEMBER_TIMEOUT_NAME = "member-timeout";
    @ConfigAttribute(type=int[].class)
    public static final String MEMBERSHIP_PORT_RANGE_NAME = "membership-port-range";
    public static final int[] DEFAULT_MEMBERSHIP_PORT_RANGE = new int[]{1024, 65535};
    @ConfigAttribute(type=Boolean.class)
    public static final String CONSERVE_SOCKETS_NAME = "conserve-sockets";
    public static final boolean DEFAULT_CONSERVE_SOCKETS = true;
    @ConfigAttribute(type=String.class)
    public static final String ROLES_NAME = "roles";
    public static final String DEFAULT_ROLES = "";
    @ConfigAttribute(type=Integer.class)
    public static final String MAX_WAIT_TIME_FOR_RECONNECT_NAME = "max-wait-time-reconnect";
    public static final int DEFAULT_MAX_WAIT_TIME_FOR_RECONNECT = 60000;
    @ConfigAttribute(type=Integer.class)
    public static final String MAX_NUM_RECONNECT_TRIES = "max-num-reconnect-tries";
    public static final int DEFAULT_MAX_NUM_RECONNECT_TRIES = 3;
    public static final int DEFAULT_ASYNC_DISTRIBUTION_TIMEOUT = 0;
    public static final int MIN_ASYNC_DISTRIBUTION_TIMEOUT = 0;
    public static final int MAX_ASYNC_DISTRIBUTION_TIMEOUT = 60000;
    @ConfigAttribute(type=Integer.class, min=0, max=60000)
    public static final String ASYNC_DISTRIBUTION_TIMEOUT_NAME = "async-distribution-timeout";
    public static final int DEFAULT_ASYNC_QUEUE_TIMEOUT = 60000;
    public static final int MIN_ASYNC_QUEUE_TIMEOUT = 0;
    public static final int MAX_ASYNC_QUEUE_TIMEOUT = 86400000;
    @ConfigAttribute(type=Integer.class, min=0, max=86400000)
    public static final String ASYNC_QUEUE_TIMEOUT_NAME = "async-queue-timeout";
    public static final int DEFAULT_ASYNC_MAX_QUEUE_SIZE = 8;
    public static final int MIN_ASYNC_MAX_QUEUE_SIZE = 0;
    public static final int MAX_ASYNC_MAX_QUEUE_SIZE = 1024;
    @ConfigAttribute(type=Integer.class, min=0, max=1024)
    public static final String ASYNC_MAX_QUEUE_SIZE_NAME = "async-max-queue-size";
    @ConfigAttribute(type=String.class)
    public static final String CLIENT_CONFLATION_PROP_NAME = "conflate-events";
    public static final String CLIENT_CONFLATION_PROP_VALUE_DEFAULT = "server";
    public static final String CLIENT_CONFLATION_PROP_VALUE_ON = "true";
    public static final String CLIENT_CONFLATION_PROP_VALUE_OFF = "false";
    @ConfigAttribute(type=Boolean.class)
    public static final String DISTRIBUTED_TRANSACTIONS_NAME = "distributed-transactions";
    public static final boolean DEFAULT_DISTRIBUTED_TRANSACTIONS = false;
    @ConfigAttribute(type=String.class)
    public static final String DURABLE_CLIENT_ID_NAME = "durable-client-id";
    public static final String DEFAULT_DURABLE_CLIENT_ID = "";
    @ConfigAttribute(type=Integer.class)
    public static final String DURABLE_CLIENT_TIMEOUT_NAME = "durable-client-timeout";
    public static final int DEFAULT_DURABLE_CLIENT_TIMEOUT = 300;
    @ConfigAttribute(type=String.class)
    public static final String SECURITY_CLIENT_AUTH_INIT_NAME = "security-client-auth-init";
    public static final String DEFAULT_SECURITY_CLIENT_AUTH_INIT = "";
    @ConfigAttribute(type=String.class)
    public static final String SECURITY_CLIENT_AUTHENTICATOR_NAME = "security-client-authenticator";
    public static final String DEFAULT_SECURITY_CLIENT_AUTHENTICATOR = "";
    @ConfigAttribute(type=String.class)
    public static final String SECURITY_CLIENT_DHALGO_NAME = "security-client-dhalgo";
    public static final String DEFAULT_SECURITY_CLIENT_DHALGO = "";
    @ConfigAttribute(type=String.class)
    public static final String SECURITY_PEER_AUTH_INIT_NAME = "security-peer-auth-init";
    public static final String DEFAULT_SECURITY_PEER_AUTH_INIT = "";
    @ConfigAttribute(type=String.class)
    public static final String SECURITY_PEER_AUTHENTICATOR_NAME = "security-peer-authenticator";
    public static final String DEFAULT_SECURITY_PEER_AUTHENTICATOR = "";
    @ConfigAttribute(type=String.class)
    public static final String SECURITY_CLIENT_ACCESSOR_NAME = "security-client-accessor";
    public static final String DEFAULT_SECURITY_CLIENT_ACCESSOR = "";
    @ConfigAttribute(type=String.class)
    public static final String SECURITY_CLIENT_ACCESSOR_PP_NAME = "security-client-accessor-pp";
    public static final String DEFAULT_SECURITY_CLIENT_ACCESSOR_PP = "";
    @ConfigAttribute(type=String.class)
    public static final String SECURITY_LOG_LEVEL_NAME = "security-log-level";
    @ConfigAttribute(type=File.class)
    public static final String SECURITY_LOG_FILE_NAME = "security-log-file";
    public static final File DEFAULT_SECURITY_LOG_FILE = new File("");
    public static final int DEFAULT_SECURITY_PEER_VERIFYMEMBER_TIMEOUT = 1000;
    public static final int MAX_SECURITY_PEER_VERIFYMEMBER_TIMEOUT = 60000;
    @ConfigAttribute(type=Integer.class, min=0, max=60000)
    public static final String SECURITY_PEER_VERIFYMEMBER_TIMEOUT_NAME = "security-peer-verifymember-timeout";
    public static final String SECURITY_PREFIX_NAME = "security-";
    public static final String GEMFIRE_PREFIX = "gemfire.";
    public static final String USERDEFINED_PREFIX_NAME = "custom-";
    public static final String SSL_SYSTEM_PROPS_NAME = "javax.net.ssl";
    public static final String KEY_STORE_TYPE_NAME = ".keyStoreType";
    public static final String KEY_STORE_NAME = ".keyStore";
    public static final String KEY_STORE_PASSWORD_NAME = ".keyStorePassword";
    public static final String TRUST_STORE_NAME = ".trustStore";
    public static final String TRUST_STORE_PASSWORD_NAME = ".trustStorePassword";
    public static final String JMX_SSL_PROPS_SUFFIX = "-jmx";
    public static final String SYS_PROP_NAME = "sysprop-";
    @ConfigAttribute(type=Boolean.class)
    public static final String REMOVE_UNRESPONSIVE_CLIENT_PROP_NAME = "remove-unresponsive-client";
    public static final boolean DEFAULT_REMOVE_UNRESPONSIVE_CLIENT = false;
    @ConfigAttribute(type=Boolean.class)
    public static final String DELTA_PROPAGATION_PROP_NAME = "delta-propagation";
    public static final boolean DEFAULT_DELTA_PROPAGATION = true;
    public static final int MIN_DISTRIBUTED_SYSTEM_ID = -1;
    public static final int MAX_DISTRIBUTED_SYSTEM_ID = 255;
    @ConfigAttribute(type=Integer.class)
    public static final String DISTRIBUTED_SYSTEM_ID_NAME = "distributed-system-id";
    public static final int DEFAULT_DISTRIBUTED_SYSTEM_ID = -1;
    @ConfigAttribute(type=String.class)
    public static final String REDUNDANCY_ZONE_NAME = "redundancy-zone";
    public static final String DEFAULT_REDUNDANCY_ZONE = "";
    @ConfigAttribute(type=Boolean.class)
    public static final String ENFORCE_UNIQUE_HOST_NAME = "enforce-unique-host";
    public static final boolean DEFAULT_ENFORCE_UNIQUE_HOST = Boolean.getBoolean("gemfire.EnforceUniqueHostStorageAllocation");
    @ConfigAttribute(type=String.class)
    public static final String GROUPS_NAME = "groups";
    public static final String DEFAULT_GROUPS = "";
    @ConfigAttribute(type=String.class)
    public static final String REMOTE_LOCATORS_NAME = "remote-locators";
    public static final String DEFAULT_REMOTE_LOCATORS = "";
    @ConfigAttribute(type=Boolean.class)
    public static final String JMX_MANAGER_NAME = "jmx-manager";
    public static final boolean DEFAULT_JMX_MANAGER = false;
    @ConfigAttribute(type=Boolean.class)
    public static final String JMX_MANAGER_START_NAME = "jmx-manager-start";
    public static final boolean DEFAULT_JMX_MANAGER_START = false;
    @ConfigAttribute(type=Integer.class, min=0, max=65535)
    public static final String JMX_MANAGER_PORT_NAME = "jmx-manager-port";
    public static final int DEFAULT_JMX_MANAGER_PORT = 1099;
    @ConfigAttribute(type=Boolean.class)
    public static final String JMX_MANAGER_SSL_NAME = "jmx-manager-ssl";
    public static final boolean DEFAULT_JMX_MANAGER_SSL = false;
    public static final boolean DEFAULT_JMX_MANAGER_SSL_ENABLED = false;
    @ConfigAttribute(type=Boolean.class)
    public static final String JMX_MANAGER_SSL_ENABLED_NAME = "jmx-manager-ssl-enabled";
    @ConfigAttribute(type=String.class)
    public static final String OFF_HEAP_MEMORY_SIZE_NAME = "off-heap-memory-size";
    public static final String DEFAULT_OFF_HEAP_MEMORY_SIZE = "";
    public static final String DEFAULT_JMX_MANAGER_SSL_PROTOCOLS = "any";
    @ConfigAttribute(type=String.class)
    public static final String JMX_MANAGER_SSL_PROTOCOLS_NAME = "jmx-manager-ssl-protocols";
    public static final String DEFAULT_JMX_MANAGER_SSL_CIPHERS = "any";
    @ConfigAttribute(type=String.class)
    public static final String JMX_MANAGER_SSL_CIPHERS_NAME = "jmx-manager-ssl-ciphers";
    public static final boolean DEFAULT_JMX_MANAGER_SSL_REQUIRE_AUTHENTICATION = true;
    @ConfigAttribute(type=Boolean.class)
    public static final String JMX_MANAGER_SSL_REQUIRE_AUTHENTICATION_NAME = "jmx-manager-ssl-require-authentication";
    public static final String DEFAULT_JMX_MANAGER_SSL_KEYSTORE = "";
    @ConfigAttribute(type=String.class)
    public static final String JMX_MANAGER_SSL_KEYSTORE_NAME = "jmx-manager-ssl-keystore";
    public static final String DEFAULT_JMX_MANAGER_SSL_KEYSTORE_TYPE = "";
    @ConfigAttribute(type=String.class)
    public static final String JMX_MANAGER_SSL_KEYSTORE_TYPE_NAME = "jmx-manager-ssl-keystore-type";
    public static final String DEFAULT_JMX_MANAGER_SSL_KEYSTORE_PASSWORD = "";
    @ConfigAttribute(type=String.class)
    public static final String JMX_MANAGER_SSL_KEYSTORE_PASSWORD_NAME = "jmx-manager-ssl-keystore-password";
    public static final String DEFAULT_JMX_MANAGER_SSL_TRUSTSTORE = "";
    @ConfigAttribute(type=String.class)
    public static final String JMX_MANAGER_SSL_TRUSTSTORE_NAME = "jmx-manager-ssl-truststore";
    public static final String DEFAULT_JMX_MANAGER_SSL_TRUSTSTORE_PASSWORD = "";
    @ConfigAttribute(type=String.class)
    public static final String JMX_MANAGER_SSL_TRUSTSTORE_PASSWORD_NAME = "jmx-manager-ssl-truststore-password";
    @ConfigAttribute(type=String.class)
    public static final String JMX_MANAGER_BIND_ADDRESS_NAME = "jmx-manager-bind-address";
    public static final String DEFAULT_JMX_MANAGER_BIND_ADDRESS = "";
    @ConfigAttribute(type=String.class)
    public static final String JMX_MANAGER_HOSTNAME_FOR_CLIENTS_NAME = "jmx-manager-hostname-for-clients";
    public static final String DEFAULT_JMX_MANAGER_HOSTNAME_FOR_CLIENTS = "";
    @ConfigAttribute(type=String.class)
    public static final String JMX_MANAGER_PASSWORD_FILE_NAME = "jmx-manager-password-file";
    public static final String DEFAULT_JMX_MANAGER_PASSWORD_FILE = "";
    @ConfigAttribute(type=String.class)
    public static final String JMX_MANAGER_ACCESS_FILE_NAME = "jmx-manager-access-file";
    public static final String DEFAULT_JMX_MANAGER_ACCESS_FILE = "";
    @ConfigAttribute(type=Integer.class, min=0, max=65535)
    public static final String JMX_MANAGER_HTTP_PORT_NAME = "jmx-manager-http-port";
    public static final int DEFAULT_JMX_MANAGER_HTTP_PORT = 7070;
    public static final int DEFAULT_JMX_MANAGER_UPDATE_RATE = 2000;
    public static final int MIN_JMX_MANAGER_UPDATE_RATE = 1000;
    public static final int MAX_JMX_MANAGER_UPDATE_RATE = 300000;
    @ConfigAttribute(type=Integer.class, min=1000, max=300000)
    public static final String JMX_MANAGER_UPDATE_RATE_NAME = "jmx-manager-update-rate";
    @ConfigAttribute(type=Integer.class, min=0, max=65535)
    public static final String MEMCACHED_PORT_NAME = "memcached-port";
    public static final int DEFAULT_MEMCACHED_PORT = 0;
    @ConfigAttribute(type=String.class)
    public static final String MEMCACHED_PROTOCOL_NAME = "memcached-protocol";
    public static final String DEFAULT_MEMCACHED_PROTOCOL = GemFireMemcachedServer.Protocol.ASCII.name();
    @ConfigAttribute(type=String.class)
    public static final String MEMCACHED_BIND_ADDRESS_NAME = "memcached-bind-address";
    public static final String DEFAULT_MEMCACHED_BIND_ADDRESS = "";
    @ConfigAttribute(type=Integer.class, min=0, max=65535)
    public static final String REDIS_PORT_NAME = "redis-port";
    public static final int DEFAULT_REDIS_PORT = 0;
    @ConfigAttribute(type=String.class)
    public static final String REDIS_BIND_ADDRESS_NAME = "redis-bind-address";
    public static final String DEFAULT_REDIS_BIND_ADDRESS = "";
    @ConfigAttribute(type=String.class)
    public static final String REDIS_PASSWORD_NAME = "redis-password";
    public static final String DEFAULT_REDIS_PASSWORD = "";
    @ConfigAttribute(type=Integer.class, min=0, max=65535)
    public static final String HTTP_SERVICE_PORT_NAME = "http-service-port";
    public static final int DEFAULT_HTTP_SERVICE_PORT = 7070;
    @ConfigAttribute(type=String.class)
    public static final String HTTP_SERVICE_BIND_ADDRESS_NAME = "http-service-bind-address";
    public static final String DEFAULT_HTTP_SERVICE_BIND_ADDRESS = "";
    public static final boolean DEFAULT_HTTP_SERVICE_SSL_ENABLED = false;
    @ConfigAttribute(type=Boolean.class)
    public static final String HTTP_SERVICE_SSL_ENABLED_NAME = "http-service-ssl-enabled";
    public static final boolean DEFAULT_HTTP_SERVICE_SSL_REQUIRE_AUTHENTICATION = false;
    @ConfigAttribute(type=Boolean.class)
    public static final String HTTP_SERVICE_SSL_REQUIRE_AUTHENTICATION_NAME = "http-service-ssl-require-authentication";
    public static final String DEFAULT_HTTP_SERVICE_SSL_PROTOCOLS = "any";
    @ConfigAttribute(type=String.class)
    public static final String HTTP_SERVICE_SSL_PROTOCOLS_NAME = "http-service-ssl-protocols";
    public static final String DEFAULT_HTTP_SERVICE_SSL_CIPHERS = "any";
    @ConfigAttribute(type=String.class)
    public static final String HTTP_SERVICE_SSL_CIPHERS_NAME = "http-service-ssl-ciphers";
    public static final String DEFAULT_HTTP_SERVICE_SSL_KEYSTORE = "";
    @ConfigAttribute(type=String.class)
    public static final String HTTP_SERVICE_SSL_KEYSTORE_NAME = "http-service-ssl-keystore";
    public static final String DEFAULT_HTTP_SERVICE_SSL_KEYSTORE_PASSWORD = "";
    @ConfigAttribute(type=String.class)
    public static final String HTTP_SERVICE_SSL_KEYSTORE_PASSWORD_NAME = "http-service-ssl-keystore-password";
    public static final String DEFAULT_HTTP_SERVICE_SSL_KEYSTORE_TYPE = "";
    @ConfigAttribute(type=String.class)
    public static final String HTTP_SERVICE_SSL_KEYSTORE_TYPE_NAME = "http-service-ssl-keystore-type";
    public static final String DEFAULT_HTTP_SERVICE_SSL_TRUSTSTORE = "";
    @ConfigAttribute(type=String.class)
    public static final String HTTP_SERVICE_SSL_TRUSTSTORE_NAME = "http-service-ssl-truststore";
    public static final String DEFAULT_HTTP_SERVICE_SSL_TRUSTSTORE_PASSWORD = "";
    @ConfigAttribute(type=String.class)
    public static final String HTTP_SERVICE_SSL_TRUSTSTORE_PASSWORD_NAME = "http-service-ssl-truststore-password";
    @ConfigAttribute(type=Boolean.class)
    public static final String START_DEV_REST_API_NAME = "start-dev-rest-api";
    public static final boolean DEFAULT_START_DEV_REST_API = false;
    @ConfigAttribute(type=Boolean.class)
    public static final String DISABLE_AUTO_RECONNECT_NAME = "disable-auto-reconnect";
    public static final boolean DEFAULT_DISABLE_AUTO_RECONNECT = false;
    public static final boolean DEFAULT_SERVER_SSL_ENABLED = false;
    @ConfigAttribute(type=Boolean.class)
    public static final String SERVER_SSL_ENABLED_NAME = "server-ssl-enabled";
    public static final String DEFAULT_SERVER_SSL_PROTOCOLS = "any";
    @ConfigAttribute(type=String.class)
    public static final String SERVER_SSL_PROTOCOLS_NAME = "server-ssl-protocols";
    public static final String DEFAULT_SERVER_SSL_CIPHERS = "any";
    @ConfigAttribute(type=String.class)
    public static final String SERVER_SSL_CIPHERS_NAME = "server-ssl-ciphers";
    public static final boolean DEFAULT_SERVER_SSL_REQUIRE_AUTHENTICATION = true;
    @ConfigAttribute(type=Boolean.class)
    public static final String SERVER_SSL_REQUIRE_AUTHENTICATION_NAME = "server-ssl-require-authentication";
    public static final String DEFAULT_SERVER_SSL_KEYSTORE = "";
    @ConfigAttribute(type=String.class)
    public static final String SERVER_SSL_KEYSTORE_NAME = "server-ssl-keystore";
    public static final String DEFAULT_SERVER_SSL_KEYSTORE_TYPE = "";
    @ConfigAttribute(type=String.class)
    public static final String SERVER_SSL_KEYSTORE_TYPE_NAME = "server-ssl-keystore-type";
    public static final String DEFAULT_SERVER_SSL_KEYSTORE_PASSWORD = "";
    @ConfigAttribute(type=String.class)
    public static final String SERVER_SSL_KEYSTORE_PASSWORD_NAME = "server-ssl-keystore-password";
    public static final String DEFAULT_SERVER_SSL_TRUSTSTORE = "";
    @ConfigAttribute(type=String.class)
    public static final String SERVER_SSL_TRUSTSTORE_NAME = "server-ssl-truststore";
    public static final String DEFAULT_SERVER_SSL_TRUSTSTORE_PASSWORD = "";
    @ConfigAttribute(type=String.class)
    public static final String SERVER_SSL_TRUSTSTORE_PASSWORD_NAME = "server-ssl-truststore-password";
    public static final boolean DEFAULT_GATEWAY_SSL_ENABLED = false;
    @ConfigAttribute(type=Boolean.class)
    public static final String GATEWAY_SSL_ENABLED_NAME = "gateway-ssl-enabled";
    public static final String DEFAULT_GATEWAY_SSL_PROTOCOLS = "any";
    @ConfigAttribute(type=String.class)
    public static final String GATEWAY_SSL_PROTOCOLS_NAME = "gateway-ssl-protocols";
    public static final String DEFAULT_GATEWAY_SSL_CIPHERS = "any";
    @ConfigAttribute(type=String.class)
    public static final String GATEWAY_SSL_CIPHERS_NAME = "gateway-ssl-ciphers";
    public static final boolean DEFAULT_GATEWAY_SSL_REQUIRE_AUTHENTICATION = true;
    @ConfigAttribute(type=Boolean.class)
    public static final String GATEWAY_SSL_REQUIRE_AUTHENTICATION_NAME = "gateway-ssl-require-authentication";
    public static final String DEFAULT_GATEWAY_SSL_KEYSTORE = "";
    @ConfigAttribute(type=String.class)
    public static final String GATEWAY_SSL_KEYSTORE_NAME = "gateway-ssl-keystore";
    public static final String DEFAULT_GATEWAY_SSL_KEYSTORE_TYPE = "";
    @ConfigAttribute(type=String.class)
    public static final String GATEWAY_SSL_KEYSTORE_TYPE_NAME = "gateway-ssl-keystore-type";
    public static final String DEFAULT_GATEWAY_SSL_KEYSTORE_PASSWORD = "";
    @ConfigAttribute(type=String.class)
    public static final String GATEWAY_SSL_KEYSTORE_PASSWORD_NAME = "gateway-ssl-keystore-password";
    public static final String DEFAULT_GATEWAY_SSL_TRUSTSTORE = "";
    @ConfigAttribute(type=String.class)
    public static final String GATEWAY_SSL_TRUSTSTORE_NAME = "gateway-ssl-truststore";
    public static final String DEFAULT_GATEWAY_SSL_TRUSTSTORE_PASSWORD = "";
    @ConfigAttribute(type=String.class)
    public static final String GATEWAY_SSL_TRUSTSTORE_PASSWORD_NAME = "gateway-ssl-truststore-password";
    @ConfigAttribute(type=Boolean.class)
    public static final String LOCK_MEMORY_NAME = "lock-memory";
    public static final boolean DEFAULT_LOCK_MEMORY = false;
    public static final Map<String, ConfigAttribute> attributes = new HashMap<String, ConfigAttribute>();
    public static final Map<String, Method> setters = new HashMap<String, Method>();
    public static final Map<String, Method> getters = new HashMap<String, Method>();
    public static final String[] dcValidAttributeNames = DistributionConfig.init();

    @Override
    @ConfigAttributeGetter(name="name")
    public String getName();

    @ConfigAttributeSetter(name="name")
    public void setName(String var1);

    @ConfigAttributeGetter(name="mcast-port")
    public int getMcastPort();

    @ConfigAttributeSetter(name="mcast-port")
    public void setMcastPort(int var1);

    @ConfigAttributeGetter(name="tcp-port")
    public int getTcpPort();

    @ConfigAttributeSetter(name="tcp-port")
    public void setTcpPort(int var1);

    @ConfigAttributeGetter(name="mcast-address")
    public InetAddress getMcastAddress();

    @ConfigAttributeSetter(name="mcast-address")
    public void setMcastAddress(InetAddress var1);

    @ConfigAttributeGetter(name="mcast-ttl")
    public int getMcastTtl();

    @ConfigAttributeSetter(name="mcast-ttl")
    public void setMcastTtl(int var1);

    @ConfigAttributeGetter(name="bind-address")
    public String getBindAddress();

    @ConfigAttributeSetter(name="bind-address")
    public void setBindAddress(String var1);

    @ConfigAttributeGetter(name="server-bind-address")
    public String getServerBindAddress();

    @ConfigAttributeSetter(name="server-bind-address")
    public void setServerBindAddress(String var1);

    @ConfigAttributeGetter(name="locators")
    public String getLocators();

    @ConfigAttributeSetter(name="locators")
    public void setLocators(String var1);

    @ConfigAttributeGetter(name="locator-wait-time")
    public int getLocatorWaitTime();

    @ConfigAttributeSetter(name="locator-wait-time")
    public void setLocatorWaitTime(int var1);

    @ConfigAttributeGetter(name="start-locator")
    public String getStartLocator();

    @ConfigAttributeSetter(name="start-locator")
    public void setStartLocator(String var1);

    @ConfigAttributeGetter(name="deploy-working-dir")
    public File getDeployWorkingDir();

    @ConfigAttributeSetter(name="deploy-working-dir")
    public void setDeployWorkingDir(File var1);

    @ConfigAttributeGetter(name="user-command-packages")
    public String getUserCommandPackages();

    @ConfigAttributeSetter(name="user-command-packages")
    public void setUserCommandPackages(String var1);

    @Override
    @ConfigAttributeGetter(name="log-file")
    public File getLogFile();

    @ConfigAttributeSetter(name="log-file")
    public void setLogFile(File var1);

    @Override
    @ConfigAttributeGetter(name="log-level")
    public int getLogLevel();

    @ConfigAttributeSetter(name="log-level")
    public void setLogLevel(int var1);

    @ConfigAttributeGetter(name="statistic-sampling-enabled")
    public boolean getStatisticSamplingEnabled();

    @ConfigAttributeSetter(name="statistic-sampling-enabled")
    public void setStatisticSamplingEnabled(boolean var1);

    @ConfigAttributeGetter(name="statistic-sample-rate")
    public int getStatisticSampleRate();

    @ConfigAttributeSetter(name="statistic-sample-rate")
    public void setStatisticSampleRate(int var1);

    @ConfigAttributeGetter(name="statistic-archive-file")
    public File getStatisticArchiveFile();

    @ConfigAttributeSetter(name="statistic-archive-file")
    public void setStatisticArchiveFile(File var1);

    @ConfigAttributeGetter(name="cache-xml-file")
    public File getCacheXmlFile();

    @ConfigAttributeSetter(name="cache-xml-file")
    public void setCacheXmlFile(File var1);

    @ConfigAttributeGetter(name="ack-wait-threshold")
    public int getAckWaitThreshold();

    @ConfigAttributeSetter(name="ack-wait-threshold")
    public void setAckWaitThreshold(int var1);

    @ConfigAttributeGetter(name="ack-severe-alert-threshold")
    public int getAckSevereAlertThreshold();

    @ConfigAttributeSetter(name="ack-severe-alert-threshold")
    public void setAckSevereAlertThreshold(int var1);

    @ConfigAttributeGetter(name="archive-file-size-limit")
    public int getArchiveFileSizeLimit();

    @ConfigAttributeSetter(name="archive-file-size-limit")
    public void setArchiveFileSizeLimit(int var1);

    @ConfigAttributeGetter(name="archive-disk-space-limit")
    public int getArchiveDiskSpaceLimit();

    @ConfigAttributeSetter(name="archive-disk-space-limit")
    public void setArchiveDiskSpaceLimit(int var1);

    @Override
    @ConfigAttributeGetter(name="log-file-size-limit")
    public int getLogFileSizeLimit();

    @ConfigAttributeSetter(name="log-file-size-limit")
    public void setLogFileSizeLimit(int var1);

    @Override
    @ConfigAttributeGetter(name="log-disk-space-limit")
    public int getLogDiskSpaceLimit();

    @ConfigAttributeSetter(name="log-disk-space-limit")
    public void setLogDiskSpaceLimit(int var1);

    @ConfigAttributeGetter(name="ssl-enabled")
    public boolean getSSLEnabled();

    @ConfigAttributeSetter(name="ssl-enabled")
    public void setSSLEnabled(boolean var1);

    @ConfigAttributeGetter(name="ssl-protocols")
    public String getSSLProtocols();

    @ConfigAttributeSetter(name="ssl-protocols")
    public void setSSLProtocols(String var1);

    @ConfigAttributeGetter(name="ssl-ciphers")
    public String getSSLCiphers();

    @ConfigAttributeSetter(name="ssl-ciphers")
    public void setSSLCiphers(String var1);

    @ConfigAttributeGetter(name="ssl-require-authentication")
    public boolean getSSLRequireAuthentication();

    @ConfigAttributeSetter(name="ssl-require-authentication")
    public void setSSLRequireAuthentication(boolean var1);

    @ConfigAttributeGetter(name="cluster-ssl-enabled")
    public boolean getClusterSSLEnabled();

    @ConfigAttributeSetter(name="cluster-ssl-enabled")
    public void setClusterSSLEnabled(boolean var1);

    @ConfigAttributeGetter(name="cluster-ssl-protocols")
    public String getClusterSSLProtocols();

    @ConfigAttributeSetter(name="cluster-ssl-protocols")
    public void setClusterSSLProtocols(String var1);

    @ConfigAttributeGetter(name="cluster-ssl-ciphers")
    public String getClusterSSLCiphers();

    @ConfigAttributeSetter(name="cluster-ssl-ciphers")
    public void setClusterSSLCiphers(String var1);

    @ConfigAttributeGetter(name="cluster-ssl-require-authentication")
    public boolean getClusterSSLRequireAuthentication();

    @ConfigAttributeSetter(name="cluster-ssl-require-authentication")
    public void setClusterSSLRequireAuthentication(boolean var1);

    @ConfigAttributeGetter(name="cluster-ssl-keystore")
    public String getClusterSSLKeyStore();

    @ConfigAttributeSetter(name="cluster-ssl-keystore")
    public void setClusterSSLKeyStore(String var1);

    @ConfigAttributeGetter(name="cluster-ssl-keystore-type")
    public String getClusterSSLKeyStoreType();

    @ConfigAttributeSetter(name="cluster-ssl-keystore-type")
    public void setClusterSSLKeyStoreType(String var1);

    @ConfigAttributeGetter(name="cluster-ssl-keystore-password")
    public String getClusterSSLKeyStorePassword();

    @ConfigAttributeSetter(name="cluster-ssl-keystore-password")
    public void setClusterSSLKeyStorePassword(String var1);

    @ConfigAttributeGetter(name="cluster-ssl-truststore")
    public String getClusterSSLTrustStore();

    @ConfigAttributeSetter(name="cluster-ssl-truststore")
    public void setClusterSSLTrustStore(String var1);

    @ConfigAttributeGetter(name="cluster-ssl-truststore-password")
    public String getClusterSSLTrustStorePassword();

    @ConfigAttributeSetter(name="cluster-ssl-truststore-password")
    public void setClusterSSLTrustStorePassword(String var1);

    @ConfigAttributeGetter(name="socket-lease-time")
    public int getSocketLeaseTime();

    @ConfigAttributeSetter(name="socket-lease-time")
    public void setSocketLeaseTime(int var1);

    @ConfigAttributeGetter(name="socket-buffer-size")
    public int getSocketBufferSize();

    @ConfigAttributeSetter(name="socket-buffer-size")
    public void setSocketBufferSize(int var1);

    @ConfigAttributeGetter(name="mcast-send-buffer-size")
    public int getMcastSendBufferSize();

    @ConfigAttributeSetter(name="mcast-send-buffer-size")
    public void setMcastSendBufferSize(int var1);

    @ConfigAttributeGetter(name="mcast-recv-buffer-size")
    public int getMcastRecvBufferSize();

    @ConfigAttributeSetter(name="mcast-recv-buffer-size")
    public void setMcastRecvBufferSize(int var1);

    @ConfigAttributeGetter(name="mcast-flow-control")
    public FlowControlParams getMcastFlowControl();

    @ConfigAttributeSetter(name="mcast-flow-control")
    public void setMcastFlowControl(FlowControlParams var1);

    @ConfigAttributeGetter(name="udp-fragment-size")
    public int getUdpFragmentSize();

    @ConfigAttributeSetter(name="udp-fragment-size")
    public void setUdpFragmentSize(int var1);

    @ConfigAttributeGetter(name="udp-send-buffer-size")
    public int getUdpSendBufferSize();

    @ConfigAttributeSetter(name="udp-send-buffer-size")
    public void setUdpSendBufferSize(int var1);

    @ConfigAttributeGetter(name="udp-recv-buffer-size")
    public int getUdpRecvBufferSize();

    @ConfigAttributeSetter(name="udp-recv-buffer-size")
    public void setUdpRecvBufferSize(int var1);

    @ConfigAttributeGetter(name="disable-tcp")
    public boolean getDisableTcp();

    @ConfigAttributeSetter(name="disable-tcp")
    public void setDisableTcp(boolean var1);

    @ConfigAttributeSetter(name="enable-time-statistics")
    public void setEnableTimeStatistics(boolean var1);

    @ConfigAttributeGetter(name="enable-time-statistics")
    public boolean getEnableTimeStatistics();

    @ConfigAttributeSetter(name="use-cluster-configuration")
    public void setUseSharedConfiguration(boolean var1);

    @ConfigAttributeGetter(name="use-cluster-configuration")
    public boolean getUseSharedConfiguration();

    @ConfigAttributeSetter(name="enable-cluster-configuration")
    public void setEnableClusterConfiguration(boolean var1);

    @ConfigAttributeGetter(name="enable-cluster-configuration")
    public boolean getEnableClusterConfiguration();

    @ConfigAttributeGetter(name="load-cluster-configuration-from-dir")
    public boolean getLoadClusterConfigFromDir();

    @ConfigAttributeSetter(name="load-cluster-configuration-from-dir")
    public void setLoadClusterConfigFromDir(boolean var1);

    @ConfigAttributeGetter(name="cluster-configuration-dir")
    public String getClusterConfigDir();

    @ConfigAttributeSetter(name="cluster-configuration-dir")
    public void setClusterConfigDir(String var1);

    @ConfigAttributeSetter(name="enable-network-partition-detection")
    public void setEnableNetworkPartitionDetection(boolean var1);

    @ConfigAttributeGetter(name="enable-network-partition-detection")
    public boolean getEnableNetworkPartitionDetection();

    @ConfigAttributeGetter(name="member-timeout")
    public int getMemberTimeout();

    @ConfigAttributeSetter(name="member-timeout")
    public void setMemberTimeout(int var1);

    @ConfigAttributeGetter(name="membership-port-range")
    public int[] getMembershipPortRange();

    @ConfigAttributeSetter(name="membership-port-range")
    public void setMembershipPortRange(int[] var1);

    @ConfigAttributeGetter(name="conserve-sockets")
    public boolean getConserveSockets();

    @ConfigAttributeSetter(name="conserve-sockets")
    public void setConserveSockets(boolean var1);

    @ConfigAttributeGetter(name="roles")
    public String getRoles();

    @ConfigAttributeSetter(name="roles")
    public void setRoles(String var1);

    @ConfigAttributeSetter(name="max-wait-time-reconnect")
    public void setMaxWaitTimeForReconnect(int var1);

    @ConfigAttributeGetter(name="max-wait-time-reconnect")
    public int getMaxWaitTimeForReconnect();

    @ConfigAttributeSetter(name="max-num-reconnect-tries")
    public void setMaxNumReconnectTries(int var1);

    @ConfigAttributeGetter(name="max-num-reconnect-tries")
    public int getMaxNumReconnectTries();

    @ConfigAttributeGetter(name="async-distribution-timeout")
    public int getAsyncDistributionTimeout();

    @ConfigAttributeSetter(name="async-distribution-timeout")
    public void setAsyncDistributionTimeout(int var1);

    @ConfigAttributeGetter(name="async-queue-timeout")
    public int getAsyncQueueTimeout();

    @ConfigAttributeSetter(name="async-queue-timeout")
    public void setAsyncQueueTimeout(int var1);

    @ConfigAttributeGetter(name="async-max-queue-size")
    public int getAsyncMaxQueueSize();

    @ConfigAttributeSetter(name="async-max-queue-size")
    public void setAsyncMaxQueueSize(int var1);

    @ConfigAttributeGetter(name="distributed-transactions")
    public boolean getDistributedTransactions();

    @ConfigAttributeSetter(name="distributed-transactions")
    public void setDistributedTransactions(boolean var1);

    @ConfigAttributeGetter(name="conflate-events")
    public String getClientConflation();

    @ConfigAttributeSetter(name="conflate-events")
    public void setClientConflation(String var1);

    @ConfigAttributeGetter(name="durable-client-id")
    public String getDurableClientId();

    @ConfigAttributeSetter(name="durable-client-id")
    public void setDurableClientId(String var1);

    @ConfigAttributeGetter(name="durable-client-timeout")
    public int getDurableClientTimeout();

    @ConfigAttributeSetter(name="durable-client-timeout")
    public void setDurableClientTimeout(int var1);

    @ConfigAttributeGetter(name="security-client-auth-init")
    public String getSecurityClientAuthInit();

    @ConfigAttributeSetter(name="security-client-auth-init")
    public void setSecurityClientAuthInit(String var1);

    @ConfigAttributeGetter(name="security-client-authenticator")
    public String getSecurityClientAuthenticator();

    @ConfigAttributeSetter(name="security-client-authenticator")
    public void setSecurityClientAuthenticator(String var1);

    @ConfigAttributeGetter(name="security-client-dhalgo")
    public String getSecurityClientDHAlgo();

    @ConfigAttributeSetter(name="security-client-dhalgo")
    public void setSecurityClientDHAlgo(String var1);

    @ConfigAttributeGetter(name="security-peer-auth-init")
    public String getSecurityPeerAuthInit();

    @ConfigAttributeSetter(name="security-peer-auth-init")
    public void setSecurityPeerAuthInit(String var1);

    @ConfigAttributeGetter(name="security-peer-authenticator")
    public String getSecurityPeerAuthenticator();

    @ConfigAttributeSetter(name="security-peer-authenticator")
    public void setSecurityPeerAuthenticator(String var1);

    @ConfigAttributeGetter(name="security-client-accessor")
    public String getSecurityClientAccessor();

    @ConfigAttributeSetter(name="security-client-accessor")
    public void setSecurityClientAccessor(String var1);

    @ConfigAttributeGetter(name="security-client-accessor-pp")
    public String getSecurityClientAccessorPP();

    @ConfigAttributeSetter(name="security-client-accessor-pp")
    public void setSecurityClientAccessorPP(String var1);

    @ConfigAttributeGetter(name="security-log-level")
    public int getSecurityLogLevel();

    @ConfigAttributeSetter(name="security-log-level")
    public void setSecurityLogLevel(int var1);

    @ConfigAttributeGetter(name="security-log-file")
    public File getSecurityLogFile();

    @ConfigAttributeSetter(name="security-log-file")
    public void setSecurityLogFile(File var1);

    @ConfigAttributeGetter(name="security-peer-verifymember-timeout")
    public int getSecurityPeerMembershipTimeout();

    @ConfigAttributeSetter(name="security-peer-verifymember-timeout")
    public void setSecurityPeerMembershipTimeout(int var1);

    public Properties getSecurityProps();

    public String getSecurity(String var1);

    public void setSecurity(String var1, String var2);

    @ConfigAttributeGetter(name="remove-unresponsive-client")
    public boolean getRemoveUnresponsiveClient();

    @ConfigAttributeSetter(name="remove-unresponsive-client")
    public void setRemoveUnresponsiveClient(boolean var1);

    @ConfigAttributeGetter(name="delta-propagation")
    public boolean getDeltaPropagation();

    @ConfigAttributeSetter(name="delta-propagation")
    public void setDeltaPropagation(boolean var1);

    @ConfigAttributeSetter(name="distributed-system-id")
    public void setDistributedSystemId(int var1);

    @ConfigAttributeSetter(name="redundancy-zone")
    public void setRedundancyZone(String var1);

    @ConfigAttributeGetter(name="distributed-system-id")
    public int getDistributedSystemId();

    @ConfigAttributeGetter(name="redundancy-zone")
    public String getRedundancyZone();

    public void setSSLProperty(String var1, String var2);

    public Properties getSSLProperties();

    public Properties getClusterSSLProperties();

    public Properties getJmxSSLProperties();

    @ConfigAttributeSetter(name="enforce-unique-host")
    public void setEnforceUniqueHost(boolean var1);

    @ConfigAttributeGetter(name="enforce-unique-host")
    public boolean getEnforceUniqueHost();

    public Properties getUserDefinedProps();

    @ConfigAttributeGetter(name="groups")
    public String getGroups();

    @ConfigAttributeSetter(name="groups")
    public void setGroups(String var1);

    public void close();

    @ConfigAttributeSetter(name="remote-locators")
    public void setRemoteLocators(String var1);

    @ConfigAttributeGetter(name="remote-locators")
    public String getRemoteLocators();

    @ConfigAttributeGetter(name="jmx-manager")
    public boolean getJmxManager();

    @ConfigAttributeSetter(name="jmx-manager")
    public void setJmxManager(boolean var1);

    @ConfigAttributeGetter(name="jmx-manager-start")
    public boolean getJmxManagerStart();

    @ConfigAttributeSetter(name="jmx-manager-start")
    public void setJmxManagerStart(boolean var1);

    @ConfigAttributeGetter(name="jmx-manager-port")
    public int getJmxManagerPort();

    @ConfigAttributeSetter(name="jmx-manager-port")
    public void setJmxManagerPort(int var1);

    @ConfigAttributeGetter(name="jmx-manager-ssl")
    public boolean getJmxManagerSSL();

    @ConfigAttributeSetter(name="jmx-manager-ssl")
    public void setJmxManagerSSL(boolean var1);

    @ConfigAttributeGetter(name="jmx-manager-ssl-enabled")
    public boolean getJmxManagerSSLEnabled();

    @ConfigAttributeSetter(name="jmx-manager-ssl-enabled")
    public void setJmxManagerSSLEnabled(boolean var1);

    @ConfigAttributeGetter(name="off-heap-memory-size")
    public String getOffHeapMemorySize();

    @ConfigAttributeSetter(name="off-heap-memory-size")
    public void setOffHeapMemorySize(String var1);

    @ConfigAttributeGetter(name="jmx-manager-ssl-protocols")
    public String getJmxManagerSSLProtocols();

    @ConfigAttributeSetter(name="jmx-manager-ssl-protocols")
    public void setJmxManagerSSLProtocols(String var1);

    @ConfigAttributeGetter(name="jmx-manager-ssl-ciphers")
    public String getJmxManagerSSLCiphers();

    @ConfigAttributeSetter(name="jmx-manager-ssl-ciphers")
    public void setJmxManagerSSLCiphers(String var1);

    @ConfigAttributeGetter(name="jmx-manager-ssl-require-authentication")
    public boolean getJmxManagerSSLRequireAuthentication();

    @ConfigAttributeSetter(name="jmx-manager-ssl-require-authentication")
    public void setJmxManagerSSLRequireAuthentication(boolean var1);

    @ConfigAttributeGetter(name="jmx-manager-ssl-keystore")
    public String getJmxManagerSSLKeyStore();

    @ConfigAttributeSetter(name="jmx-manager-ssl-keystore")
    public void setJmxManagerSSLKeyStore(String var1);

    @ConfigAttributeGetter(name="jmx-manager-ssl-keystore-type")
    public String getJmxManagerSSLKeyStoreType();

    @ConfigAttributeSetter(name="jmx-manager-ssl-keystore-type")
    public void setJmxManagerSSLKeyStoreType(String var1);

    @ConfigAttributeGetter(name="jmx-manager-ssl-keystore-password")
    public String getJmxManagerSSLKeyStorePassword();

    @ConfigAttributeSetter(name="jmx-manager-ssl-keystore-password")
    public void setJmxManagerSSLKeyStorePassword(String var1);

    @ConfigAttributeGetter(name="jmx-manager-ssl-truststore")
    public String getJmxManagerSSLTrustStore();

    @ConfigAttributeSetter(name="jmx-manager-ssl-truststore")
    public void setJmxManagerSSLTrustStore(String var1);

    @ConfigAttributeGetter(name="jmx-manager-ssl-truststore-password")
    public String getJmxManagerSSLTrustStorePassword();

    @ConfigAttributeSetter(name="jmx-manager-ssl-truststore-password")
    public void setJmxManagerSSLTrustStorePassword(String var1);

    @ConfigAttributeGetter(name="jmx-manager-bind-address")
    public String getJmxManagerBindAddress();

    @ConfigAttributeSetter(name="jmx-manager-bind-address")
    public void setJmxManagerBindAddress(String var1);

    @ConfigAttributeGetter(name="jmx-manager-hostname-for-clients")
    public String getJmxManagerHostnameForClients();

    @ConfigAttributeSetter(name="jmx-manager-hostname-for-clients")
    public void setJmxManagerHostnameForClients(String var1);

    @ConfigAttributeGetter(name="jmx-manager-password-file")
    public String getJmxManagerPasswordFile();

    @ConfigAttributeSetter(name="jmx-manager-password-file")
    public void setJmxManagerPasswordFile(String var1);

    @ConfigAttributeGetter(name="jmx-manager-access-file")
    public String getJmxManagerAccessFile();

    @ConfigAttributeSetter(name="jmx-manager-access-file")
    public void setJmxManagerAccessFile(String var1);

    @ConfigAttributeGetter(name="jmx-manager-http-port")
    public int getJmxManagerHttpPort();

    @ConfigAttributeSetter(name="jmx-manager-http-port")
    public void setJmxManagerHttpPort(int var1);

    @ConfigAttributeGetter(name="jmx-manager-update-rate")
    public int getJmxManagerUpdateRate();

    @ConfigAttributeSetter(name="jmx-manager-update-rate")
    public void setJmxManagerUpdateRate(int var1);

    @ConfigAttributeGetter(name="memcached-port")
    public int getMemcachedPort();

    @ConfigAttributeSetter(name="memcached-port")
    public void setMemcachedPort(int var1);

    @ConfigAttributeGetter(name="memcached-protocol")
    public String getMemcachedProtocol();

    @ConfigAttributeSetter(name="memcached-protocol")
    public void setMemcachedProtocol(String var1);

    @ConfigAttributeGetter(name="memcached-bind-address")
    public String getMemcachedBindAddress();

    @ConfigAttributeSetter(name="memcached-bind-address")
    public void setMemcachedBindAddress(String var1);

    @ConfigAttributeGetter(name="redis-port")
    public int getRedisPort();

    @ConfigAttributeSetter(name="redis-port")
    public void setRedisPort(int var1);

    @ConfigAttributeGetter(name="redis-bind-address")
    public String getRedisBindAddress();

    @ConfigAttributeSetter(name="redis-bind-address")
    public void setRedisBindAddress(String var1);

    @ConfigAttributeGetter(name="redis-password")
    public String getRedisPassword();

    @ConfigAttributeSetter(name="redis-password")
    public void setRedisPassword(String var1);

    @ConfigAttributeGetter(name="http-service-port")
    public int getHttpServicePort();

    @ConfigAttributeSetter(name="http-service-port")
    public void setHttpServicePort(int var1);

    @ConfigAttributeGetter(name="http-service-bind-address")
    public String getHttpServiceBindAddress();

    @ConfigAttributeSetter(name="http-service-bind-address")
    public void setHttpServiceBindAddress(String var1);

    @ConfigAttributeGetter(name="http-service-ssl-enabled")
    public boolean getHttpServiceSSLEnabled();

    @ConfigAttributeSetter(name="http-service-ssl-enabled")
    public void setHttpServiceSSLEnabled(boolean var1);

    @ConfigAttributeGetter(name="http-service-ssl-require-authentication")
    public boolean getHttpServiceSSLRequireAuthentication();

    @ConfigAttributeSetter(name="http-service-ssl-require-authentication")
    public void setHttpServiceSSLRequireAuthentication(boolean var1);

    @ConfigAttributeGetter(name="http-service-ssl-protocols")
    public String getHttpServiceSSLProtocols();

    @ConfigAttributeSetter(name="http-service-ssl-protocols")
    public void setHttpServiceSSLProtocols(String var1);

    @ConfigAttributeGetter(name="http-service-ssl-ciphers")
    public String getHttpServiceSSLCiphers();

    @ConfigAttributeSetter(name="http-service-ssl-ciphers")
    public void setHttpServiceSSLCiphers(String var1);

    @ConfigAttributeGetter(name="http-service-ssl-keystore")
    public String getHttpServiceSSLKeyStore();

    @ConfigAttributeSetter(name="http-service-ssl-keystore")
    public void setHttpServiceSSLKeyStore(String var1);

    @ConfigAttributeGetter(name="http-service-ssl-keystore-password")
    public String getHttpServiceSSLKeyStorePassword();

    @ConfigAttributeSetter(name="http-service-ssl-keystore-password")
    public void setHttpServiceSSLKeyStorePassword(String var1);

    @ConfigAttributeGetter(name="http-service-ssl-keystore-type")
    public String getHttpServiceSSLKeyStoreType();

    @ConfigAttributeSetter(name="http-service-ssl-keystore-type")
    public void setHttpServiceSSLKeyStoreType(String var1);

    @ConfigAttributeGetter(name="http-service-ssl-truststore")
    public String getHttpServiceSSLTrustStore();

    @ConfigAttributeSetter(name="http-service-ssl-truststore")
    public void setHttpServiceSSLTrustStore(String var1);

    @ConfigAttributeGetter(name="http-service-ssl-truststore-password")
    public String getHttpServiceSSLTrustStorePassword();

    @ConfigAttributeSetter(name="http-service-ssl-truststore-password")
    public void setHttpServiceSSLTrustStorePassword(String var1);

    public Properties getHttpServiceSSLProperties();

    @ConfigAttributeGetter(name="start-dev-rest-api")
    public boolean getStartDevRestApi();

    @ConfigAttributeSetter(name="start-dev-rest-api")
    public void setStartDevRestApi(boolean var1);

    @ConfigAttributeGetter(name="disable-auto-reconnect")
    public boolean getDisableAutoReconnect();

    @ConfigAttributeSetter(name="disable-auto-reconnect")
    public void setDisableAutoReconnect(boolean var1);

    public Properties getServerSSLProperties();

    @ConfigAttributeGetter(name="server-ssl-enabled")
    public boolean getServerSSLEnabled();

    @ConfigAttributeSetter(name="server-ssl-enabled")
    public void setServerSSLEnabled(boolean var1);

    @ConfigAttributeGetter(name="server-ssl-protocols")
    public String getServerSSLProtocols();

    @ConfigAttributeSetter(name="server-ssl-protocols")
    public void setServerSSLProtocols(String var1);

    @ConfigAttributeGetter(name="server-ssl-ciphers")
    public String getServerSSLCiphers();

    @ConfigAttributeSetter(name="server-ssl-ciphers")
    public void setServerSSLCiphers(String var1);

    @ConfigAttributeGetter(name="server-ssl-require-authentication")
    public boolean getServerSSLRequireAuthentication();

    @ConfigAttributeSetter(name="server-ssl-require-authentication")
    public void setServerSSLRequireAuthentication(boolean var1);

    @ConfigAttributeGetter(name="server-ssl-keystore")
    public String getServerSSLKeyStore();

    @ConfigAttributeSetter(name="server-ssl-keystore")
    public void setServerSSLKeyStore(String var1);

    @ConfigAttributeGetter(name="server-ssl-keystore-type")
    public String getServerSSLKeyStoreType();

    @ConfigAttributeSetter(name="server-ssl-keystore-type")
    public void setServerSSLKeyStoreType(String var1);

    @ConfigAttributeGetter(name="server-ssl-keystore-password")
    public String getServerSSLKeyStorePassword();

    @ConfigAttributeSetter(name="server-ssl-keystore-password")
    public void setServerSSLKeyStorePassword(String var1);

    @ConfigAttributeGetter(name="server-ssl-truststore")
    public String getServerSSLTrustStore();

    @ConfigAttributeSetter(name="server-ssl-truststore")
    public void setServerSSLTrustStore(String var1);

    @ConfigAttributeGetter(name="server-ssl-truststore-password")
    public String getServerSSLTrustStorePassword();

    @ConfigAttributeSetter(name="server-ssl-truststore-password")
    public void setServerSSLTrustStorePassword(String var1);

    @ConfigAttributeGetter(name="gateway-ssl-enabled")
    public boolean getGatewaySSLEnabled();

    @ConfigAttributeSetter(name="gateway-ssl-enabled")
    public void setGatewaySSLEnabled(boolean var1);

    @ConfigAttributeGetter(name="gateway-ssl-protocols")
    public String getGatewaySSLProtocols();

    @ConfigAttributeSetter(name="gateway-ssl-protocols")
    public void setGatewaySSLProtocols(String var1);

    @ConfigAttributeGetter(name="gateway-ssl-ciphers")
    public String getGatewaySSLCiphers();

    @ConfigAttributeSetter(name="gateway-ssl-ciphers")
    public void setGatewaySSLCiphers(String var1);

    @ConfigAttributeGetter(name="gateway-ssl-require-authentication")
    public boolean getGatewaySSLRequireAuthentication();

    @ConfigAttributeSetter(name="gateway-ssl-require-authentication")
    public void setGatewaySSLRequireAuthentication(boolean var1);

    @ConfigAttributeGetter(name="gateway-ssl-keystore")
    public String getGatewaySSLKeyStore();

    @ConfigAttributeSetter(name="gateway-ssl-keystore")
    public void setGatewaySSLKeyStore(String var1);

    @ConfigAttributeGetter(name="gateway-ssl-keystore-type")
    public String getGatewaySSLKeyStoreType();

    @ConfigAttributeSetter(name="gateway-ssl-keystore-type")
    public void setGatewaySSLKeyStoreType(String var1);

    @ConfigAttributeGetter(name="gateway-ssl-keystore-password")
    public String getGatewaySSLKeyStorePassword();

    @ConfigAttributeSetter(name="gateway-ssl-keystore-password")
    public void setGatewaySSLKeyStorePassword(String var1);

    @ConfigAttributeGetter(name="gateway-ssl-truststore")
    public String getGatewaySSLTrustStore();

    @ConfigAttributeSetter(name="gateway-ssl-truststore")
    public void setGatewaySSLTrustStore(String var1);

    @ConfigAttributeGetter(name="gateway-ssl-truststore-password")
    public String getGatewaySSLTrustStorePassword();

    @ConfigAttributeSetter(name="gateway-ssl-truststore-password")
    public void setGatewaySSLTrustStorePassword(String var1);

    public Properties getGatewaySSLProperties();

    public ConfigSource getConfigSource(String var1);

    @ConfigAttributeGetter(name="lock-memory")
    public boolean getLockMemory();

    @ConfigAttributeSetter(name="lock-memory")
    public void setLockMemory(boolean var1);

    public static String[] init() {
        ArrayList<String> atts = new ArrayList<String>();
        for (Field field : DistributionConfig.class.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigAttribute.class)) continue;
            try {
                atts.add((String)field.get(null));
                attributes.put((String)field.get(null), field.getAnnotation(ConfigAttribute.class));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        for (AccessibleObject accessibleObject : DistributionConfig.class.getDeclaredMethods()) {
            if (accessibleObject.isAnnotationPresent(ConfigAttributeGetter.class)) {
                ConfigAttributeGetter getter = ((Method)accessibleObject).getAnnotation(ConfigAttributeGetter.class);
                getters.put(getter.name(), (Method)accessibleObject);
                continue;
            }
            if (!accessibleObject.isAnnotationPresent(ConfigAttributeSetter.class)) continue;
            ConfigAttributeSetter setter = ((Method)accessibleObject).getAnnotation(ConfigAttributeSetter.class);
            setters.put(setter.name(), (Method)accessibleObject);
        }
        Collections.sort(atts);
        return atts.toArray(new String[atts.size()]);
    }
}

