/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.server.internal;

import com.gemstone.gemfire.cache.server.ServerMetrics;
import java.util.concurrent.atomic.AtomicInteger;

public class ServerMetricsImpl
implements ServerMetrics {
    private final AtomicInteger clientCount = new AtomicInteger();
    private final AtomicInteger connectionCount = new AtomicInteger();
    private final AtomicInteger queueCount = new AtomicInteger();
    private final int maxConnections;

    public ServerMetricsImpl(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Override
    public int getClientCount() {
        return this.clientCount.get();
    }

    @Override
    public int getConnectionCount() {
        return this.connectionCount.get();
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public int getSubscriptionConnectionCount() {
        return this.queueCount.get();
    }

    public void incClientCount() {
        this.clientCount.incrementAndGet();
    }

    public void decClientCount() {
        this.clientCount.decrementAndGet();
    }

    public void incConnectionCount() {
        this.connectionCount.incrementAndGet();
    }

    public void decConnectionCount() {
        this.connectionCount.decrementAndGet();
    }

    public void incQueueCount() {
        this.queueCount.incrementAndGet();
    }

    public void decQueueCount() {
        this.queueCount.decrementAndGet();
    }
}

