/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.cq;

import com.gemstone.gemfire.cache.query.internal.cq.CqService;
import com.gemstone.gemfire.cache.query.internal.cq.MissingCqService;
import com.gemstone.gemfire.cache.query.internal.cq.ServerCQ;
import com.gemstone.gemfire.cache.query.internal.cq.spi.CqServiceFactory;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import java.io.DataInput;
import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;

public class CqServiceProvider {
    private static final CqServiceFactory factory;
    public static boolean MAINTAIN_KEYS;
    public static boolean VMOTION_DURING_CQ_REGISTRATION_FLAG;

    public static CqService create(GemFireCacheImpl cache) {
        if (factory == null) {
            return new MissingCqService();
        }
        return factory.create(cache);
    }

    public static ServerCQ readCq(DataInput in) throws ClassNotFoundException, IOException {
        if (factory == null) {
            throw new IllegalStateException("CqService is not available.");
        }
        return factory.readCqQuery(in);
    }

    private CqServiceProvider() {
    }

    static {
        MAINTAIN_KEYS = Boolean.valueOf(System.getProperty("gemfire.cq.MAINTAIN_KEYS", "true"));
        VMOTION_DURING_CQ_REGISTRATION_FLAG = false;
        ServiceLoader<CqServiceFactory> loader = ServiceLoader.load(CqServiceFactory.class);
        Iterator<CqServiceFactory> itr = loader.iterator();
        if (!itr.hasNext()) {
            factory = null;
        } else {
            factory = itr.next();
            factory.initialize();
        }
    }
}

